<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Choose;
use Image;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;

class FrontEndChooseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $choose = Choose::latest()->where('status',1)->paginate(10);
        return view('admin.frontend.choose_section.all',compact('choose'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function add()
    {
        return view('admin.frontend.choose_section.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        // dd($request->all());
        $this->validate($request, [
         
            'title' => 'required',
            'subtitle' => 'required',
         

        ]);
       
        $add = new Choose;
        $add->title = $request->title;
        $add->subtitle = $request->subtitle;

        $add->details = $request->details;
        $add->creator = Auth::user()->id;
      
        if($request->hasFile('image')) {
            $user_img_name = $request->file('image');
            $user_name = time().'.'.$user_img_name->getClientOriginalExtension();
            $destinationPath = public_path('/uploads');
            $user_img_name->move($destinationPath, $user_name);
    
            $add->image = $user_name;
    
          }
   

        $add->save();

        if ($add) {
            return redirect()->route('admin_frontend_choose')->with('success', 'value');
        } else {
            return back()->with('error', 'value');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $choose = Choose::find($id);
        return view('admin.frontend.choose_section.view',compact('choose'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $choose = Choose::find($id);
        return view('admin.frontend.choose_section.edit',compact('choose'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $add =Choose::find($request->id);
        $add->title = $request->title;
        $add->subtitle = $request->subtitle;

        $add->details = $request->details;
        $add->creator = Auth::user()->id;
      
        if($request->hasFile('image')) {
            if(Storage::disk('public')->exists('uploads/'.$add->image)) Storage::disk('public')->delete('uploads/'.$add->image);
            $user_img_name = $request->file('image');
            $user_name = time().'.'.$user_img_name->getClientOriginalExtension();
            $destinationPath = public_path('/uploads');
            $user_img_name->move($destinationPath, $user_name);
    
            $add->image = $user_name;
    
          }

      
  

        $add->save();

        if ($add) {
            return redirect()->route('admin_frontend_choose')->with('success', 'value');
        } else {
            return back()->with('error', 'value');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Choose::findOrFail($id);

        $data->delete();
        // $data->save();
        if ($data) {
        return redirect()->route('admin_frontend_choose')->with('success-del', 'value');
        } else {
            return back()->with('error', 'value');
        }
    }
}
