<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Banner;
use Image;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\FrontendAboutHospital;
use App\FrontendContactInformation;

class FrontEndManagementController extends Controller
{
    public function banner(Request $request)
    {
        $banner = Banner::latest()->where('status', 1)->paginate(10);
        return view('admin.frontend.banner.all', compact('banner'));
    }

    public function banner_add(Request $request)
    {
        return view('admin.frontend.banner.add');
    }

    public function banner_view(Request $request)
    {
        $banner = Banner::find($request->id);
        return view('admin.frontend.banner.view', compact('banner'));
    }

    public function banner_edit(Request $request)
    {
        $banner = Banner::find($request->id);
        return view('admin.frontend.banner.edit', compact('banner'));
    }

    public function banner_deactive(Request $request)
    {
        $banner = Banner::find($request->id);
        $banner->status = 0;
        $banner->save();
        return redirect()->back()->with('success', '');
    }

    public function banner_delete(Request $request)
    {
        $banner = Banner::find($request->id);
        $banner->delete();
        $banner->save();
        return redirect()->back()->with('success', '');
    }

    public function banner_store(Request $request)
    {
        if (
            $request->title == '' ||
            $request->subtitle == '' ||
            $request->file('image') == ''
        ) {
            return response()->json([
                'error' => 'fill the required area',
                'title' => 'fill the required area',
                'subtitle' => 'required',
                'image' => 'required',
            ]);
        }
        // dd($request);

        $banner = new Banner();
        $banner->title = $request->title;
        $banner->subtitle = $request->subtitle;
        $banner->url = $request->url;

        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $image = Image::make($file);

            $banner->save();
            $imageName = $banner->id . '_' . uniqid(12) . '.' . $file->getClientOriginalExtension();
            $banner->image = 'uploads/banner/' . $imageName;

            $image->fit(1920, 700, function ($constraint) {
                $constraint->aspectRatio();
            });

            $img_canvas = Image::canvas(1920, 700);
            $img_canvas->insert($image, 'center');
            $img_canvas->save(public_path('uploads/banner/' . $imageName));
        }

        $banner->creator = Auth::user()->id;
        $banner->slug = $banner->id . '_' . uniqid(10);
        $banner->created_at = Carbon::now()->toDateTimeString();
        $banner->save();

        $banner = Banner::where('status', 1)->latest()->paginate(10);
        $table_view = View('admin.frontend.banner.table_data', ['banner' => $banner])->render();

        return response()->json([
            'error' => null,
            'data' => $banner,
            'table' => $table_view,
            'success' => 'Banner successfully updated.',
        ]);
    }

    public function banner_update(Request $request)
    {
        if (
            $request->title == '' ||
            $request->subtitle == ''
        ) {
            return response()->json([
                'error' => 'fill the required area',
                'title' => 'fill the required area',
                'subtitle' => 'required',
                'image' => 'required',
            ]);
        }
        // dd($request);

        $banner = Banner::find($request->id);
        $banner->title = $request->title;
        $banner->subtitle = $request->subtitle;
        $banner->url = $request->url;

        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $image = Image::make($file);

            $banner->save();
            $imageName = $banner->id . '_' . uniqid(12) . '.' . $file->getClientOriginalExtension();
            $banner->image = 'uploads/banner/' . $imageName;

            $image->fit(1920, 700, function ($constraint) {
                $constraint->aspectRatio();
            });

            $img_canvas = Image::canvas(1920, 700);
            $img_canvas->insert($image, 'center');
            $img_canvas->save(public_path('uploads/banner/' . $imageName));
        }

        $banner->creator = Auth::user()->id;
        $banner->updated_at = Carbon::now()->toDateTimeString();
        $banner->save();

        $banner = Banner::where('status', 1)->latest()->paginate(10);
        $table_view = View('admin.frontend.banner.table_data', ['banner' => $banner])->render();

        return response()->json([
            'error' => null,
            'data' => $banner,
            'table' => $table_view,
            'success' => 'Banner successfully updated.',
        ]);
    }


    // about us

    public function aboutus(Request $request)
    {
        $aboutus = FrontendAboutHospital::where('status', 1)->paginate(10);
        return view('admin.frontend.aboutus.all', compact('aboutus'));
    }

    public function aboutus_add(Request $request)
    {
        return view('admin.frontend.aboutus.add');
    }

    public function aboutus_edit(Request $request)
    {
        $aboutus = FrontendAboutHospital::find($request->id);
        return view('admin.frontend.aboutus.edit', compact('aboutus'));
    }

    public function aboutus_store(Request $request)
    {
        $this->validate($request, [
            'title' => ['required'],
            'description' => ['required'],
        ]);

        $aboutus = new FrontendAboutHospital();
        $aboutus->title = $request->title;
        $aboutus->description = $request->description;
        $aboutus->creator = Auth::user()->id;
        $aboutus->slug = $aboutus->id . '_' . uniqid(10);
        $aboutus->created_at = Carbon::now()->toDateTimeString();
        $aboutus->save();

        return redirect()->back()->with('success', 'new aboutus created.');
    }

    public function aboutus_update(Request $request)
    {
        $this->validate($request, [
            'title' => ['required'],
            'description' => ['required'],
        ]);

        $aboutus = FrontendAboutHospital::find($request->id);
        $aboutus->title = $request->title;
        $aboutus->description = $request->description;
        $aboutus->creator = Auth::user()->id;
        $aboutus->updated_at = Carbon::now()->toDateTimeString();
        $aboutus->save();

        return redirect()->back()->with('success', 'aboutus updated.');
    }

    public function aboutus_deactive(Request $request, $id)
    {
        $data = FrontendAboutHospital::findOrFail($id);

        $data->delete();
        // $data->save();
        if ($data) {
        return redirect()->route('admin_frontend_aboutus')->with('success-del', 'value');
        } else {
            return back()->with('error', 'value');
        }
    }
    // contact information

    public function contactinformation(Request $request)
    {
        $contact_information = FrontendContactInformation::latest()->first();
        return view('admin.frontend.contact_information.add', compact('contact_information'));
    }

    public function contactinformation_update(Request $request)
    {
        $contact_information = FrontendContactInformation::latest()->first();
        $contact_information->mobile_no1 = $request->mobile_no1;
        $contact_information->mobile_no2 = $request->mobile_no2;
        $contact_information->mobile_no3 = $request->mobile_no3;
        $contact_information->email1 = $request->email1;
        $contact_information->email2 = $request->email2;
        $contact_information->email3 = $request->email3;
        $contact_information->facebook = $request->facebook;
        $contact_information->twitter = $request->twitter;
        $contact_information->youtube = $request->youtube;
        $contact_information->linkedin = $request->linkedin;
        $contact_information->skype = $request->skype;
        $contact_information->pinterest = $request->pinterest;
        $contact_information->location = $request->location;
        $contact_information->address = $request->address;
        $contact_information->updated_at = Carbon::now()->toDateTimeLocalString();
        $contact_information->creator = Auth::user()->id;
        $contact_information->save();
        return redirect()->back()->with('succes', 'contact information updated.');
        // dd($contact_information,$request);
    }
}
