<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\welcome;
use Image;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\FrontendAboutHospital;
use App\FrontendContactInformation;
use Illuminate\Support\Facades\Storage;

class FrontEndWelcomeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $welcome = welcome::latest()->where('status',1)->paginate(10);
        return view('admin.frontend.welcome_information.all',compact('welcome'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function add()
    {
        return view('admin.frontend.welcome_information.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        // dd($request->all());
        $this->validate($request, [
         
            'title' => 'required',
            'subtitle' => 'required',
         

        ]);
       
        $add = new welcome;
        $add->title = $request->title;
        $add->subtitle = $request->subtitle;

        $add->details = $request->details;
        $add->creator = Auth::user()->id;
      
        if($request->hasFile('image')){
            $file = $request->file('image');
            $image = Image::make($file);

            $add->save();
            $imageName = $add->id . '_' . uniqid(12) . '.' . $file->getClientOriginalExtension();
            $add->image = 'uploads/' . $imageName;

            $image->fit(456, 621, function ($constraint) {
                $constraint->aspectRatio();
            });

            $img_canvas = Image::canvas(456, 621);
            $img_canvas->insert($image, 'center');
            $img_canvas->save(public_path('uploads/' . $imageName));
        }
        if($request->hasFile('image_two')){
            $file = $request->file('image_two');
            $image = Image::make($file);

            $add->save();
            $imageName = $add->id . '_' . uniqid(12) . '.' . $file->getClientOriginalExtension();
            $add->image_two = 'uploads/' . $imageName;

            $image->fit(210, 67, function ($constraint) {
                $constraint->aspectRatio();
            });

            $img_canvas = Image::canvas(210, 67);
            $img_canvas->insert($image, 'center');
            $img_canvas->save(public_path('uploads/' . $imageName));
        }
   

        $add->save();

        if ($add) {
            return redirect()->route('admin_frontend_welcome')->with('success', 'value');
        } else {
            return back()->with('error', 'value');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $welcome = welcome::find($id);
        return view('admin.frontend.welcome_information.view',compact('welcome'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $welcome = welcome::find($id);
        return view('admin.frontend.welcome_information.edit',compact('welcome'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $add =welcome::find($request->id);
        $add->title = $request->title;
        $add->subtitle = $request->subtitle;

        $add->details = $request->details;
        $add->creator = Auth::user()->id;
      
        if($request->hasFile('image')){
            $file = $request->file('image');
            $image = Image::make($file);

            $add->save();
            $imageName = $add->id . '_' . uniqid(12) . '.' . $file->getClientOriginalExtension();
            $add->image = 'uploads/' . $imageName;

            $image->fit(456, 621, function ($constraint) {
                $constraint->aspectRatio();
            });

            $img_canvas = Image::canvas(456, 621);
            $img_canvas->insert($image, 'center');
            $img_canvas->save(public_path('uploads/' . $imageName));
        }

        if($request->hasFile('image_two')){
            $file = $request->file('image_two');
            $image = Image::make($file);

            $add->save();
            $imageName = $add->id . '_' . uniqid(12) . '.' . $file->getClientOriginalExtension();
            $add->image_two = 'uploads/' . $imageName;

            $image->fit(210, 67, function ($constraint) {
                $constraint->aspectRatio();
            });

            $img_canvas = Image::canvas(210, 67);
            $img_canvas->insert($image, 'center');
            $img_canvas->save(public_path('uploads/' . $imageName));
        }

      
  

        $add->save();

        if ($add) {
            return redirect()->route('admin_frontend_welcome')->with('success', 'value');
        } else {
            return back()->with('error', 'value');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = welcome::findOrFail($id);

        $data->delete();
        // $data->save();
        if ($data) {
        return redirect()->route('admin_frontend_welcome')->with('success-del', 'value');
        } else {
            return back()->with('error', 'value');
        }
    }
}
