<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Department;
use Carbon\Carbon;
use Illuminate\Support\Str;

class DepartmentController extends Controller
{
    public function department(Request $request){
        return view('hms.department');
    }
    public function store_department(Request $request){
        $department = new Department();
        $department->name = $request->name;
        $department->description = $request->description;
        $department->created_at = Carbon::now()->toDateTimeString();
        $department->save();
        $department->slug = $department->id.'_'.uniqid(10);
        $department->save();
        return redirect()->back()->with('success','new department added.');
    }

    public function edit(Request $request,$id){
        $department = Department::find($id);
        return response()->json($department);
    }

    public function update_department(Request $request){
        $department = Department::find($request->id);
        $department->name = $request->name;
        $department->description = $request->description;
        $department->updated_at = Carbon::now()->toDateTimeString();
        $department->save();
        return redirect()->back()->with('success','new department updated.');
    }

    public function delete(Request $request,$id){
        $department = Department::find($id);
        $department->delete();
        return redirect()->back()->with('success','department deleted.');
    }
}
