<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use Image;

class DoctorController extends Controller
{
    public function doctor(Request $request){
        return view('hms.doctor');
    }

    public function store_doctor(Request $request){
        // dd($request);
        $this->validate($request,[
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8'],
            'phone' => ['required'],
            'department' => ['required'],
            'address' => ['required'],
        ]);

        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->role_id = 4;
        $user->password = Hash::make($request->password);
        $user->address = $request->address;
        $user->phone = $request->phone;
        $user->doctor_department = $request->department;
        $user->doctor_profile = $request->profile;
        $user->created_at = Carbon::now()->toDateTimeString();


        if ($request->hasFile('img_url')) {
            $file = $request->file('img_url');
            $image = Image::make($file);

            $user->save();
            $imageName = $user->id . '_' . uniqid(12) . '.' . $file->getClientOriginalExtension();
            $user->photo = 'uploads/user/' . $imageName;

            $image->fit(200, 200, function ($constraint) {
                $constraint->aspectRatio();
            });

            $img_canvas = Image::canvas(200, 200);
            $img_canvas->insert($image, 'center');
            $img_canvas->save(public_path('uploads/user/' . $imageName));
        }

        $user->save();
        $user->slug = $user->id.'_'.uniqid(10);
        $user->save();

        return redirect()->back()->with('success','New doctor added');
    }

    public function update_doctor(Request $request){
        // dd($request);
        $this->validate($request,[
            'name' => ['required', 'string', 'max:255'],
            'phone' => ['required'],
            'department' => ['required'],
            'address' => ['required'],
        ]);

        $user = User::find($request->id);
        $user->name = $request->name;
        $user->email = $request->email;
        $user->role_id = 4;
        $user->password = Hash::make($request->password);
        $user->address = $request->address;
        $user->phone = $request->phone;
        $user->doctor_department = $request->department;
        $user->doctor_profile = $request->profile;
        $user->updated_at = Carbon::now()->toDateTimeString();

        if ($request->hasFile('img_url')) {
            $file = $request->file('img_url');
            $image = Image::make($file);

            $user->save();
            $imageName = $user->id . '_' . uniqid(12) . '.' . $file->getClientOriginalExtension();
            $user->photo = 'uploads/user/' . $imageName;

            $image->fit(200, 200, function ($constraint) {
                $constraint->aspectRatio();
            });

            $img_canvas = Image::canvas(200, 200);
            $img_canvas->insert($image, 'center');
            $img_canvas->save(public_path('uploads/user/' . $imageName));
        }

        $user->save();

        return redirect()->back()->with('success','doctor updated');
    }

    public function edit(Request $request,$id){
        $doctor = User::find($id);
        return response()->json($doctor);
    }

    public function delete(Request $request,$id){
        $doctor = User::find($id);
        $doctor->delete();
        return redirect()->back()->with('success','Doctor deleted');
    }
}
