<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\DoctorHoliday;
use App\User;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use Image;
use App\DoctorSchedule;
use Illuminate\Support\Facades\Auth;

class DoctorHolidayController extends Controller
{
    public function allHolidays(Request $request){
        return view('hms.allHolidays');
    }

    public function store_doctor_schedule_holiday(Request $request){
        // dd($request , Carbon::parse($request->start_time)->format('h:i:s'));
        $this->validate($request,[
            'doctor' => ['required'],
            'date' => ['required'],
        ]);

        $schedule = new DoctorHoliday();
        $schedule->doctor_id = $request->doctor;
        $schedule->date = $request->date;
        $schedule->creator = Auth::user()->id;
        $schedule->created_at = Carbon::now()->toDateTimeString();

        $schedule->save();
        $schedule->slug = $schedule->id.'_'.uniqid(10);
        $schedule->save();

        return redirect()->back()->with('success','New Holiday added');
    }

    public function update_doctor_schedule_holiday(Request $request){
        $this->validate($request,[
            'doctor' => ['required'],
            'date' => ['required'],
        ]);

        $schedule = DoctorHoliday::find($request->id);
        $schedule->doctor_id = $request->doctor;
        $schedule->date = $request->date;
        $schedule->creator = Auth::user()->id;
        $schedule->updated_at = Carbon::now()->toDateTimeString();

        $schedule->save();

        return redirect()->back()->with('success','holiday updated');
    }

    public function edit(Request $request,$id){
        $schedule = DoctorHoliday::find($id);
        return response()->json($schedule);
    }

    public function delete(Request $request,$id){
        $doctor = DoctorHoliday::find($id);
        $doctor->delete();
        return redirect()->back()->with('success','holiday deleted');
    }
}
