<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\DoctorLab;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class DoctorLabController extends Controller
{
    public function lab(Request $request)
    {
        if ($request->has('patient')) {
            $DoctorLab = DoctorLab::where('patient_id',Auth::user()->id)->get();
            return view('hms.lab_patient',compact('DoctorLab'));
        }else{
            $DoctorLab = DoctorLab::latest()->get();
        }
        return view('hms.lab',compact('DoctorLab'));
    }

    public function lab_reports(Request $request)
    {
        return view('hms.lab_lab1');
    }

    public function view(Request $request,$id){
        $lab = DoctorLab::find($id);
        return view('hms.lab_report',compact('lab'));
    }

    public function store_lab(Request $request){
        // dd($request->request);
        $lab = new DoctorLab();
        $lab->date = $request->lab;
        $lab->patient_id = $request->patient;
        $lab->doctor_id = $request->doctor;
        $lab->description = $request->report;
        $lab->creator = Auth::user()->id;
        $lab->created_at = Carbon::now()->toDateTimeString();
        $lab->save();
        $lab->slug = $lab->id.'_'.uniqid(10);
        $lab->save();

        return redirect()->back()->with('success','new report uplooaded');
    }

    public function delete(Request $request,$id){
        $lab = DoctorLab::find($id);
        $lab->delete();
        return redirect()->back()->with('success','report deleted');
    }
}
