<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use Image;
use App\DoctorSchedule;
use Illuminate\Support\Facades\Auth;
use App\DoctorScheduleDayTime;

class DoctorScheduleController extends Controller
{
    public function schedule(Request $request){
        $schedules=DoctorSchedule::with('doctor')->get();
        return view('hms.schedule',compact('schedules'));
    }
    public function store_doctor_schedule(Request $request){

        // $this->validate($request,[
        //     'start_time' => ['required'],
        //     'from_day' => ['required'],
        //     'end_time' => ['required'],
        //     'appoinment_duration' => ['required'],
        // ]);

        $schedule_days = [];

        if($request->has('from_day1') && isset($request->from_day1[0])){
            foreach($request->from_day1 as $day){
                $data['doctor_id'] = $request->doctor;
                $data['day_name'] = $day;
                $data['start_time'] = $request->start_time1[0];
                $data['end_time'] = $request->end_time1[0];
                $data['duty_duration'] = Carbon::parse($request->start_time1[0])->diff(Carbon::parse($request->end_time1[0]))->format('%H:%I:%S');
                array_push($schedule_days,$data);
            }
            // dd($request,$request->from_day1[0],$data,$schedule_days);
        }

        if($request->has('from_day2') && isset($request->from_day2[0])){
            foreach($request->from_day2 as $day){
                $data['doctor_id'] = $request->doctor;
                $data['day_name'] = $day;
                $data['start_time'] = $request->start_time2[0];
                $data['end_time'] = $request->end_time2[0];
                $data['duty_duration'] = Carbon::parse($request->start_time2[0])->diff(Carbon::parse($request->end_time2[0]))->format('%H:%I:%S');
                array_push($schedule_days,$data);
            }
            // dd($request,$request->from_day1[0],$data,$schedule_days);
        }

        if($request->has('from_day3') && isset($request->from_day3[0])){
            foreach($request->from_day3 as $day){
                $data['doctor_id'] = $request->doctor;
                $data['day_name'] = $day;
                $data['start_time'] = $request->start_time3[0];
                $data['end_time'] = $request->end_time3[0];
                $data['duty_duration'] = Carbon::parse($request->start_time3[0])->diff(Carbon::parse($request->end_time3[0]))->format('%H:%I:%S');
                array_push($schedule_days,$data);
            }
            // dd($request,$request->from_day1[0],$data,$schedule_days);
        }

        if($request->has('from_day4') && isset($request->from_day4[0])){
            foreach($request->from_day4 as $day){
                $data['doctor_id'] = $request->doctor;
                $data['day_name'] = $day;
                $data['start_time'] = $request->start_time4[0];
                $data['end_time'] = $request->end_time4[0];
                $data['duty_duration'] = Carbon::parse($request->start_time4[0])->diff(Carbon::parse($request->end_time4[0]))->format('%H:%I:%S');
                array_push($schedule_days,$data);
            }
            // dd($request,$request->from_day1[0],$data,$schedule_days);
        }

        foreach($schedule_days as $single_day){
            DoctorScheduleDayTime::insert([
                $single_day
            ]);
        }

        // dd($request,$schedule_days);

        // $start_time = $request->start_time;
        // $end_time = $request->end_time;
        // $start_time2 = Carbon::parse($request->start_time);
        // $end_time2 = Carbon::parse($request->end_time);
        // dd($start_time->diff($end_time));
        $schedule = new DoctorSchedule();
        $schedule->doctor_id = $request->doctor;
        // $schedule->from_day = $request->from_day;
        // $schedule->to_day = $request->to_day;
        $schedule->weekday = $request->weekday;
        // $schedule->start_time = $start_time;
        // $schedule->end_time = $end_time;
        // $schedule->start_time = $start_time->format('h:i');
        // $schedule->end_time = $end_time->format('h:i');
        $schedule->appoinment_duration = $request->appoinment_duration;
        // $schedule->duty_duration = $start_time2->diff($end_time2)->format('%H:%I:%S');
        $schedule->creator = Auth::user()->id;
        $schedule->created_at = Carbon::now()->toDateTimeString();

        $schedule->save();
        $schedule->slug = $schedule->id.'_'.uniqid(10);
        $schedule->save();

        return redirect()->back()->with('success','New Schedule added');
    }

    public function update_doctor_schedule(Request $request){
        // dd($request);
        // $this->validate($request,[
        //     'start_time' => ['required'],
        //     'end_time' => ['required'],
        //     'appoinment_duration' => ['required'],
        // ]);

        $schedule_days = [];

        if($request->has('from_day1') && isset($request->from_day1[0])){
            foreach($request->from_day1 as $day){
                $data['doctor_id'] = $request->doctor;
                $data['day_name'] = $day;
                $data['start_time'] = $request->start_time1[0];
                $data['end_time'] = $request->end_time1[0];
                $data['duty_duration'] = Carbon::parse($request->start_time1[0])->diff(Carbon::parse($request->end_time1[0]))->format('%H:%I:%S');
                array_push($schedule_days,$data);
            }
            // dd($request,$request->from_day1[0],$data,$schedule_days);
        }

        if($request->has('from_day2') && isset($request->from_day2[0])){
            foreach($request->from_day2 as $day){
                $data['doctor_id'] = $request->doctor;
                $data['day_name'] = $day;
                $data['start_time'] = $request->start_time2[0];
                $data['end_time'] = $request->end_time2[0];
                $data['duty_duration'] = Carbon::parse($request->start_time2[0])->diff(Carbon::parse($request->end_time2[0]))->format('%H:%I:%S');
                array_push($schedule_days,$data);
            }
            // dd($request,$request->from_day1[0],$data,$schedule_days);
        }

        if($request->has('from_day3') && isset($request->from_day3[0])){
            foreach($request->from_day3 as $day){
                $data['doctor_id'] = $request->doctor;
                $data['day_name'] = $day;
                $data['start_time'] = $request->start_time3[0];
                $data['end_time'] = $request->end_time3[0];
                $data['duty_duration'] = Carbon::parse($request->start_time3[0])->diff(Carbon::parse($request->end_time3[0]))->format('%H:%I:%S');
                array_push($schedule_days,$data);
            }
            // dd($request,$request->from_day1[0],$data,$schedule_days);
        }

        if($request->has('from_day4') && isset($request->from_day4[0])){
            foreach($request->from_day4 as $day){
                $data['doctor_id'] = $request->doctor;
                $data['day_name'] = $day;
                $data['start_time'] = $request->start_time4[0];
                $data['end_time'] = $request->end_time4[0];
                $data['duty_duration'] = Carbon::parse($request->start_time4[0])->diff(Carbon::parse($request->end_time4[0]))->format('%H:%I:%S');
                array_push($schedule_days,$data);
            }
            // dd($request,$request->from_day1[0],$data,$schedule_days);
        }

        if(
            $request->has('from_day1') && isset($request->from_day1[0]) ||
            $request->has('from_day2') && isset($request->from_day2[0]) ||
            $request->has('from_day3') && isset($request->from_day3[0]) ||
            $request->has('from_day4') && isset($request->from_day4[0])

            ){

            DoctorScheduleDayTime::where('doctor_id',$request->doctor)->delete();
            foreach($schedule_days as $single_day){
                DoctorScheduleDayTime::insert([
                    $single_day
                ]);
            }
        }


        // $start_time = $request->start_time;
        // $end_time = $request->end_time;
        // $start_time2 = Carbon::parse($request->start_time);
        // $end_time2 = Carbon::parse($request->end_time);
        // dd($start_time->diff($end_time));
        $schedule = DoctorSchedule::find($request->id);
        $schedule->doctor_id = $request->doctor;

        // if ($request->from_day != null) {
        //     $schedule->from_day = $request->from_day;
        // }

        // if($request->to_day != null){
        //     $schedule->to_day = $request->to_day;
        // }

        $schedule->weekday = $request->weekday;
        // $schedule->start_time = $start_time;
        // $schedule->end_time = $end_time;
        // $schedule->start_time = $start_time->format('h:i');
        // $schedule->end_time = $end_time->format('h:i');
        $schedule->appoinment_duration = $request->appoinment_duration;
        // $schedule->duty_duration = $start_time2->diff($end_time2)->format('%H:%I:%S');
        $schedule->creator = Auth::user()->id;
        $schedule->updated_at = Carbon::now()->toDateTimeString();

        $schedule->save();

        return redirect()->back()->with('success','schedule updated');
    }

    public function edit(Request $request,$id){
        $schedule = DoctorSchedule::find($id);
        return response()->json($schedule);
    }

    public function getAvailableSlotByDoctorByDate(Request $request,$date,$doctor_id){
        $date = Carbon::parse($date)->format('l');
        if(DoctorSchedule::where('weekday','!=',$date)->where('doctor_id',$doctor_id)->exists()){
            $aslots = DoctorSchedule::where('weekday','!=',$date)->where('doctor_id',$doctor_id)->get();
            // dd(json_encode($aslots));
            $times=[];
            foreach($aslots as $slot){
                $temp['appoinment_time'] = Carbon::parse($slot->start_time)->format('h:i a').' To '.Carbon::parse($slot->end_time)->format('h:i a');
                $temp['start_time'] = $slot->start_time;
                $temp['end_time'] = $slot->end_time;
                array_push($times,$temp);
            }
            return response()->json($times);
        }
        dd($date);
        return true;
    }

    public function delete(Request $request,$id){
        $doctor = DoctorSchedule::find($id);
        $doctor->delete();
        return redirect()->back()->with('success','Doctor schedule deleted');
    }
}
