<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\FinancePayment;
use App\FinancePaymentDescription;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\Experiments;
use App\ExpenseCategory;
use App\Expense;

class FinancePaymentController extends Controller
{
    public function addPaymentView(Request $request)
    {
        return view('hms.addPaymentView');
    }

    public function paymentCategory(Request $request)
    {
        return view('hms.paymentCategory');
    }

    public function expense(Request $request)
    {
        return view('hms.expense');
    }

    public function storeExpense(Request $request){
        $expense = new Expense();
        $expense->category = $request->category;
        $expense->amount = $request->amount;
        $expense->description = $request->description;
        $expense->creator = Auth::user()->id;
        $expense->created_at = Carbon::now()->toDateTimeString();
        $expense->save();
        $expense->slug = $expense->id.'_'.uniqid(10);
        $expense->save();
        return redirect()->back()->with('success','new expense inserted.');
    }

    public function updateExpense(Request $request){
        $expense = Expense::find($request->id);
        $expense->category = $request->category;
        $expense->amount = $request->amount;
        $expense->description = $request->description;
        $expense->creator = Auth::user()->id;
        $expense->updated_at = Carbon::now()->toDateTimeString();
        $expense->save();
        return redirect()->back()->with('success','new expense updated.');
    }

    public function expenseEdit(Request $request,$id){
        $expense = Expense::find($id);
        return view('hms.addExpenseViewEdit',compact('expense'));
    }

    public function expenseDelete(Request $request,$id){
        $expense = Expense::find($id);
        $expense->delete();
        return redirect()->back()->with('success','expense deleted successfully.');
    }


    public function addExpenseView(Request $request)
    {
        return view('hms.addExpenseView');
    }
    public function expenseCategory(Request $request)
    {
        return view('hms.expenseCategory');
    }

    public function expenseCategoryAdd(Request $request){
        return view('hms.expenseCategoryAdd');
    }

    public function expenseCategoryEdit(Request $request,$id){
        $expenseCategory = ExpenseCategory::find($id);
        return view('hms.expenseCategoryEdit',compact('expenseCategory'));
    }

    public function expenseCategoryDelete(Request $request,$id){
        $expenseCategory = ExpenseCategory::find($id);
        $expenseCategory->delete();
        return redirect()->back()->with("success",'new category inserted.');
    }

    public function expenseCategoryStore(Request $request){
        $expenseCategory = new ExpenseCategory();
        $expenseCategory->name = $request->name;
        $expenseCategory->description = $request->description;
        $expenseCategory->creator = Auth::user()->id;
        $expenseCategory->created_at = Carbon::now()->toDateTimeString();
        $expenseCategory->save();
        $expenseCategory->slug = $expenseCategory->id.'_'.uniqid(10);
        $expenseCategory->save();

        return redirect()->back()->with("success",'new category inserted.');
    }

    public function expenseCategoryUpdate(Request $request){
        $expenseCategory =  ExpenseCategory::find($request->id);
        $expenseCategory->name = $request->name;
        $expenseCategory->description = $request->description;
        $expenseCategory->creator = Auth::user()->id;
        $expenseCategory->updated_at = Carbon::now()->toDateTimeString();
        $expenseCategory->save();

        return redirect()->back()->with("success",'new category updated.');
    }

    public function paymentCategoryAdd(Request $request)
    {
        return view('hms.paymentCategoryAdd');
    }

    public function paymentCategoryEdit(Request $request,$id){
        $experiment = Experiments::find($id);
        return view('hms.paymentCategoryEdit',compact('experiment'));
    }

    public function paymentCategoryStore(Request $request){
        // dd($request->request);

        $experiment = new Experiments();
        $experiment->name = $request->name;
        $experiment->description = $request->description;
        $experiment->price = $request->price;
        $experiment->doctor_comision = $request->doctor_comision;
        $experiment->type = $request->type;
        $experiment->creator = Auth::user()->id;
        $experiment->created_at = Carbon::now()->toDateTimeString();
        $experiment->save();
        $experiment->slug = $experiment->id.'_'.uniqid(10);
        $experiment->save();
        return redirect()->back()->with('success','new experiment category inserted.');
    }

    public function paymentCategoryUpdate(Request $request){
        // dd($request->request);

        $experiment = Experiments::find($request->id);
        $experiment->name = $request->name;
        $experiment->description = $request->description;
        $experiment->price = $request->price;
        $experiment->doctor_comision = $request->doctor_comision;
        $experiment->type = $request->type;
        $experiment->creator = Auth::user()->id;
        $experiment->updated_at = Carbon::now()->toDateTimeString();
        $experiment->save();
        return redirect()->back()->with('success','new experiment category updated.');
    }

    public function paymentCategoryDelete(Request $request,$id){
        $experiment = Experiments::find($id);
        $experiment->delete();
        return redirect()->back()->with('success','new experiment category deleted.');
    }

    public function patient_add_payment(Request $request){
        /*
            $cat = "";
            $price = "";
            foreach (explode(';', $cat) as $key=>$item) {
                Experiments::insert([
                    'name' => $item,
                    'price' => explode(';', $cat)[$key],
                    'slug' => substr(Str::slug($item), 0, 20),
                    'created_at' => Carbon::now()->toDateTimeString(),
                    'creator' => Auth::user()->id,
                ]);
            }
            dd(Experiments::get());
        */
        // dd($request);

        $paymet = new FinancePayment();
        $paymet->patient_id = $request->patient;
        $paymet->doctor_id = $request->doctor;
        $paymet->note = $request->remarks;
        $paymet->subtotal = $request->subtotal;
        $paymet->discount = $request->discount;
        $paymet->gross_total = $request->grsss;
        $paymet->diposited_amount = $request->amount_received;
        $paymet->diposit_type = $request->deposit_type;
        $paymet->creator = Auth::user()->id;
        $paymet->created_at = Carbon::now()->toDateTimeString();
        $paymet->save();
        $paymet->slug = $paymet->id.'_'.uniqid(10);
        $paymet->invoice_id = $paymet->id.$request->patient.rand(111,999);
        $paymet->save();

        foreach ($request->category_name as $key => $value) {
            FinancePaymentDescription::insert([
                'finance_payment_id' => $paymet->id,
                'experiment_name' => $value,
                'experiment_id' => $request->category_id[$key],
                'price' => Experiments::find($request->category_id[$key])->price,
                'created_at' => Carbon::now()->toDateTimeString(),
            ]);
        }

        return redirect()->back()->with('success','New payment deposited.');
    }


    public function patient_add_due_payment_to_invoice(Request $request){
        $payment = FinancePayment::where('patient_id',$request->patient)->latest()->first();
        $payment->diposited_amount = $payment->diposited_amount+$request->deposited_amount;
        $payment->save();
        return redirect()->back()->with('success','payment deposited.');
    }
}
