<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Notice;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class NoticeController extends Controller
{
    public function notice(Request $request)
    {
        return view('hms.notice');
    }

    public function notice_store(Request $request){
        // dd($request);
        $notice = new Notice();
        $notice->title = $request->title;
        $notice->notice_for = $request->type;
        $notice->description = $request->description;
        $notice->creator = Auth::user()->id;
        $notice->created_at = Carbon::now()->toDateTimeString();
        $notice->save();
        $notice->slug = $notice->id.'_'.uniqid(10);
        $notice->save();
        return redirect()->back()->with('success','new notice uploaded.');
    }

    public function notice_update(Request $request){
        $notice = Notice::find($request->id);
        $notice->title = $request->title;
        $notice->notice_for = $request->type;
        $notice->description = $request->description;
        $notice->creator = Auth::user()->id;
        $notice->updated_at = Carbon::now()->toDateTimeString();
        $notice->save();
        return redirect()->back()->with('success','new notice updated.');
    }

    public function notice_edit(Request $request,$id){
        $notice = Notice::find($id);
        return response()->json($notice);
    }

    public function notice_delete(Request $request,$id){
        $notice = Notice::find($id);
        $notice->delete();
        return redirect()->back()->with('success','new notice deleted.');
    }

    public function notice_addNewView(Request $request)
    {
        return view('hms.notice_addNewView');
    }
}
