<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use Image;
use App\PatientCase;
use Illuminate\Support\Facades\Auth;
use App\PatientDocument;
use Illuminate\Support\Facades\Storage;
use App\FinancePayment;

class PatientController extends Controller
{
    public function patient(Request $request)
    {
        return view('hms.patient');
    }

    public function caseList(Request $request)
    {
        if($request->has('patient')){
            $PatientCase = PatientCase::where('patient_id',Auth::user()->id)->get();
        }else{
            $PatientCase = PatientCase::latest()->get();
        }
        return view('hms.caseList',compact('PatientCase'));
    }

    public function documents(Request $request)
    {
        if($request->has('patient')){
            $PatientDocument = PatientDocument::where('patient_id',Auth::user()->id)->get();
        }else{
            $PatientDocument = PatientDocument::latest()->get();
        }
        return view('hms.documents',compact('PatientDocument'));
    }

    public function patientPayments(Request $request){
        // dd($request->request, Auth::User()->id);
        if($request->has('patient')){
            $FinancePayment = FinancePayment::where('patient_id',Auth::user()->id)->get();
            // dd($FinancePayment);
        }else{
            $FinancePayment = FinancePayment::latest()->get();
        }
        return view('hms.patientPayments',compact('FinancePayment'));
    }

    public function medicalHistory(Request $request){
        // dd($request->all());
        if($request->has('patientid')){
            $patient = User::find($request->patientid);
        }else{
            $patient = User::find(Auth::user()->id);
        }
        return view('hms.medicalHistory',compact('patient'));
    }

    public function patientPaymentsHistory(Request $request,$id){
        $payments = FinancePayment::where('patient_id',$id)->get();
        return view('hms.patientPaymentsHistory',compact('payments'));
    }

    public function getMedicalHistoryByJason(Request $request, $id){
        // dd($id);
        return view('hms.medicalHistoryForJson',compact('id'));
    }

    public function store_patient(Request $request)
    {
        // dd($request);
        $this->validate($request, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8'],
            'phone' => ['required'],
            'address' => ['required'],
        ]);

        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->role_id = 8;
        $user->password = Hash::make($request->password);
        $user->address = $request->address;
        $user->phone = $request->phone;
        $user->sex = $request->sex;
        $user->birth_date = $request->birthdate;
        $user->blood_group = $request->bloodgroup;
        $user->patient_doctor = $request->doctor;
        $user->created_at = Carbon::now()->toDateTimeString();

        if ($request->hasFile('img_url')) {
            $file = $request->file('img_url');
            $image = Image::make($file);

            $user->save();
            $imageName = $user->id . '_' . uniqid(12) . '.' . $file->getClientOriginalExtension();
            $user->photo = 'uploads/user/' . $imageName;

            $image->fit(200, 200, function ($constraint) {
                $constraint->aspectRatio();
            });

            $img_canvas = Image::canvas(200, 200);
            $img_canvas->insert($image, 'center');
            $img_canvas->save(public_path('uploads/user/' . $imageName));
        }

        $user->save();
        $user->slug = $user->id . '_' . uniqid(10);
        $user->save();

        return redirect()->back()->with('success', 'New patient added');
    }

    public function update_patient(Request $request)
    {
        // dd($request);
        $this->validate($request, [
            'name' => ['required', 'string', 'max:255'],
            'phone' => ['required'],
            'address' => ['required'],
        ]);

        $user = User::find($request->id);
        $user->name = $request->name;
        $user->email = $request->email;
        $user->role_id = 8;
        $user->password = Hash::make($request->password);
        $user->address = $request->address;
        $user->phone = $request->phone;
        $user->sex = $request->sex;
        $user->birth_date = $request->birthdate;
        $user->blood_group = $request->bloodgroup;
        $user->patient_doctor = $request->doctor;
        $user->created_at = Carbon::now()->toDateTimeString();

        if ($request->hasFile('img_url')) {
            $file = $request->file('img_url');
            $image = Image::make($file);

            $user->save();
            $imageName = $user->id . '_' . uniqid(12) . '.' . $file->getClientOriginalExtension();
            $user->photo = 'uploads/user/' . $imageName;

            $image->fit(200, 200, function ($constraint) {
                $constraint->aspectRatio();
            });

            $img_canvas = Image::canvas(200, 200);
            $img_canvas->insert($image, 'center');
            $img_canvas->save(public_path('uploads/user/' . $imageName));
        }

        $user->save();

        return redirect()->back()->with('success', 'patient updated');
    }

    public function store_caseList(Request $request){
        $this->validate($request,[
            'date' => ['required'],
            'patient_id' => ['required'],
            'title' => ['required'],
            'description' => ['required'],
        ]);

        $case = new PatientCase();
        $case->date = $request->date;
        $case->patient_id = $request->patient_id;
        $case->title = $request->title;
        $case->case = $request->description;
        $case->creator = Auth::user()->id;
        $case->created_at = Carbon::now()->toDateTimeString();
        $case->save();

        return redirect()->back()->with('success','new case added successfully.');
    }

    public function update_caseList(Request $request){
        $this->validate($request,[
            'date' => ['required'],
            'patient_id' => ['required'],
            'title' => ['required'],
            'description' => ['required'],
        ]);

        $case = PatientCase::find($request->id);
        $case->date = $request->date;
        $case->patient_id = $request->patient_id;
        $case->title = $request->title;
        $case->case = $request->description;
        $case->creator = Auth::user()->id;
        $case->updated_at = Carbon::now()->toDateTimeString();
        $case->save();

        return redirect()->back()->with('success','new case updated successfully.');
    }

    public function store_document(Request $request){
        $this->validate($request,[
            'title' => ['required'],
            'img_url' => ['required'],
            'patient_id' => ['required'],
        ]);

        $document = new PatientDocument();
        $document->title = $request->title;
        $document->patient_id = $request->patient_id;
        if($request->hasFile('img_url')){
            $document->img_url = Storage::put('uploads/patient_document', $request->file('img_url'));
        }
        $document->creator = Auth::user()->id;
        $document->created_at = Carbon::now()->toDateTimeString();
        $document->save();
        $document->slug = $document->id.'_'.uniqid(10);
        $document->save();
        return redirect()->back()->with('success','new Document added successfully.');
    }

    public function update_document(Request $request){
        $this->validate($request,[
            'title' => ['required'],
            'img_url' => ['required'],
            'patient_id' => ['required'],
        ]);

        $document = PatientDocument::find($request->id);
        $document->title = $request->title;
        $document->patient_id = $request->patient_id;
        if($request->hasFile('img_url')){
            $document->img_url = Storage::put('uploads/patient_document', $request->file('img_url'));
        }
        $document->creator = Auth::user()->id;
        $document->updated_at = Carbon::now()->toDateTimeString();
        $document->save();
        return redirect()->back()->with('success','new Document updated successfully.');
    }

    public function documentDelete(Request $request,$id){
        $case = PatientDocument::find($id);
        $case->delete();
        return redirect()->back()->with('success','Document deleted successfully.');
    }

    public function caseListDelete(Request $request,$id){
        $case = PatientCase::find($id);
        $case->delete();
        return redirect()->back()->with('success',' case deleted successfully.');
    }


    public function edit(Request $request,$id){
        $patient = User::find($id);
        if($patient->patients_doctor){
            $patient->doctor_department = $patient->patients_doctor->name;
        }
        return response()->json($patient);
    }

    public function caseListEdit(Request $request,$id){
        $case = PatientCase::find($id);
        $case = collect($case)->put('name',$case->patient->name);
        // dd($case);
        return response()->json($case);
    }

    public function documentEdit(Request $request,$id){
        $case = PatientCase::find($id);
        $case = collect($case)->put('name',$case->patient->name);
        // dd($case);
        return response()->json($case);
    }

    public function delete(Request $request,$id){
        $patient = User::find($id);
        $patient->delete();
        return redirect()->back()->with('success','patient deleted');
    }
}
