<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\MadicneList;
use Carbon\Carbon;
use App\MadicineSale;
use App\MadicineSaleDetails;
use Illuminate\Support\Facades\Auth;

class PharmacistController extends Controller
{
    public function pharmacy(Request $request)
    {
        return view('hms.pharmacy');
    }

    public function farmacy_payment(Request $request)
    {
        return view('hms.farmacy_payment');
    }

    public function farmacy_addPaymentView(Request $request)
    {
        // dd(Carbon::now()->year);
        // $madicine = MadicneList::get();
        // foreach($madicine as $item){
        //     $item->category_id = 1;
        //     $item->price = rand(100,500);
        //     $item->saleprice = rand(100,500);
        //     $item->storebox = rand(100,500);
        //     $item->quantity = rand(100,500);
        //     $item->genericname = 'napa extra';
        //     $item->company = 'square';
        //     $item->effect = 'no effect';
        //     $item->expire_date = '2021-10-05 00:00:00';
        //     $item->creator = 27;
        //     $item->save();
        // }
        return view('hms.farmacy_addPaymentView');
    }

    public function farmacy_addPaymentViewEdit(Request $request,$id){
        $MadicineSale = MadicineSale::find($id);
        $MadicineSaleDetails = MadicineSaleDetails::where('madicine_sale_id',$id)->get();
        // dd($MadicineSaleDetails);
        return view('hms.farmacy_editPaymentView',compact('MadicineSale','MadicineSaleDetails'));
    }

    public function farmacy_PaymentViewInvoice(Request $request,$id){
        $MadicineSale = MadicineSale::find($id);
        $MadicineSaleDetails = MadicineSaleDetails::where('madicine_sale_id',$id)->get();
        // dd($MadicineSaleDetails);
        return view('hms.farmacy_invoice',compact('MadicineSale','MadicineSaleDetails'));
    }

    public function farmacy_addPayment_submit(Request $request){
        // dd($request->request);

        $madicine_sale = new MadicineSale();
        // $madicine_sale->invoice_id = ;
        $invoice_date = Carbon::now()->toDateTimeString();
        $madicine_sale->invoice_date = $invoice_date;
        $madicine_sale->sub_total = $request->subtotal;
        $madicine_sale->discount = $request->discount;
        $madicine_sale->grand_total = $request->grsss;
        $madicine_sale->creator = Auth::user()->id;
        $madicine_sale->created_at = Carbon::now()->toDateTimeString();
        $madicine_sale->save();
        $madicine_sale->slug = $madicine_sale->id.'_'.uniqid(10);
        $invoice_id = 'hms'.Carbon::now()->year.$madicine_sale->id;
        $madicine_sale->invoice_id = $invoice_id;
        $madicine_sale->save();

        foreach($request->medicine_id as $key=>$item){
            $madicine_sale_details = new MadicineSaleDetails();
            $madicine_sale_details->madicine_sale_id = $madicine_sale->id;
            $madicine_sale_details->invoice_id = $invoice_id;
            $madicine_sale_details->invoice_date = $invoice_date;
            $madicine_sale_details->madicine_id = $item;

            if(isset($request->quantity[$key]))
                $madicine_sale_details->madicine_qty = $request->quantity[$key];
            else
                $madicine_sale_details->madicine_qty = 0;

            $madicine_sale_details->creator = Auth::user()->id;
            $madicine_sale_details->created_at = Carbon::now()->toDateTimeString();
            $madicine_sale_details->save();
            $madicine_sale_details->slug = $madicine_sale->id.'_'.uniqid(10);
            $madicine_sale_details->save();
        }

        return redirect()->back()->with('success','new madicine sale created.');
    }

    public function farmacy_editPayment_submit(Request $request){
        // dd($request->request);

        $madicine_sale = MadicineSale::find($request->id);
        $madicine_sale->sub_total = $request->subtotal;
        $madicine_sale->discount = $request->discount;
        $madicine_sale->grand_total = $request->grsss;
        $madicine_sale->creator = Auth::user()->id;
        $madicine_sale->updated_at = Carbon::now()->toDateTimeString();
        $madicine_sale->save();

        MadicineSaleDetails::where('invoice_id',$madicine_sale->invoice_id)->delete();
        foreach($request->medicine_id as $key=>$item){
            $madicine_sale_details = new MadicineSaleDetails();
            $madicine_sale_details->madicine_sale_id = $madicine_sale->id;
            $madicine_sale_details->invoice_id = $madicine_sale->invoice_id;
            $madicine_sale_details->invoice_date = $madicine_sale->invoice_date ;
            $madicine_sale_details->madicine_id = $item;

            if(isset($request->quantity[$key]))
                $madicine_sale_details->madicine_qty = $request->quantity[$key];
            else
                $madicine_sale_details->madicine_qty = 0;

            $madicine_sale_details->creator = Auth::user()->id;
            $madicine_sale_details->created_at = Carbon::now()->toDateTimeString();
            $madicine_sale_details->save();
            $madicine_sale_details->slug = $madicine_sale->id.'_'.uniqid(10);
            $madicine_sale_details->save();
        }

        return redirect()->back()->with('success','new madicine sale updated.');
    }

    public function farmacy_expense(Request $request)
    {
        return view('hms.farmacy_expense');
    }

    public function farmacy_addExpenseView(Request $request)
    {
        return view('hms.farmacy_addExpenseView');
    }

    public function farmacy_expenseCategory(Request $request)
    {
        return view('hms.farmacy_expenseCategory');
    }

    public function farmacy_financialReport(Request $request)
    {
        return view('hms.farmacy_financialReport');
    }

    public function farmacy_monthly(Request $request)
    {
        return view('hms.farmacy_monthly');
    }

    public function farmacy_daily(Request $request)
    {
        return view('hms.farmacy_daily');
    }

    public function farmacy_monthlyExpense(Request $request)
    {
        return view('hms.farmacy_monthlyExpense');
    }

    public function farmacy_dailyExpense(Request $request)
    {
        return view('hms.farmacy_dailyExpense');
    }

}
