<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use App\MadicneList;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\DoctorPrescription;
use Illuminate\Support\Facades\Auth;
use App\DoctorPrescriptionMedicine;
use App\PatientDocument;

class PrescriptionController extends Controller
{
    public function prescription(Request $request)
    {
        if($request->has('patient')){
            $prescription = DoctorPrescription::where('patient_id',Auth::user()->id)->get();
        }else{
            $prescription = DoctorPrescription::latest()->get();
        }
        return view('hms.prescription',compact('prescription'));
    }

    public function add(Request $request)
    {
        /*
            const res2 = Array.from(document.getElementsByTagName('li'), ({textContent}) => textContent.trim()).filter(Boolean).join(';');
            console.log(res2);
            dataset.cat_name
            dataset.id
            idd
         */

        // $madicines = "";
        // foreach (explode(';', $madicines) as $item) {

        //     MadicneList::insert([
        //         'name' => $item,
        //         'slug' => substr(Str::slug($item), 0, 20),
        //         'created_at' => Carbon::now()->toDateTimeString(),
        //     ]);
        // }
        // dd(MadicneList::latest()->get()->count());

        return view('hms.prescription_add');
    }

    public function view(Request $request,$id){
        $prescription = DoctorPrescription::find($id);
        return view('hms.prescription_details',compact('prescription'));
    }

    public function store_prescription(Request $request){
        // dd($request->request,isset($request->medicine[1]));

        $prescription = new DoctorPrescription();
        $prescription->date = $request->date;
        $prescription->patient_id = $request->patient;
        $prescription->doctor_id = $request->doctor;
        $prescription->symtom = $request->symptom;
        $prescription->note = $request->note;
        $prescription->advice = $request->advice;
        $prescription->creator = Auth::user()->id;
        $prescription->created_at = Carbon::now()->toDateTimeString();
        $prescription->save();
        $prescription->slug = $prescription->id.'_'.uniqid(10);
        $prescription->save();

        foreach($request->med_id as $key=>$med){
            $prescription_medicine = new DoctorPrescriptionMedicine();
            $prescription_medicine->prescription_id = $prescription->id;
            $prescription_medicine->doctor_id = $request->doctor;
            $prescription_medicine->patient_id = $request->patient;

            if(isset($request->medicine[$key])){
                $prescription_medicine->med_id = $request->medicine[$key];
            }
            if(isset($request->med_id[$key])){
                $prescription_medicine->medicine = $request->med_id[$key];
            }
            if(isset($request->dosage[$key])){
                $prescription_medicine->dosage = $request->dosage[$key];
            }
            if(isset($request->frequency[$key])){
                $prescription_medicine->frequency = $request->frequency[$key];
            }
            if(isset($request->days[$key])){
                $prescription_medicine->days = $request->days[$key];
            }
            if(isset($request->instruction[$key])){
                $prescription_medicine->days = $request->instruction[$key];
            }

            $prescription_medicine->creator = Auth::user()->id;
            $prescription_medicine->created_at = Carbon::now()->toDateTimeString();
            $prescription_medicine->save();
        }

        return redirect()->back()->with('success','new prescription uploaded');
    }
}

