<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;

class ProfileController extends Controller
{
    public function profile(Request $request)
    {
        return view('hms.profile');
    }

    public function update_profile(Request $request){
        if($request->email != Auth::user()->email){
            $this->validate($request,[
                'email' => ['unique:users'],
            ]);
        }

        $user = User::find(Auth::user()->id);
        $user->name = $request->name;
        $user->email = $request->email;
        if(!is_null($request->password)){
            $user->password = Hash::make($request->password);
        }
        $user->save();
        return redirect()->back()->with('success','porfile updated');
    }
}
