<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Image;

class ReceptionistController extends Controller
{
    public function receptionist(Request $request)
    {
        return view('hms.receptionist');
    }

    public function store_receptionist(Request $request)
    {
        // dd($request);
        $this->validate($request, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8'],
            'phone' => ['required'],
            'address' => ['required'],
        ]);

        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->role_id = 10;
        $user->password = Hash::make($request->password);
        $user->address = $request->address;
        $user->phone = $request->phone;
        $user->doctor_department = $request->department;
        $user->doctor_profile = $request->profile;
        $user->created_at = Carbon::now()->toDateTimeString();

        if ($request->hasFile('img_url')) {
            $file = $request->file('img_url');
            $image = Image::make($file);

            $user->save();
            $imageName = $user->id . '_' . uniqid(12) . '.' . $file->getClientOriginalExtension();
            $user->photo = 'uploads/user/' . $imageName;

            $image->fit(200, 200, function ($constraint) {
                $constraint->aspectRatio();
            });

            $img_canvas = Image::canvas(200, 200);
            $img_canvas->insert($image, 'center');
            $img_canvas->save(public_path('uploads/user/' . $imageName));
        }

        $user->save();
        $user->slug = $user->id . '_' . uniqid(10);
        $user->save();

        return redirect()->back()->with('success', 'New receptionist added');
    }

    public function update_receptionist(Request $request)
    {
        // dd($request);
        $this->validate($request, [
            'name' => ['required', 'string', 'max:255'],
            'phone' => ['required'],
            'address' => ['required'],
        ]);

        $user = User::find($request->id);
        $user->name = $request->name;
        $user->email = $request->email;
        $user->role_id = 10;
        $user->password = Hash::make($request->password);
        $user->address = $request->address;
        $user->phone = $request->phone;
        $user->updated_at = Carbon::now()->toDateTimeString();

        if ($request->hasFile('img_url')) {
            $file = $request->file('img_url');
            $image = Image::make($file);

            $user->save();
            $imageName = $user->id . '_' . uniqid(12) . '.' . $file->getClientOriginalExtension();
            $user->photo = 'uploads/user/' . $imageName;

            $image->fit(200, 200, function ($constraint) {
                $constraint->aspectRatio();
            });

            $img_canvas = Image::canvas(200, 200);
            $img_canvas->insert($image, 'center');
            $img_canvas->save(public_path('uploads/user/' . $imageName));
        }

        $user->save();

        return redirect()->back()->with('success', 'receptionist updated');
    }

    public function edit(Request $request, $id)
    {
        $doctor = User::find($id);
        return response()->json($doctor);
    }

    public function delete(Request $request, $id)
    {
        $doctor = User::find($id);
        $doctor->delete();
        return redirect()->back()->with('success', 'receptionist deleted');
    }
}
