<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\User;
use App\DoctorAppoinment;
use App\Experiments;
use Illuminate\Support\Str;
use Carbon\Carbon;
use App\DoctorPrescription;

class WebsiteController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function home(Request $request)
    {

        if (Auth::user()->role_id <= 2) {
            return view('hms.home');
        }

        // doctor
        if (Auth::user()->role_id == 4) {
            $events = DoctorAppoinment::get();
            $evnt_array = [];
            foreach ($events as $item) {
                if( User::where('id',$item->patient_id)->exists() && User::where('id',$item->doctor_id)->exists()){
                    $temp['id'] = $item->patient_id;
                    $temp['title'] = "<div style='padding:5px;display:block;'>" .
                        "<br> Status: " . $item->appoinment_status .
                        "<br> Patient: " .  User::find($item->patient_id)->name.
                        "<br> Phone: " . User::find($item->patient_id)->phone .
                        "<br> Doctor: " . User::find($item->doctor_id)->name .
                        "<br> Remarks: " . $item->remarks .
                    "</div>";
                    $temp['description'] = "Click to see the patient history";
                    $temp['start'] = $item->start;
                    $temp['end'] = $item->end;
                    $temp['color'] = '#' . rand(100000, 999999);
    
                    array_push($evnt_array, $temp);
                }
            }
            // dd(json_encode($evnt_array));
            return view('hms.calendar', compact('evnt_array'));
        }

        // nurse
        if (Auth::user()->role_id == 5) {
            return view('hms.nurse_dashboard');
        }

        // pharmacist
        if (Auth::user()->role_id == 6) {
            return view('hms.pharmacy');
        }

        // accountant
        if (Auth::user()->role_id == 7) {
            return view('hms.addPaymentView');
        }

        // patient
        if (Auth::user()->role_id == 8) {
            $patient = Auth::user();
            return view('hms.medicalHistory',compact('patient'));
        }

        // laboratorist
        if (Auth::user()->role_id == 9) {
            return view('hms.laboratorist_dashboard');
        }

        // receptionist
        if (Auth::user()->role_id == 10) {
            return view('hms.addPaymentView');
        }
    }

    public function department(Request $request)
    {
        return view('hms.department');
    }

    public function patientPayments(Request $request)
    {
        return view('hms.patientPayments');
    }

    public function payment(Request $request)
    {
        return view('hms.payment');
    }

    public function addLabView(Request $request)
    {
        return view('hms.addLabView');
    }
    public function template(Request $request)
    {
        return view('hms.template');
    }

    public function finance_financialReport(Request $request)
    {
        return view('hms.finance_financialReport');
    }
    public function finance_UserActivityReport(Request $request)
    {
        return view('hms.finance_user_activity_report');
    }
    public function finance_AllUserActivityReport(Request $request)
    {
        return view('hms.finance_AllUserActivityReport');
    }
    public function finance_doctorsCommission(Request $request)
    {
        return view('hms.finance_doctorsCommission');
    }
    public function finance_monthly(Request $request)
    {
        return view('hms.finance_monthly');
    }
    public function finance_daily(Request $request)
    {
        return view('hms.finance_daily');
    }
    public function finance_monthlyExpense(Request $request)
    {
        return view('hms.finance_monthlyExpense');
    }
    public function finance_dailyExpense(Request $request)
    {
        return view('hms.finance_dailyExpense');
    }

    public function sms_autoSMSTemplate(Request $request)
    {
        return view('hms.sms_autoSMSTemplate');
    }
    public function sms_sendView(Request $request)
    {
        return view('hms.sms_sendView');
    }
    public function sms_sent(Request $request)
    {
        return view('hms.sms_sent');
    }
    public function sms_setting(Request $request)
    {
        return view('hms.sms_setting');
    }

    public function frontend_setting(Request $request)
    {
        return view('hms.frontend_setting');
    }
    public function frontend_slide(Request $request)
    {
        return view('hms.frontend_slide');
    }
    public function frontend_service(Request $request)
    {
        return view('hms.frontend_service');
    }
    public function frontend_featured(Request $request)
    {
        return view('hms.frontend_featured');
    }

    public function system_settings(Request $request)
    {
        return view('hms.system_settings');
    }
    public function system_pgateway(Request $request)
    {
        return view('hms.system_pgateway');
    }
    public function system_language(Request $request)
    {
        return view('hms.system_language');
    }
    public function system_import(Request $request)
    {
        return view('hms.system_import');
    }



    public static function convert($mytime)
    {
        $engDATE = array(1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 'Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
        $bangDATE = array('১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯', '০', 'শনিবার', 'রবিবার', 'সোমবার', 'মঙ্গলবার', 'বুধবার', 'বৃহস্পতিবার', 'শুক্রবার', 'জানুয়ারি', 'ফেব্রুয়ারি', 'মার্চ', 'এপ্রিল', 'মে', 'জুন', 'জুলাই', 'আগস্ট', 'সেপ্টেম্বর', 'অক্টোবর', 'নভেম্বর', 'ডিসেম্বর');
        $convertedDATE = str_replace($engDATE, $bangDATE, $mytime);
        return $convertedDATE;
    }
}
