<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDoctorPrescriptionMedicinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('doctor_prescription_medicines', function (Blueprint $table) {
            $table->id();
            $table->integer('prescription_id')->nullable();
            $table->integer('doctor_id')->nullable();
            $table->integer('patient_id')->nullable();
            $table->integer('med_id')->nullable();
            $table->text('medicine')->nullable();
            $table->string('dosage',100)->nullable();
            $table->string('frequency',100)->nullable();
            $table->string('days',100)->nullable();
            $table->string('instruction',100)->nullable();
            $table->integer('creator')->nullable();
            $table->string('slug',35)->nullable();
            $table->integer('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('doctor_prescription_medicines');
    }
}
