<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMadicineSalesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('madicine_sales', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_id',100)->nullable();
            $table->string('invoice_date',100)->nullable();
            $table->double('sub_total')->nullable();
            $table->bigInteger('discount')->nullable();
            $table->double('grand_total')->nullable();
            $table->integer('creator')->nullable();
            $table->string('slug',35)->nullable();
            $table->integer('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('madicine_sales');
    }
}
