<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFrontendContactInformationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('frontend_contact_information', function (Blueprint $table) {
            $table->id();
            $table->string('mobile_no1',100)->nullable();
            $table->string('mobile_no2',100)->nullable();
            $table->string('mobile_no3',100)->nullable();
            $table->string('email1',100)->nullable();
            $table->string('email2',100)->nullable();
            $table->string('email3',100)->nullable();
            $table->string('facebook',100)->nullable();
            $table->string('twitter',100)->nullable();
            $table->string('youtube',100)->nullable();
            $table->string('linkedin',100)->nullable();
            $table->string('skype',100)->nullable();
            $table->string('pinterest',100)->nullable();
            $table->text('location')->nullable();
            $table->text('address')->nullable();
            $table->integer('creator')->nullable();
            $table->string('slug',35)->nullable();
            $table->integer('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('frontend_contact_information');
    }
}
