@extends('layouts.admin.admin')
@section('content')
    @push('css')
        <style>
            .form-group{
                position: relative;
            }
            .form-group input{
                padding-left: 50px;
            }
            .form-group>i{
                position: absolute;
                bottom: 4px;
                display: inline-block;
                left: 4px;
                height: 30px;
                width: 30px;
                text-align: center;
                line-height: 28px;
                border: 1px solid #ffffff6e;
                border-radius: 5px;
                box-sizing: border-box;
            }
        </style>
    @endpush
    <div class="row">
        <div class="col-lg-8 m-auto">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-6">
                            <h5 class="card-title"> Contact Information </h5>
                        </div>
                        <div class="col-6">
                            {{-- <a class="btn btn-outline-tumblr float-right" href="{{ route('admin_frontend_contactinformation') }}">
                                <i class="fa fa-arrow-left"></i>
                                Back
                            </a> --}}
                        </div>
                    </div>
                </div>
                <div class="table_content px-5">
                    <form action="{{ route('admin_frontend_contactinformation_update') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="form_content">
                            <div class="form-group">
                                <label for="input-1">Mobile 1</label> <span class="text-danger">*</span>
                                <input type="text" name="mobile_no1" class="form-control" placeholder="mobile_no1" value="{{ @$contact_information->mobile_no1 }}">
                                <i class="fa fa-phone"></i>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Mobile 2</label> <span class="text-danger">*</span>
                                <input type="text" name="mobile_no2" class="form-control" placeholder="mobile_no2" value="{{ @$contact_information->mobile_no2 }}">
                                <i class="fa fa-phone"></i>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Mobile 3</label> <span class="text-danger">*</span>
                                <input type="text" name="mobile_no3" class="form-control" placeholder="mobile_no3" value="{{ @$contact_information->mobile_no3 }}">
                                <i class="fa fa-phone"></i>
                            </div>

                            <div class="form-group">
                                <label for="input-1">Email 1</label> <span class="text-danger">*</span>
                                <input type="text" name="email1" class="form-control" placeholder="email1" value="{{ @$contact_information->email1 }}">
                                <i class="fa fa-envelope-o"></i>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Email 2</label> <span class="text-danger">*</span>
                                <input type="text" name="email2" class="form-control" placeholder="email2" value="{{ @$contact_information->email2 }}">
                                <i class="fa fa-envelope-o"></i>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Email 3</label> <span class="text-danger">*</span>
                                <input type="text" name="email3" class="form-control" placeholder="email3" value="{{ @$contact_information->email3 }}">
                                <i class="fa fa-envelope-o"></i>
                            </div>

                            <div class="form-group">
                                <label for="input-1">Facebook</label> <span class="text-danger">*</span>
                                <input type="text" name="facebook" class="form-control" placeholder="facebook" value="{{ @$contact_information->facebook }}">
                                <i class="fa fa-facebook-f"></i>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Twitter</label> <span class="text-danger">*</span>
                                <input type="text" name="twitter" class="form-control" placeholder="twitter" value="{{ @$contact_information->twitter }}">
                                <i class="fa fa-twitter"></i>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Youtube</label> <span class="text-danger">*</span>
                                <input type="text" name="youtube" class="form-control" placeholder="youtube" value="{{ @$contact_information->youtube }}">
                                <i class="fa fa-youtube"></i>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Linkedin</label> <span class="text-danger">*</span>
                                <input type="text" name="linkedin" class="form-control" placeholder="linkedin" value="{{ @$contact_information->linkedin }}">
                                <i class="fa fa-linkedin"></i>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Skype</label> <span class="text-danger">*</span>
                                <input type="text" name="skype" class="form-control" placeholder="skype" value="{{ @$contact_information->skype }}">
                                <i class="fa fa-skype"></i>
                            </div>
                            <div class="form-group">
                                <label for="input-1">Pinterest</label> <span class="text-danger">*</span>
                                <input type="text" name="pinterest" class="form-control" placeholder="pinterest" value="{{ @$contact_information->pinterest }}">
                                <i class="fa fa-pinterest-p"></i>
                            </div>

                            <div class="form-group">
                                <label for="input-2">Location</label> <span class="text-danger">*</span>
                                <textarea type="text" name="location" class="form-control description" placeholder="location" value="">{{ @$contact_information->location }}</textarea>
                            </div>
                            <div class="form-group">
                                <label for="input-2">Address</label> <span class="text-danger">*</span>
                                <textarea type="text" name="address" class="form-control description" placeholder="address" value="">{{ @$contact_information->address }}</textarea>
                            </div>
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-light px-5"><i class="fa fa-upload"></i>
                                Submit</button>
                            <button type="reset" class="btn btn-outline-danger px-5"><i class="fa fa-download"></i>
                                Reset</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('cssplugin')
        <link rel="stylesheet" href="{{ asset('contents/admin') }}/assets/plugins/summernote/dist/summernote-bs4.css" />
        <link href="{{ asset('contents/admin') }}/assets/plugins/select2/css/select2.min.css" rel="stylesheet"/>
    @endpush

    @push('jsplugin')
        <script src="{{ asset('contents/admin') }}/assets/plugins/summernote/dist/summernote-bs4.min.js"></script>
        <script src="{{ asset('contents/admin') }}/assets/plugins/select2/js/select2.min.js"></script>
    @endpush

    @push('js')
        <script>
            $(function() {
                $('.description').summernote({
                    height: 400,
                    tabsize: 2
                });
                $('.single-select').select2();
            })
        </script>
    @endpush

@endsection

