@extends('layouts.admin.admin')
@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-6">
                            <h5 class="card-title">Welcome Information</h5>
                        </div>
                        <div class="col-6">
                            <a class="btn btn-outline-tumblr float-right" href="{{ route('admin_frontend_welcome') }}">
                                <i class="fa fa-arrow-left"></i>
                                Back
                            </a>
                        </div>
                    </div>
                </div>
                <div class="table_content px-5">
                    <form action="{{ route('admin_frontend_welcome_update') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden"  name="id" value="{{ $welcome->id }}" id="">
                        <div class="form_content">
                            <div class="form-group">
                                <label for="input-1">Title</label> <span class="text-danger">*</span>
                                <input type="text" name="title" class="form-control" placeholder="title" value="{{ $welcome->title }}">
                            </div>
                            <div class="form-group">
                                <label for="input-1">Sub Title</label> <span class="text-danger">*</span>
                                <input type="text" name="subtitle" class="form-control" placeholder="title" value="{{ $welcome->subtitle}}">
                            </div>
                            <div class="form-group">
                                <label for="input-2">Description</label> <span class="text-danger">*</span>
                                <textarea type="text" name="details" class="form-control description" placeholder="description" value="">{{ $welcome->details}}</textarea>
                            </div>
                            <div class="form-group">
                                <label for="input-2">Doctor Image</label> <span class="text-danger">*</span>
                                <img src="{{ asset(''.$welcome->image) }}" alt="banner" style="height: 50px;"><br>
                                <input type="file" name="image" class="form-control" placeholder="Image" value="{{ $welcome->image }}">
                            </div>
                            <div class="form-group">
                                <label for="input-2">Doctor Sign</label> <span class="text-danger">*</span>
                                <img src="{{ asset(''.$welcome->image_two) }}" alt="banner" style="height: 50px;"><br>
                                <input type="file" name="image_two" class="form-control" placeholder="Image" value="{{ $welcome->image_two }}">
                            </div>
                           
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-light px-5"><i class="fa fa-upload"></i>
                                Submit</button>
                            <button type="reset" class="btn btn-outline-danger px-5"><i class="fa fa-download"></i>
                                Reset</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('cssplugin')
        <link rel="stylesheet" href="{{ asset('contents/admin') }}/assets/plugins/summernote/dist/summernote-bs4.css" />
        <link href="{{ asset('contents/admin') }}/assets/plugins/select2/css/select2.min.css" rel="stylesheet"/>
    @endpush

    @push('jsplugin')
        <script src="{{ asset('contents/admin') }}/assets/plugins/summernote/dist/summernote-bs4.min.js"></script>
        <script src="{{ asset('contents/admin') }}/assets/plugins/select2/js/select2.min.js"></script>
    @endpush

    @push('js')
        <script>
            $(function() {
                $('.description').summernote({
                    height: 400,
                    tabsize: 2
                });
                $('.single-select').select2();
            })
        </script>
    @endpush

@endsection

