@extends('layouts.frontend.index')
@section('content')

       <!-- Inne Page Banner Area Start Here -->
       <section class="inner-page-banner bg-common inner-page-top-margin" data-bg-image="img/figure/figure2.jpg">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumbs-area">
                        <h1>Appointment Form</h1>
                        <ul>
                            <li>
                                <a href="#">Home</a>
                            </li>
                            <li>Form</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inne Page Banner Area End Here -->
    <!-- Gallery Area Start Here -->
    <section class="appointment-wrap-layout1 bg-light-accent100">
        <div class="container">
            <div class="row no-gutters">
                <div class="col-xl-6">
                    <div class="appointment-box-layout1">
                        <h2 class="title title-bar-primary2">Make an Appointment</h2>
                        <p>Efficiently myocardinate market-driven innovation via open-source alignments.
                            Dramatically engage
                            porescently.</p>
                        <form action="{{ route('frontend_doctor_appoinment_submit') }}" method="POST">
                            @csrf
                            <div class="row gutters-15">
                                <div class="col-12 form-group">
                                    <select class="select2 department_select" data-error="Phone field is required" required>
                                        <option value="">Select Department *</option>
                                        @foreach (App\Department::orderBy('name','ASC')->get() as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                                        @endforeach
                                    </select>
                                    <div class="help-block with-errors"></div>
                                </div>
                                <div class="col-12 form-group">
                                    <select class="select2 doctor_select" name="doctor_id" data-error="Phone field is required" required>
                                        <option value="">Choose Doctor by Name *</option>
                                        @foreach (App\User::where('role_id',4)->orderBy('name','ASC')->get() as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                                        @endforeach
                                    </select>
                                    <div class="help-block with-errors"></div>
                                </div>
                                <div class="col-12 form-group">
                                    <input type="text" placeholder="Patient Name *" class="form-control" name="name"
                                        id="form-name" data-error="Name field is required" required>
                                    <div class="help-block with-errors"></div>
                                </div>
                                <div class="col-md-12 form-group">
                                    <select name="sex" id="" class="form-control select2">
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                    <div class="help-block with-errors"></div>
                                </div>
                                <div class="col-md-6 form-group">
                                    <input type="text" placeholder="Phone *" class="form-control" name="phone" id="form-phone"
                                        data-error="Phone field is required" required>
                                    <div class="help-block with-errors"></div>
                                </div>
                                <div class="col-md-6 form-group">
                                    <input type="email" placeholder="E-mail *" class="form-control" name="email" id="form-email"
                                        data-error="E-mail field is required" >
                                    <div class="help-block with-errors"></div>
                                </div>
                                <div class="col-sm-6 form-group">
                                    <i class="far fa-calendar-alt"></i>
                                    <input type="date" class="form-control rt-date" placeholder="Appointment Date *"
                                        name="date" id="form-date" data-error="Subject field is required" required />
                                    <div class="help-block with-errors"></div>
                                </div>

                                @if ($user != null && $user->doctor_schedule)
                                    <div class="col-sm-6 form-group">
                                        <i class="far fa-clock"></i>
                                        {{-- <input type="text" class="form-control rt-time" placeholder="Time *" name="time"
                                            id="form-time" data-error="Subject field is required" required /> --}}
                                        <select name="time" id="" class="form-control select2">
                                            @foreach ($user->doctor_schedule as $schedule)
                                                <option value="{{ Carbon\Carbon::parse($schedule->start_time)->format('h:i a') }} To {{ Carbon\Carbon::parse($schedule->end_time)->format('h:i a') }}|{{ $schedule->start_time }}|{{ $schedule->end_time }}">{{ Carbon\Carbon::parse($schedule->start_time)->format('h:i a') }} To {{ Carbon\Carbon::parse($schedule->end_time)->format('h:i a') }}</option>
                                            @endforeach
                                        </select>
                                        <div class="help-block with-errors"></div>
                                    </div>
                                @else
                                    <div class="col-sm-6 form-group">
                                        <i class="far fa-clock"></i>
                                        {{-- <input type="text" class="form-control rt-time" placeholder="Time *" name="time"
                                            id="form-time" data-error="Subject field is required" required /> --}}
                                        <select name="time" id="" class="form-control select2">
                                            @foreach (App\DoctorSchedule::get() as $schedule)
                                                <option value="{{ Carbon\Carbon::parse($schedule->start_time)->format('h:i a') }} To {{ Carbon\Carbon::parse($schedule->end_time)->format('h:i a') }}|{{ $schedule->start_time }}|{{ $schedule->end_time }}">{{ Carbon\Carbon::parse($schedule->start_time)->format('h:i a') }} To {{ Carbon\Carbon::parse($schedule->end_time)->format('h:i a') }}</option>
                                            @endforeach
                                        </select>
                                        <div class="help-block with-errors"></div>
                                    </div>
                                @endif

                                <div class="col-12 form-group">
                                    <textarea placeholder="Type Appintment Note" class="textarea form-control" name="remarks"
                                        id="form-message" rows="5" cols="20" data-error="Message field is required"
                                        required></textarea>
                                    <div class="help-block with-errors"></div>
                                </div>
                                <div class="col-12 form-group text-center">
                                    <button class="item-btn">Make an Appointment</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-xl-6">
                    <div class="appointment-banner">
                        <img src="{{ asset('contents/frontend') }}/img/figure/figure2.png" alt="appointment" class="img-fluid">
                    </div>
                </div>
            </div>
        </div>
    </section>

    @push('ccss')
        <!-- Select2 CSS -->
        <link rel="stylesheet" href="{{ asset('contents/frontend') }}/css/select2.min.css">
        <!-- Datetimepicker CSS -->
        <link rel="stylesheet" href="{{ asset('contents/frontend') }}/css/jquery.datetimepicker.css">
    @endpush

    @push('cjs')
        <!-- Select2 Js -->
        <script src="{{ asset('contents/frontend') }}/js/select2.min.js"></script>
        <!-- Datetimepicker Js -->
        <script src="{{ asset('contents/frontend') }}/js/jquery.datetimepicker.full.min.js"></script>
    @endpush

    @push('js')
        @if ($user != null)
            <script>
                $('.doctor_select').val({{$user->id}}).trigger('change');
                $('.department_select').val({{$user->doctor_department}}).trigger('change');
            </script>
        @endif
    @endpush
@endsection
