@extends('layouts.frontend.index')
@section('content')
<section class="inner-page-banner bg-common inner-page-top-margin"
    data-bg-image="{{ asset('contents/frontend') }}/img/figure/figure2.jpg"
    style="background-image: url(&quot;{{ asset('contents/frontend') }}/img/figure/figure2.jpg&quot;);">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="breadcrumbs-area">
                    <h1>Contact Us</h1>
                    <ul>
                        <li>
                            <a href="#">Home</a>
                        </li>
                        <li>Contact</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="contact-wrap-layout">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="contact-box-layout1">
                    <h3 class="title title-bar-primary4">Leave us your Message</h3>
                    <form class="contact-form-box" id="contact-form" method="POST"
                        action="{{ route('frontend_contact_submit') }}">
                        @csrf
                        <div class="row">
                            <div class="col-md-6 form-group">
                                <input type="text" placeholder="First Name *" class="form-control" name="first_name"
                                    data-error="Phone field is required">
                                <div class="help-block with-errors"></div>
                                @error('first_name')
                                <span class="alert text-danger"> {{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-6 form-group">
                                <input type="text" placeholder="Last Name *" class="form-control" name="last_name"
                                    data-error="E-mail field is required">
                                <div class="help-block with-errors"></div>
                                @error('last_name')
                                <span class="alert text-danger"> {{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-6 form-group">
                                <input type="email" placeholder="E-mail *" class="form-control" name="email"
                                    data-error="Subject field is required">
                                <div class="help-block with-errors"></div>
                                @error('email')
                                <span class="alert text-danger"> {{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-6 form-group">
                                <input type="text" placeholder="Phone *" class="form-control" name="phone"
                                    data-error="Subject field is required">
                                <div class="help-block with-errors"></div>
                                @error('phone')
                                <span class="alert text-danger"> {{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-12 form-group">
                                <input type="text" placeholder="Subject *" class="form-control" name="subject"
                                    data-error="Subject field is required">
                                <div class="help-block with-errors"></div>
                                @error('subject')
                                <span class="alert text-danger"> {{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-12 form-group">
                                <textarea placeholder="Message*" class="textarea form-control" name="message"
                                    id="form-message" rows="7" cols="20"
                                    data-error="Message field is required"></textarea>
                                <div class="help-block with-errors"></div>
                                @error('message')
                                <span class="alert text-danger"> {{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-12 form-group margin-b-none">
                                <button type="submit" class="item-btn disabled">Submit Message</button>
                            </div>
                        </div>
                        <div class="form-response"></div>
                    </form>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="contact-box-layout1">
                    <h3 class="title title-bar-primary4">Address</h3>
                    <div class="contact-info">
                        <ul>
                            <li><i class="fas fa-map-marker-alt"></i>309 Fellowship Road, Suite 200, Mt. Laurel, NJ
                                08054 United States of America <br>
                                Smart Care – Healthcare
                                Information Management Solution</li>
                            <li><i class="far fa-envelope"></i>support@smartcarehms.com</li>
                            <li><i class="fas fa-phone"></i>+609-318-0571</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection