@extends('layouts.frontend.index')
@section('content')

    <section class="inner-page-banner bg-common inner-page-top-margin" data-bg-image="{{ asset('contents/frontend') }}/img/figure/figure2.jpg" style="background-image: url(&quot;{{ asset('contents/frontend') }}/img/figure/figure2.jpg&quot;);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumbs-area">
                        <h1>All Doctors</h1>
                        <ul>
                            <li>
                                <a href="#">Home</a>
                            </li>
                            <li>All Doctors</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="team-wrap-layout2 bg-light-accent100">
        <div class="container">
            <div class="section-heading heading-dark text-center heading-layout4">
                <h2>Find A Doctor</h2>
                <p>Our find a doctor tool assists you in choosing from our diverse
                    pool of health specialists.</p>
            </div>
            <div class="isotope-wrap">
                <div class="text-center">
                    <div class="isotope-classes-tab isotop-btn">
                        <a href="#" class="current nav-item" data-filter="*">All</a>
                        @foreach (App\Department::orderBy('name','ASC')->get() as $department)
                            @if ($department->doctors->count() > 0)
                                <a href="#" class="nav-item" data-filter=".{{ str_replace(' ','_',$department->name) }}">{{ $department->name }}</a>
                            @endif
                        @endforeach
                    </div>
                </div>
                <div class="row featuredContainer" id="no-equal-gallery">

                    @foreach (App\User::where("role_id",4)->get()->take(8) as $item)
                        @if ($item->department)
                            <div class="no-equal-item col-xl-3 col-lg-4 col-md-6 col-sm-6 col-12 * {{ str_replace(' ','_',$item->department->name) }}">
                                <div class="team-box-layout2">
                                    <div class="item-img">
                                        <img src="{{ asset(''.$item->photo) }}" alt="Team1" class="img-fluid rounded-circle">
                                        <ul class="item-icon">
                                            <li>
                                                <a href="{{ route('frontend_doctor') }}">
                                                    <i class="fas fa-plus"></i>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="item-content">
                                        <h3 class="item-title">
                                            <a href="{{ route('frontend_doctor_details',$item->slug) }}"> {{ $item->name }}</a>
                                        </h3>
                                        @if ($item->department)
                                            <p>{{ $item->department->name }}</p>
                                        @endif
                                    </div>
                                    <div class="item-schedule">
                                        @if ($item->doctor_schedule)
                                            <ul style="display:block;">
                                                {{-- @foreach ($item->doctor_schedule as $schedule)
                                                    <li style="height: 20px; padding-left: 25px;">
                                                        {{ $schedule->from_day }}{{ ' - '.$schedule->to_day }} <br>
                                                    {{ Carbon\Carbon::parse($schedule->start_time)->format('h:i a') }} - {{ Carbon\Carbon::parse($schedule->end_time)->format('h:i a') }}
                                                    </li>
                                                @endforeach --}}
                                                @foreach ($item->time_schedule as $time)
                                                    <li style="margin: 2px 0px">{{ $time->day_name }} <span>{{ Carbon\Carbon::parse($time->start_time)->format('h:i a') }} to {{ Carbon\Carbon::parse($time->end_time)->format('h:i a') }}</span></li>
                                                @endforeach
                                            </ul>
                                        @endif
                                        <a href="{{ route('frontend_doctor_details',$item->slug) }}" class="item-btn">MAKE AN APPOINTMENT</a>
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endforeach

                </div>
            </div>
        </div>
    </section>
@endsection
