@extends('layouts.frontend.index')
@section('content')

    <section class="inner-page-banner bg-common inner-page-top-margin" data-bg-image="{{ asset('contents/frontend') }}/img/figure/figure2.jpg" style="background-image: url(&quot;{{ asset('contents/frontend') }}/img/figure/figure2.jpg&quot;);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumbs-area">
                        <h1>Single Doctor</h1>
                        <ul>
                            <li>
                                <a href="#">Home</a>
                            </li>
                            <li>
                                <a href="#">Doctor</a>
                            </li>
                            <li>Details</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="team-details-wrap-layout1 bg-light-accent100">
        <div class="container">
            <div class="row">
                <div class="order-xl-2 order-lg-2 col-xl-9 col-lg-8 col-md-12 col-12">
                    <div class="team-detail-box-layout1">
                        {{-- <div class="single-item">
                            <h3 class="section-title title-bar-primary2">About Me:</h3>
                            <p>Efficiently myocardinate market-driven innovation via open-source alignments.
                                Dramatically engage high-Phosfluorescently expedite impactful supply chains via
                                focused results. Holistically . Compellingly supply just in time catalysts for
                                change through..</p>
                        </div>
                        <div class="single-item">
                            <div class="table-responsive">
                                <h3 class="section-title title-bar-primary2">Education:</h3>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Year</th>
                                            <th>Degree</th>
                                            <th>Institute</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>2006</td>
                                            <td>MBBS, M.D</td>
                                            <td>University of Wyoming</td>
                                        </tr>
                                        <tr>
                                            <td>2010</td>
                                            <td>M.D. of Medicine</td>
                                            <td>Netherland Medical College</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="single-item">
                            <div class="table-responsive">
                                <h3 class="section-title title-bar-primary2">Experienced:</h3>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Year</th>
                                            <th>Department</th>
                                            <th>Position</th>
                                            <th>Hospital</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>2007 - 2008</td>
                                            <td>MBBS, M.D</td>
                                            <td>Senior Prof.</td>
                                            <td>Midtown Medical Clinic</td>
                                        </tr>
                                        <tr>
                                            <td>2010 - 2018</td>
                                            <td>M.D. of Medicine</td>
                                            <td>Associate Prof.</td>
                                            <td>Netherland Medical College</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div> --}}

                        <div class="single-item">
                            <div class="table-responsive">
                                <h3 class="section-title title-bar-primary2">Appointmnet Schedules:</h3>
                                <table class="table schedule-table">
                                    <thead>
                                        <tr>
                                            <th>Day</th>
                                            <th>Time</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($user->doctor_schedule as $schedule)
                                            <tr>
                                                <td>{{ $schedule->from_day }} - {{ $schedule->to_day }}</td>
                                                <td> {{ Carbon\Carbon::parse($schedule->start_time)->format('h:i a') }} - {{ Carbon\Carbon::parse($schedule->end_time)->format('h:i a') }} </td>
                                                <td class="schedule-btn"><a href="{{ route('frontend_doctor_appoinment') }}?slug={{ $user->slug }}" class="item-btn">Appointment</a></td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="order-xl-1 order-lg-1 sidebar-widget-area sidebar-break-md col-xl-3 col-lg-4 col-md-12 col-12">
                    <div class="widget widget-about-team">
                        <div class="img text-center">
                            <img src="{{ asset(''.$user->photo) }}" class="img-fluid" alt="team">
                        </div>
                        <div class="item-content">
                            <h3 class="item-title"> {{  $user->name }} </h3>
                            <p class="item-ctg"> {{ $user->department->name }}</p>
                            <span class="item-designation">{{ $user->profile }}</span>
                        </div>
                    </div>
                    <div class="widget widget-team-contact">
                        <h3 class="section-title title-bar-primary2">Personal Info</h3>
                        <ul>
                            <li>Phone:<span>{{ $user->phone }}</span></li>
                            <li>E-mail:<span>{{ $user->email }}</span></li>
                            {{-- <li class="d-flex">Social:
                                <ul class="widget-social">
                                    <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                                    <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                                    <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li>
                                    <li><a href="#"><i class="fab fa-skype"></i></a></li>
                                </ul>
                            </li> --}}
                        </ul>
                    </div>
                    <div class="widget widget-call-to-action">
                        <div class="media">
                            <img src="{{ asset('contents/frontend') }}/img/figure/figure1.png" alt="figure">
                            <div class="media-body space-sm">
                                <h4>Emergency Cases</h4>
                                <span>2-800-700-6200</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
