@extends('layouts.frontend.index')
@section('content')
        <!-- Slider Area Start Here -->
        <div class="slider-area slider-layout1 bg-light-primary slider-top-margin">
            <div class="bend niceties preview-1">
                <div id="ensign-nivoslider-1" class="slides">
                    @foreach (App\Banner::where('status',1)->latest()->get()->take(5) as $key => $item)
                        <img src="{{ asset(''.$item->image) }}" alt="slider" title="#slider-direction-{{$key+1}}" />
                    @endforeach
                </div>

                @foreach (App\Banner::where('status',1)->latest()->get()->take(5) as $key => $item)
                    <div id="slider-direction-{{$key+1}}" class="t-cn slider-direction">
                        <div class="slider-content s-tb slide-{{$key+1}}">
                            <div class="text-left title-container s-tb-c">
                                <div class="container">
                                    <div class="slider-big-text padding-right">{{ $item->title }}</div>
                                    <p class="slider-paragraph padding-right">{{ $item->subtitle }}</p>
                                    <div class="slider-btn-area">
                                        {{-- <a href="{{ $item->url }}" class="item-btn">Read More<i class="fas fa-chevron-right"></i></a> --}}
                                        <a href="/hospital/contact" class="item-btn">Get Quote<i class="fas fa-chevron-right"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
        <!-- Slider Area End Here -->

        @foreach (App\welcome::where('status',1)->orderBy('id', 'DESC')->get()->take(1) as $key => $welcome)
        <!-- About Area Start Here -->
        <section class="about-wrap-layout1" data-bg-image="{{ asset('contents/frontend') }}/img/figure/figure7.jpg">
            <div class="container">
                <div class="row">

                    <div class="about-box-layout1 order-xl-2 col-xl-5 col-12">
                        <div class="item-content">
                            <h2 class="item-title">{{$welcome->title}}</h2>
                            <div class="sub-title">{{$welcome->subtitle}}
                            </div>
                            <p>{!!$welcome->details!!}</p>
                            <img src="{{ asset(''.$welcome->image_two) }}" alt="sign" class="img-fluid">
                        </div>
                    </div>

                    <div class="about-box-layout2 order-xl-3 col-xl-4 col-lg-7 col-12">
                        <ul>
                            <li><a href="#"><i class="fas fa-plus"></i>Integrated Telehealth |
                                Telemedicine</a></li>
                            <li><a href="#"><i class="fas fa-plus"></i>Integrated Accounting | Financial
                                Reporting I Invoicing</a></li>
                            <li><a href="#"><i class="fas fa-plus"></i>Human Capital | Resources
                                Management</a></li>
                            <li><a href="#"><i class="fas fa-plus"></i>Pharmacy Management |
                                Laboratory Management</a></li>
                        </ul>
                    </div>
                    <div class="about-box-layout2 order-xl-1 col-xl-3 col-lg-5 col-12">
                        <div class="item-img">
                            <img src="{{ asset(''.$welcome->image) }}" alt="about" class="img-fluid">
                        </div>
                    </div>
                </div>
            </div>
        </section>
        @endforeach
        <!-- About Area End Here -->

        <!-- Featured Area Start Here -->
        <section class="features-wrap-layout1">
            @foreach (App\Choose::where('status',1)->orderBy('id', 'DESC')->get()->take(1) as $key => $choose)
            <div class="features-box-layout1 d-lg-flex bg-primary100">
                <div class="item-inner-wrapper">
                    <div class="item-content d-flex align-items-center">
                        <div class="container">
                            <div class="row">
                                <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="item-content-inner content-light">
                                        <h2 class="item-title">{{$choose->title}}</h2>
                                        <p>{{$choose->subtitle}}</p>
                                        <ul class="list-item">
                                            <li>Hospitals</li>
                                            <li>Diagnostic Centers</li>
                                            <li>Clinics</li>
                                            <li>Nursing Homes</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="item-inner-wrapper">
                    <img src="{{ asset('/uploads/'.$choose->image) }}" class="img-responsive" alt="figure">
                </div>
            </div>
            @endforeach
            @foreach (App\Trusted::where('status',1)->orderBy('id', 'DESC')->get()->take(1) as $key => $trust)
            <div class="features-box-layout1 d-lg-flex flex-lg-row-reverse">
                <div class="item-inner-wrapper">
                    <div class="item-content d-flex align-items-center">
                        <div class="container">
                            <div class="row justify-content-end">
                                <div class="col-lg-6 col-sm-12 col-12">
                                    <div class="item-content-inner inner-title-dark">
                                        <h2 class="item-title">{{$trust->title}}</h2>
                                        <p>{{$trust->subtitle}}
                                        </p>
                                        <div class="skill-layout1">
                                            <div class="progress">
                                                <div class="lead">Efficency</div>
                                                <div style="width: 80%; visibility: visible; animation-duration: 1.5s; animation-delay: 0.4s;"
                                                    data-progress="95%" class="progress-bar progress-bar-striped wow fadeInLeft animated">
                                                    <span>80%</span>
                                                </div>
                                            </div>
                                            <div class="progress">
                                                <div class="lead">Experience</div>
                                                <div style="width: 95%; visibility: visible; animation-duration: 1.5s; animation-delay: 0.6s;"
                                                    data-progress="85%" class="progress-bar progress-bar-striped wow fadeInLeft animated">
                                                    <span>95%</span>
                                                </div>
                                            </div>
                                            <div class="progress">
                                                <div class="lead">Experience</div>
                                                <div style="width: 75%; visibility: visible; animation-duration: 1.5s; animation-delay: 0.8s;"
                                                    data-progress="99%" class="progress-bar progress-bar-striped wow fadeInLeft animated">
                                                    <span>75%</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="item-inner-wrapper">
                    <img src="{{ asset('/uploads/'.$trust->image) }}" class="img-responsive" alt="figure">
                </div>
            </div>
            @endforeach
        </section>
        <!-- Featured Area End Here -->


        <!-- Team Area Start Here -->
        <!-- Team Area Start Here -->
        {{-- <section class="team-wrap-layout1 bg-light-secondary100">
            <img class="left-img img-fluid" src="{{ asset('contents/frontend') }}/img/figure/figure4.png" alt="figure">
            <img class="right-img img-fluid" src="{{ asset('contents/frontend') }}/img/figure/figure5.png" alt="figure">
            <div class="container">
                <div class="section-heading heading-dark text-left heading-layout1">
                    <h2>Specialist Doctors</h2>
                    <p>Experienced Doctor</p>
                    <div id="owl-nav2" class="owl-nav-layout1">
                        <span class="rt-prev">
                            <i class="fas fa-chevron-left"></i>
                        </span>
                        <span class="rt-next">
                            <i class="fas fa-chevron-right"></i>
                        </span>
                    </div>
                </div>
                <div class="rc-carousel nav-control-layout2 home_doctor_slide" data-loop="true" data-items="4" data-margin="30"
                    data-autoplay="false" data-autoplay-timeout="5000" data-custom-nav="#owl-nav2" data-smart-speed="2000"
                    data-dots="false" data-nav="false" data-nav-speed="false" data-r-x-small="1" data-r-x-small-nav="true"
                    data-r-x-small-dots="false" data-r-x-medium="2" data-r-x-medium-nav="false" data-r-x-medium-dots="false"
                    data-r-small="2" data-r-small-nav="false" data-r-small-dots="false" data-r-medium="3"
                    data-r-medium-nav="false" data-r-medium-dots="false" data-r-large="3" data-r-large-nav="false"
                    data-r-large-dots="false" data-r-extra-large="4" data-r-extra-large-nav="false"
                    data-r-extra-large-dots="false">

                    @foreach (App\User::where("role_id",4)->get()->take(8) as $item)

                        <div class="team-box-layout2">
                            <div class="item-img">
                                <img src="{{ asset(''.$item->photo) }}" alt="Team1" class="img-fluid rounded-circle">
                                <ul class="item-icon">
                                    <li>
                                        <a href="{{ route('frontend_doctor') }}">
                                            <i class="fas fa-plus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                            <div class="item-content">
                                <h3 class="item-title">
                                    <a href="{{ route('frontend_doctor_details',$item->slug) }}"> {{ $item->name }}</a>
                                </h3>
                                @if ($item->department)
                                    <p>{{ $item->department->name }}</p>
                                @endif
                            </div>
                            <div class="item-schedule">
                                @if ($item->doctor_schedule)
                                    <ul>

                                        @foreach ($item->time_schedule as $time)
                                            <li style="margin: 2px 0px">{{ $time->day_name }} <span>{{ Carbon\Carbon::parse($time->start_time)->format('h:i a') }} to {{ Carbon\Carbon::parse($time->end_time)->format('h:i a') }}</span></li>
                                        @endforeach
                                    </ul>
                                @endif
                                <a href="{{ route('frontend_doctor_details',$item->slug) }}" class="item-btn">MAKE AN APPOINTMENT</a>
                            </div>
                        </div>

                    @endforeach

                </div>

            </div>
        </section> --}}
        <!-- Team Area End Here -->

        <!-- Schedule Area Start Here -->
        {{-- <section class="class-schedule1">
            <div class="container">
                <div class="section-heading heading-dark text-center heading-layout1">
                    <h2>Doctors Time Schedule</h2>
                    <p>Experienced Doctor</p>
                </div>
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="class-schedule-wrap1">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>
                                                <div class="schedule-time-heading">Time</div>
                                            </th>
                                            <td>
                                                <div class="schedule-day-heading">Saturday</div>
                                            </td>
                                            <td>
                                                <div class="schedule-day-heading">Sunday</div>
                                            </td>
                                            <td>
                                                <div class="schedule-day-heading">Monday</div>
                                            </td>
                                            <td>
                                                <div class="schedule-day-heading">Tuesday</div>
                                            </td>
                                            <td>
                                                <div class="schedule-day-heading">Wednesday</div>
                                            </td>
                                            <td>
                                                <div class="schedule-day-heading">Thursday</div>
                                            </td>
                                            <td>
                                                <div class="schedule-day-heading">Friday</div>
                                            </td>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @php
                                            $all_times = App\DoctorScheduleDayTime::orderBy('start_time')->get()->unique('start_time');
                                            $time_slots = [];
                                            foreach ($all_times as $key => $value) {
                                                array_push($time_slots,Carbon\Carbon::parse($value->start_time)->format('G:00'));
                                            }

                                            $time_slots = array_values(array_unique($time_slots));
                                        @endphp

                                        @foreach ( $time_slots as $key => $time)

                                            <tr>
                                                <th scope="row">
                                                    <div class="schedule-time-wrapper"> {{ Carbon\Carbon::parse($time)->format('h:i a') }}</div>
                                                </th>
                                                @for ($i = 1; $i <= 7; $i++)
                                                    <td>
                                                        @php
                                                            switch($i){
                                                                case 1 :{
                                                                    $day = 'Saturday';
                                                                    break;
                                                                }
                                                                case 2 :{
                                                                    $day = 'Sunday';
                                                                    break;
                                                                }
                                                                case 3 :{
                                                                    $day = 'Monday';
                                                                    break;
                                                                }
                                                                case 4 :{
                                                                    $day = 'Tuesday';
                                                                    break;
                                                                }
                                                                case 5 :{
                                                                    $day = 'Wednesday';
                                                                    break;
                                                                }
                                                                case 6 :{
                                                                    $day = 'Thursday';
                                                                    break;
                                                                }
                                                                case 7 :{
                                                                    $day = 'Friday';
                                                                    break;
                                                                }
                                                            }
                                                        @endphp
                                                        @if (App\DoctorScheduleDayTime::whereBetween('start_time',[$time,isset($time_slots[$key+1])?$time_slots[$key+1]:Carbon\Carbon::parse($time_slots[$key])->format('G:59')])->exists())
                                                            @php
                                                                $data = App\DoctorScheduleDayTime::where('day_name',$day)->whereBetween('start_time',[$time,isset($time_slots[$key+1])?$time_slots[$key+1]:Carbon\Carbon::parse($time_slots[$key])->format('G:59')])->get();
                                                                // dd($all_times,   $time_slots,    isset($time_slots[$key+1])?$time_slots[$key+1]:$time_slots[0],  $data);
                                                            @endphp
                                                            @foreach ($data as $docs)
                                                                <div class="schedule-item-wrapper" style="border: 1px solid #8080807d;margin-bottom: 5px;">

                                                                    <div class="media">
                                                                        <div class="item-img">
                                                                            <img style="width: 70px;" src="{{ asset(''.$docs->doctor->photo) }}" alt="team" class="img-fluid rounded-circle">
                                                                        </div>
                                                                        <div class="media-body">
                                                                            <h3 class="title">{{ $docs->doctor->name }}</h3>
                                                                            <div class="item-ctg">{{ $docs->doctor->doctor_profile }}</div>
                                                                            <a href="{{ route('frontend_doctor_details',$docs->doctor->slug) }}" class="item-btn btn-fill size-xs radius-4">View
                                                                                Profile</a>
                                                                        </div>
                                                                    </div>
                                                                    <div class="item-ctg">{{ $docs->doctor->department->name }}</div>
                                                                    <div class="item-time">{{ Carbon\Carbon::parse($docs->start_time)->format('h:i a') }} To {{ Carbon\Carbon::parse($docs->end_time)->format('h:i a') }}</div>
                                                                    <div class="item-team">{{ $docs->doctor->name }}</div>
                                                                </div>
                                                            @endforeach
                                                        @else
                                                            <div class="schedule-item-wrapper">

                                                            </div>
                                                        @endif

                                                    </td>
                                                @endfor


                                            </tr>

                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section> --}}
        <!-- Schedule Area End Here -->

        <!-- Banner Area Start Here -->
        {{-- @foreach (App\Emergencycase::where('status',1)->orderBy('id', 'DESC')->get()->take(1) as $key => $emergency)
        <section class="banner-wrap-layout1 parallaxie" data-bg-image="{{ asset('/uploads/'.$emergency->image) }}">
            <div class="container">
                <div class="row">
                    <div class="col-xl-5 col-lg-8 col-md-10 col-12">
                        <div class="banner-box-layout1">
                            <h2 class="item-title">{{$emergency->title}}</h2>
                            <h3 class="phone-number">{{$emergency->subtitle}}</h3>
                            <p>{!!$emergency->details!!}</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        @endforeach --}}
        <!-- Banner End Here -->

        <!-- Call to Action Area Start Here -->
        {{-- <section class="call-to-action-wrap-layout4">
            <div class="item-img">
                <img src="{{ asset('contents/frontend') }}/img/figure/figure7.png" alt="figure" class="img-fluid">
            </div>
            <div class="container">
                <div class="row">
                    <div class="col-xl-12 col-lg-8 col-md-8 col-12">
                        <div class="call-to-action-box-layout4">
                            <h2 class="item-title">We Provide the highest level of satisfaction care &amp; services to
                                our patients.</h2>
                            <div class="call-to-action-phone">
                                <a href="tel:+12344092888"><i class="fas fa-phone"></i>+123 44092 888</a>
                            </div>
                            <div class="call-to-action-btn">
                                <a href="{{ route('frontend_doctor_appoinment') }}" class="item-btn">Make an Appointment</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section> --}}
        <!-- Call to Action End Here -->

@endsection
