@extends('layouts.website.website')
@section('content')
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
                Holiday
                <div class="col-md-4 no-print pull-right">
                    <a data-toggle="modal" href="#myModal">
                        <div class="btn-group pull-right">
                            <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add New</button>
                        </div>
                    </a>
                </div>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table">
                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Doctor</th>
                                <th>Date</th>
                                <th>Options</th>
                            </tr>
                        </thead>
                        <tbody>
                            <style>
                                .img_url {
                                    height: 20px;
                                    width: 20px;
                                    background-size: contain;
                                    max-height: 20px;
                                    border-radius: 100px;
                                }
                            </style>
                            @foreach (App\DoctorHoliday::latest()->get() as $item)
                                <tr class="">
                                    <td>{{ $item->id }}</td>
                                    <td>{{ $item->doctor->name }}</td>
                                    <td>{{ Carbon\Carbon::parse($item->date)->format('d F Y') }}</td>
                                    <td>
                                        <button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="{{ $item->id }}"><i class="fa fa-edit"></i> Edit</button>
                                        <a class="btn btn-info btn-xs btn_width delete_button delete_button_modal" data-toggle="modal" data-target="#modal-animation-1" title="Delete" href="#" data-href="{{ route('delete_doctor_schedule_holiday',$item->id) }}" >
                                            <i class="fa fa-trash"> </i> Delete
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->

<!-- Add Holiday Modal-->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Add Holiday</h4>
            </div>
            <div class="modal-body">
                <form role="form" action="{{ route('store_doctor_schedule_holiday') }}" class="clearfix" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group col-md-6 row">
                        <label for="exampleInputEmail1"> Doctor</label>
                        <select class="form-control m-bot15" id="doctorchoose" name="doctor" value="">
                            @foreach (App\User::where('role_id',4)->orderBy('name','ASC')->where('status',1)->get() as $doc)
                                <option value="{{ $doc->id }}">{{ $doc->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-md-6 pull-right">
                        <label for="exampleInputEmail1"> Date</label>
                        <input type="text" class="form-control default-date-picker" name="date" id="exampleInputEmail1" value="" readonly="" />
                    </div>

                    <input type="hidden" name="id" value="" />
                    <input type="hidden" name="redirect" value="schedule/allHolidays" />

                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- Add Holiday Modal-->

<!-- Edit Holiday Modal-->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Edit Holiday</h4>
            </div>
            <div class="modal-body">
                <form role="form" id="editHolidayForm" class="clearfix" action="{{ route('update_doctor_schedule_holiday') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group col-md-6 row">
                        <label for="exampleInputEmail1"> Doctor</label>
                        <select class="form-control m-bot15" id="doctorchoose1" name="doctor" value="">
                            @foreach (App\User::where('role_id',4)->orderBy('name','ASC')->where('status',1)->get() as $doc)
                                <option value="{{ $doc->id }}">{{ $doc->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-md-6 pull-right">
                        <label for="exampleInputEmail1"> Date</label>
                        <input type="text" class="form-control default-date-picker" name="date" id="exampleInputEmail1" value="" readonly="" />
                    </div>

                    <input type="hidden" name="id" value="" />
                    <input type="hidden" name="redirect" value="schedule/allHolidays" />

                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- Edit Holiday Modal-->

<script type="text/javascript">
    $(document).ready(function () {
        $(".editbutton").click(function (e) {
            e.preventDefault(e);
            // Get the record's ID via attribute
            var iid = $(this).attr("data-id");
            $("#editHolidayForm").trigger("reset");
            $("#myModal2").modal("show");
            $.ajax({
                url: "/schedule/allHolidays/edit/" + iid,
                method: "GET",
                data: "",
                dataType: "json",
            }).success(function (response) {
                // Populate the form fields with the data returned from server
                $("#editHolidayForm").find('[name="id"]').val(response.id).end();
                $(".js-example-basic-single.doctor").val(response.doctor).trigger("change");
                $("#editHolidayForm")
                    .find('[name="date"]')
                    .val(response.date).end();
                $("#editHolidayForm").find('[name="doctor"]').val(response.doctor_id).trigger('change');
            });
        });
    });
</script>

<script>
    $(document).ready(function () {
        $("#patientchoose").select2({
            placeholder: "Search Patient Name / ID",
            allowClear: true,
            // ajax: {
            //     url: "patient/getPatientinfo",
            //     type: "post",
            //     dataType: "json",
            //     delay: 250,
            //     data: function (params) {
            //         return {
            //             searchTerm: params.term, // search term
            //         };
            //     },
            //     processResults: function (response) {
            //         return {
            //             results: response,
            //         };
            //     },
            //     cache: true,
            // },
        });
        $("#doctorchoose").select2({
            placeholder: "Search Doctor Name / ID",
            allowClear: true,
            // ajax: {
            //     url: "doctor/getDoctorinfo",
            //     type: "post",
            //     dataType: "json",
            //     delay: 250,
            //     data: function (params) {
            //         return {
            //             searchTerm: params.term, // search term
            //         };
            //     },
            //     processResults: function (response) {
            //         return {
            //             results: response,
            //         };
            //     },
            //     cache: true,
            // },
        });
        $("#doctorchoose1").select2({
            placeholder: "Search Doctor Name / ID",
            allowClear: true,
            // ajax: {
            //     url: "doctor/getDoctorInfo",
            //     type: "post",
            //     dataType: "json",
            //     delay: 250,
            //     data: function (params) {
            //         return {
            //             searchTerm: params.term, // search term
            //         };
            //     },
            //     processResults: function (response) {
            //         return {
            //             results: response,
            //         };
            //     },
            //     cache: true,
            // },
        });
    });
</script>


@endsection
