@extends('layouts.website.website')
@section('content')

    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="panel">
                <header class="panel-heading"><i class="fa fa-money"></i> Treatment History</header>
                <div class="space15"></div>
                <div class="col-md-12">
                    <div class="col-md-7 panel-body">
                        <section>
                            <form role="form" class="f_report" action="appointment/treatmentReport" method="post" enctype="multipart/form-data">
                                <div class="form-group">
                                    <!--     <label class="control-label col-md-3">Date Range</label> -->
                                    <div class="col-md-6">
                                        <div class="input-group input-large" data-date="13/07/2013" data-date-format="mm/dd/yyyy">
                                            <input type="text" class="form-control dpd1" name="date_from" value="" placeholder=" Date From" />
                                            <span class="input-group-addon">to</span>
                                            <input type="text" class="form-control dpd2" name="date_to" value="" placeholder=" Date To" />
                                        </div>
                                        <div class="row"></div>
                                        <span class="help-block"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <button type="submit" name="submit" class="btn btn-info range_submit">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </section>
                    </div>
                    <div class="col-md-5"></div>
                </div>

                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <div class="clearfix">
                            <button class="export" onclick="javascript:window.print();">Print</button>
                        </div>
                        <div class="space15"></div>

                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th>Doctor Id</th>
                                    <th>Doctor</th>
                                    <th>Number Of Patient Treated</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <style>
                                    .img_url {
                                        height: 20px;
                                        width: 20px;
                                        background-size: contain;
                                        max-height: 20px;
                                        border-radius: 100px;
                                    }
                                    .option_th {
                                        width: 18%;
                                    }
                                </style>

                                @foreach (App\User::where('role_id',4)->get() as $item)

                                    <tr class="">
                                        <td> {{ $item->id }}</td>
                                        <td> {{ $item->name }} </td>
                                        <td>
                                            {{ App\DoctorPrescription::where('doctor_id',$item->id)->get()->unique('id')->count() }}
                                        </td>
                                        <td>
                                            <a class="btn btn-info btn-xs btn_width add_payment_button" style="width: 100px;" href="{{ route('getAppointmentByDoctorId_doctor_appointment',$item->id) }}"><i class="fa fa-money"></i> Details</a>
                                        </td>
                                    </tr>

                                @endforeach


                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>
    <!--main content end-->


@endsection
