@extends('layouts.website.website')
@section('content')
    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="panel">
                <header class="panel-heading">
                    Appointment
                    <div class="clearfix no-print col-md-8 pull-right">
                        @if (Auth::user()->role_id != 8)
                            <a data-toggle="modal" href="#myModal">
                                <div class="btn-group pull-right">
                                    <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add
                                        Appointment</button>
                                </div>
                            </a>
                        @endif
                    </div>
                </header>

                <div class="col-md-12">
                    <header class="panel-heading tab-bg-dark-navy-blueee row">
                        <ul class="nav nav-tabs col-md-8">
                            <li class="active">
                                <a data-toggle="tab" href="#all">All</a>
                            </li>
                            <li class="">
                                <a data-toggle="tab" href="#pending">Pending Confirmation</a>
                            </li>
                            <li class="">
                                <a data-toggle="tab" href="#confirmed">Confirmed</a>
                            </li>
                            <li class="">
                                <a data-toggle="tab" href="#treated">Treated</a>
                            </li>
                            <li class="">
                                <a data-toggle="tab" href="#cancelled">Cancelled</a>
                            </li>
                            <li class="">
                                <a data-toggle="tab" href="#requested">Requested</a>
                            </li>
                        </ul>

                        <div class="pull-right col-md-4">
                            <div class="pull-right custom_buttonss"></div>
                        </div>
                    </header>
                </div>

                <div class="">
                    <div class="tab-content">
                        <div id="all" class="tab-pane active">
                            <div class="">
                                <div class="panel-body">
                                    <div class="adv-table editable-table">
                                        <div class="space15"></div>
                                        <table class="table table-striped table-hover table-bordered" id="editable-sample5"
                                            style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th>Id</th>
                                                    <th>Patient</th>
                                                    <th>Doctor</th>
                                                    <th>Date - Time</th>
                                                    <th>Remarks</th>
                                                    <th>Status</th>
                                                    <th>Options</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($DoctorAppoinment as $item)
                                                    <tr>
                                                        <td>{{ $item->id }}</td>
                                                        @if ($item->patient)
                                                            <td>{{ $item->patient->name }}</td>
                                                        @else
                                                            <td></td>
                                                        @endif
                                                        @if ($item->doctor)
                                                            <td>{{ $item->doctor->name }}</td>
                                                        @else
                                                            <td></td>
                                                        @endif
                                                        <td>{{ $item->appoinment_date }} | {{ $item->appoinment_time }}</td>
                                                        <td> {{ $item->remarks }}</td>
                                                        <td> {{ $item->appoinment_status }}</td>
                                                        <td>
                                                            @if (Auth::user()->role_id != 8)
                                                                <button type="button"
                                                                    class="btn btn-info btn-xs btn_width editbutton"
                                                                    data-toggle="modal" data-id="{{ $item->id }}">
                                                                    <i class="fa fa-edit"> Edit</i>
                                                                </button>
                                                                <a class="btn btn-info btn-xs btn_width delete_button delete_button_modal"
                                                                    data-toggle="modal" data-target="#modal-animation-1"
                                                                    title="Delete" href="#"
                                                                    data-href="{{ route('delete_doctor_appointment', $item->id) }}">
                                                                    <i class="fa fa-trash"> </i>
                                                                </a>
                                                            @endif
                                                            @if (Auth::user()->role_id == 8 || Auth::user()->role_id == 4)
                                                                <a class="btn btn-info btn-xs btn_width detailsbutton"
                                                                    title="Start Live" style="color: #fff;"
                                                                    href="{{ route('website_appointment_meeting') }}?id={{ $item->id }}"
                                                                    target="_blank"
                                                                    onclick="return confirm('Are you sure you want to start a live meeting with this patient? SMS and Email will be sent to the Patient.');">
                                                                    <i class="fa fa-headphones"></i>
                                                                    Live
                                                                </a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                                <style>
                                                    .img_url {
                                                        height: 20px;
                                                        width: 20px;
                                                        background-size: contain;
                                                        max-height: 20px;
                                                        border-radius: 100px;
                                                    }
                                                </style>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="pending" class="tab-pane">
                            <div class="">
                                <div class="panel-body">
                                    <div class="adv-table editable-table">
                                        <div class="space15"></div>
                                        <table class="table table-striped table-hover table-bordered" id="editable-sample1"
                                            style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th>Id</th>
                                                    <th>Patient</th>
                                                    <th>Doctor</th>
                                                    <th>Date - Time</th>
                                                    <th>Remarks</th>
                                                    <th>Status</th>
                                                    <th>Options</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($pendingDoctorAppoinment as $item)
                                                    <tr>
                                                        <td>{{ $item->id }}</td>
                                                        @if ($item->patient)
                                                            <td>{{ $item->patient->name }}</td>
                                                        @else
                                                            <td></td>
                                                        @endif
                                                        @if ($item->doctor)
                                                            <td>{{ $item->doctor->name }}</td>
                                                        @else
                                                            <td></td>
                                                        @endif
                                                        <td>{{ $item->appoinment_date }} | {{ $item->appoinment_time }}
                                                        </td>
                                                        <td> {{ $item->remarks }}</td>
                                                        <td> {{ $item->appoinment_status }}</td>
                                                        <td>
                                                            @if (Auth::user()->role_id != 8)
                                                                <button type="button"
                                                                    class="btn btn-info btn-xs btn_width editbutton"
                                                                    data-toggle="modal" data-id="{{ $item->id }}">
                                                                    <i class="fa fa-edit"> Edit</i>
                                                                </button>
                                                                <a class="btn btn-info btn-xs btn_width delete_button delete_button_modal"
                                                                    data-toggle="modal" data-target="#modal-animation-1"
                                                                    title="Delete" href="#"
                                                                    data-href="{{ route('delete_doctor_appointment', $item->id) }}">
                                                                    <i class="fa fa-trash"> </i>
                                                                </a>
                                                            @endif
                                                            @if (Auth::user()->role_id == 8 || Auth::user()->role_id == 4)
                                                                <a class="btn btn-info btn-xs btn_width detailsbutton"
                                                                    title="Start Live" style="color: #fff;"
                                                                    href="{{ route('website_appointment_meeting') }}?id={{ $item->id }}"
                                                                    target="_blank"
                                                                    onclick="return confirm('Are you sure you want to start a live meeting with this patient? SMS and Email will be sent to the Patient.');">
                                                                    <i class="fa fa-headphones"></i>
                                                                    Live
                                                                </a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                                <style>
                                                    .img_url {
                                                        height: 20px;
                                                        width: 20px;
                                                        background-size: contain;
                                                        max-height: 20px;
                                                        border-radius: 100px;
                                                    }
                                                </style>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div id="confirmed" class="tab-pane">
                            <div class="">
                                <div class="panel-body">
                                    <div class="adv-table editable-table">
                                        <div class="space15"></div>
                                        <table class="table table-striped table-hover table-bordered" id="editable-sample2"
                                            style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th>Id</th>
                                                    <th>Patient</th>
                                                    <th>Doctor</th>
                                                    <th>Date - Time</th>
                                                    <th>Remarks</th>
                                                    <th>Status</th>
                                                    <th>Options</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($confirmDoctorAppoinment as $item)
                                                    <tr>
                                                        <td>{{ $item->id }}</td>
                                                        @if ($item->patient)
                                                            <td>{{ $item->patient->name }}</td>
                                                        @else
                                                            <td></td>
                                                        @endif
                                                        @if ($item->doctor)
                                                            <td>{{ $item->doctor->name }}</td>
                                                        @else
                                                            <td></td>
                                                        @endif
                                                        <td>{{ $item->appoinment_date }} | {{ $item->appoinment_time }}
                                                        </td>
                                                        <td> {{ $item->remarks }}</td>
                                                        <td> {{ $item->appoinment_status }}</td>
                                                        <td>
                                                            @if (Auth::user()->role_id != 8)
                                                                <button type="button"
                                                                    class="btn btn-info btn-xs btn_width editbutton"
                                                                    data-toggle="modal" data-id="{{ $item->id }}">
                                                                    <i class="fa fa-edit"> Edit</i>
                                                                </button>
                                                                <a class="btn btn-info btn-xs btn_width delete_button delete_button_modal"
                                                                    data-toggle="modal" data-target="#modal-animation-1"
                                                                    title="Delete" href="#"
                                                                    data-href="{{ route('delete_doctor_appointment', $item->id) }}">
                                                                    <i class="fa fa-trash"> </i>
                                                                </a>
                                                            @endif
                                                            @if (Auth::user()->role_id == 8 || Auth::user()->role_id == 4)
                                                                <a class="btn btn-info btn-xs btn_width detailsbutton"
                                                                    title="Start Live" style="color: #fff;"
                                                                    href="{{ route('website_appointment_meeting') }}?id={{ $item->id }}"
                                                                    target="_blank"
                                                                    onclick="return confirm('Are you sure you want to start a live meeting with this patient? SMS and Email will be sent to the Patient.');">
                                                                    <i class="fa fa-headphones"></i>
                                                                    Live
                                                                </a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                                <style>
                                                    .img_url {
                                                        height: 20px;
                                                        width: 20px;
                                                        background-size: contain;
                                                        max-height: 20px;
                                                        border-radius: 100px;
                                                    }
                                                </style>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="treated" class="tab-pane">
                            <div class="">
                                <div class="panel-body">
                                    <div class="adv-table editable-table">
                                        <div class="space15"></div>
                                        <table class="table table-striped table-hover table-bordered"
                                            id="editable-sample3" style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th>Id</th>
                                                    <th>Patient</th>
                                                    <th>Doctor</th>
                                                    <th>Date - Time</th>
                                                    <th>Remarks</th>
                                                    <th>Status</th>
                                                    <th>Options</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($teatedDoctorAppoinment as $item)
                                                    <tr>
                                                        <td>{{ $item->id }}</td>
                                                        @if ($item->patient)
                                                            <td>{{ $item->patient->name }}</td>
                                                        @else
                                                            <td></td>
                                                        @endif
                                                        @if ($item->doctor)
                                                            <td>{{ $item->doctor->name }}</td>
                                                        @else
                                                            <td></td>
                                                        @endif
                                                        <td>{{ $item->appoinment_date }} | {{ $item->appoinment_time }}
                                                        </td>
                                                        <td> {{ $item->remarks }}</td>
                                                        <td> {{ $item->appoinment_status }}</td>
                                                        <td>
                                                            @if (Auth::user()->role_id != 8)
                                                                <button type="button"
                                                                    class="btn btn-info btn-xs btn_width editbutton"
                                                                    data-toggle="modal" data-id="{{ $item->id }}">
                                                                    <i class="fa fa-edit"> Edit</i>
                                                                </button>
                                                                <a class="btn btn-info btn-xs btn_width delete_button delete_button_modal"
                                                                    data-toggle="modal" data-target="#modal-animation-1"
                                                                    title="Delete" href="#"
                                                                    data-href="{{ route('delete_doctor_appointment', $item->id) }}">
                                                                    <i class="fa fa-trash"> </i>
                                                                </a>
                                                            @endif
                                                            @if (Auth::user()->role_id == 8 || Auth::user()->role_id == 4)
                                                                <a class="btn btn-info btn-xs btn_width detailsbutton"
                                                                    title="Start Live" style="color: #fff;"
                                                                    href="{{ route('website_appointment_meeting') }}?id={{ $item->id }}"
                                                                    target="_blank"
                                                                    onclick="return confirm('Are you sure you want to start a live meeting with this patient? SMS and Email will be sent to the Patient.');">
                                                                    <i class="fa fa-headphones"></i>
                                                                    Live
                                                                </a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                                <style>
                                                    .img_url {
                                                        height: 20px;
                                                        width: 20px;
                                                        background-size: contain;
                                                        max-height: 20px;
                                                        border-radius: 100px;
                                                    }
                                                </style>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="cancelled" class="tab-pane">
                            <div class="">
                                <div class="panel-body">
                                    <div class="adv-table editable-table">
                                        <div class="space15"></div>
                                        <table class="table table-striped table-hover table-bordered"
                                            id="editable-sample4" style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th>Id</th>
                                                    <th>Patient</th>
                                                    <th>Doctor</th>
                                                    <th>Date - Time</th>
                                                    <th>Remarks</th>
                                                    <th>Status</th>
                                                    <th>Options</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($CancelledDoctorAppoinment as $item)
                                                    <tr>
                                                        <td>{{ $item->id }}</td>
                                                        @if ($item->patient)
                                                            <td>{{ $item->patient->name }}</td>
                                                        @else
                                                            <td></td>
                                                        @endif
                                                        @if ($item->doctor)
                                                            <td>{{ $item->doctor->name }}</td>
                                                        @else
                                                            <td></td>
                                                        @endif
                                                        <td>{{ $item->appoinment_date }} | {{ $item->appoinment_time }}
                                                        </td>
                                                        <td> {{ $item->remarks }}</td>
                                                        <td> {{ $item->appoinment_status }}</td>
                                                        <td>
                                                            @if (Auth::user()->role_id != 8)
                                                                <button type="button"
                                                                    class="btn btn-info btn-xs btn_width editbutton"
                                                                    data-toggle="modal" data-id="{{ $item->id }}">
                                                                    <i class="fa fa-edit"> Edit</i>
                                                                </button>
                                                                <a class="btn btn-info btn-xs btn_width delete_button delete_button_modal"
                                                                    data-toggle="modal" data-target="#modal-animation-1"
                                                                    title="Delete" href="#"
                                                                    data-href="{{ route('delete_doctor_appointment', $item->id) }}">
                                                                    <i class="fa fa-trash"> </i>
                                                                </a>
                                                            @endif
                                                            @if (Auth::user()->role_id == 8 || Auth::user()->role_id == 4)
                                                                <a class="btn btn-info btn-xs btn_width detailsbutton"
                                                                    title="Start Live" style="color: #fff;"
                                                                    href="{{ route('website_appointment_meeting') }}?id={{ $item->id }}"
                                                                    target="_blank"
                                                                    onclick="return confirm('Are you sure you want to start a live meeting with this patient? SMS and Email will be sent to the Patient.');">
                                                                    <i class="fa fa-headphones"></i>
                                                                    Live
                                                                </a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                                <style>
                                                    .img_url {
                                                        height: 20px;
                                                        width: 20px;
                                                        background-size: contain;
                                                        max-height: 20px;
                                                        border-radius: 100px;
                                                    }
                                                </style>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div id="requested" class="tab-pane">
                            <div class="">
                                <div class="panel-body">
                                    <div class="adv-table editable-table">
                                        <div class="space15"></div>
                                        <table class="table table-striped table-hover table-bordered"
                                            id="editable-sample6" style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th>Id</th>
                                                    <th>Patient</th>
                                                    <th>Doctor</th>
                                                    <th>Date - Time</th>
                                                    <th>Remarks</th>
                                                    <th>Status</th>
                                                    <th>Options</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($RequestedDoctorAppoinment as $item)
                                                    <tr>
                                                        <td>{{ $item->id }}</td>
                                                        @if ($item->patient)
                                                            <td>{{ $item->patient->name }}</td>
                                                        @else
                                                            <td></td>
                                                        @endif
                                                        @if ($item->doctor)
                                                            <td>{{ $item->doctor->name }}</td>
                                                        @else
                                                            <td></td>
                                                        @endif
                                                        <td>{{ $item->appoinment_date }} | {{ $item->appoinment_time }}
                                                        </td>
                                                        <td> {{ $item->remarks }}</td>
                                                        <td> {{ $item->appoinment_status }}</td>
                                                        <td>
                                                            @if (Auth::user()->role_id != 8)
                                                                <button type="button"
                                                                    class="btn btn-info btn-xs btn_width editbutton"
                                                                    data-toggle="modal" data-id="{{ $item->id }}">
                                                                    <i class="fa fa-edit"> Edit</i>
                                                                </button>
                                                                <a class="btn btn-info btn-xs btn_width delete_button delete_button_modal"
                                                                    data-toggle="modal" data-target="#modal-animation-1"
                                                                    title="Delete" href="#"
                                                                    data-href="{{ route('delete_doctor_appointment', $item->id) }}">
                                                                    <i class="fa fa-trash"> </i>
                                                                </a>
                                                            @endif

                                                            @if (Auth::user()->role_id == 8 || Auth::user()->role_id == 4)
                                                                <a class="btn btn-info btn-xs btn_width detailsbutton"
                                                                    title="Start Live" style="color: #fff;"
                                                                    href="{{ route('website_appointment_meeting') }}?id={{ $item->id }}"
                                                                    target="_blank"
                                                                    onclick="return confirm('Are you sure you want to start a live meeting with this patient? SMS and Email will be sent to the Patient.');">
                                                                    <i class="fa fa-headphones"></i>
                                                                    Live
                                                                </a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                                <style>
                                                    .img_url {
                                                        height: 20px;
                                                        width: 20px;
                                                        background-size: contain;
                                                        max-height: 20px;
                                                        border-radius: 100px;
                                                    }
                                                </style>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>
    <!--main content end-->
    <!--footer start-->

    @include('hms.appointment_bottom')
@endsection
