@extends('layouts.website.website')
@section('content')
    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="col-md-5">
                <header class="panel-heading">
                    Add Case
                </header>

                <div class="">
                    <form role="form" action="{{ route('store_caseList') }}" class="clearfix" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Date</label>
                            <input type="date" class="form-control form-control-inline input-medium" name="date" id="exampleInputEmail1" value="{{ Carbon\Carbon::now()->toDateString() }}" placeholder="" required="" />
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Patient</label>
                            <select class="form-control m-bot15" id="patientchoose" name="patient_id" value="">
                                <option value="">choose</option>
                                @foreach (App\User::where('role_id',8)->orderBy('name','ASC')->get() as $item)
                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="exampleInputEmail1">Title</label>
                            <input type="text" class="form-control form-control-inline input-medium" name="title" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-12">
                            <label class="">Case</label>
                            <textarea class="form-control" name="description" value="" rows="70" cols="70"></textarea>
                        </div>
                        <input type="hidden" name="redirect" value="patient/caseList" />
                        <section class="col-md-12">
                            <button type="submit" name="submit" class="btn btn-info submit_button pull-right">Submit</button>
                        </section>
                    </form>
                </div>
            </section>

            <section class="col-md-7">
                <header class="panel-heading">
                    All Case
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th style="width: 10%;">Date</th>
                                    <th style="width: 15%;">Patient</th>
                                    <th style="width: 15%;">Case Title</th>
                                    <th style="width: 10%;" class="no-print">Options</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($PatientCase as $item)
                                    <tr role="row" class="odd">
                                        <td class="sorting_1 dtr-control">{{ Carbon\Carbon::parse($item->date)->format('d M Y h:i') }}</td>
                                        <td>
                                            {{ $item->patient->name }}
                                            <br/>
                                            {{ $item->patient->address }}
                                            <br />
                                            {{ $item->patient->phone }}
                                            <br />
                                        </td>
                                        <td>{{ $item->title }}</td>
                                        <td>
                                            <a type="button" class="btn btn-info btn-xs btn_width detailsbutton case" title="Case" data-toggle="modal" data-id="{{ $item->id }}"><i class="fa fa-file"> </i> </a>
                                            <a type="button" class="btn btn-info btn-xs btn_width editbutton" title="Edit" data-toggle="modal" data-id="{{ $item->id }}"><i class="fa fa-edit"> </i> </a>
                                            <a class="btn btn-info btn-xs btn_width delete_button delete_button_modal" data-toggle="modal" data-target="#modal-animation-1" title="Delete" href="#" data-href="{{ route('website_caseListDelete',$item->id) }}" >
                                                <i class="fa fa-trash"> </i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
        </section>
        <!-- page end-->
    </section>

    <!-- Add Department Modal-->
    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Add Medical History</h4>
                </div>
                <div class="modal-body row">
                    <form role="form" action="patient/addMedicalHistory" class="clearfix" method="post" enctype="multipart/form-data">
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Date</label>
                            <input type="text" class="form-control form-control-inline input-medium default-date-picker" name="date" id="exampleInputEmail1" value="" placeholder="" readonly="" />
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Patient</label>
                            <select class="form-control m-bot15 js-example-basic-single" name="patient_id" value="">
                                <option value="80"> pacient </option>
                                <option value="79"> Samba Fall </option>
                                <option value="78"> adfa </option>
                                <option value="77"> Alex Jones </option>
                                <option value="76"> Vinoth kumar </option>
                                <option value="75"> Niyamathullah </option>
                                <option value="74"> Niyamathullah </option>
                                <option value="73"> Habib </option>
                                <option value="72"> Rani </option>
                                <option value="71"> abhishk </option>
                                <option value="70"> g </option>
                                <option value="69"> Muted Faith </option>
                                <option value="68"> Muted Faith </option>
                                <option value="66"> indrasen </option>
                                <option value="65"> usmansiddique406@gmail.com </option>
                                <option value="64"> محمد السيد </option>
                                <option value="63"> name </option>
                                <option value="62"> Mr Patient </option>
                                <option value="61"> Amadou Diop </option>
                            </select>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="exampleInputEmail1">Title</label>
                            <input type="text" class="form-control form-control-inline input-medium" name="title" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-12">
                            <label class="">Description</label>
                            <textarea class="ckeditor form-control" name="description" value="" rows="10"></textarea>
                        </div>
                        <input type="hidden" name="id" value="" />
                        <input type="hidden" name="redirect" value="patient/caseList" />
                        <section class="col-md-12">
                            <button type="submit" name="submit" class="btn btn-info submit_button pull-right">Submit</button>
                        </section>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Add Department Modal-->

    <!-- Edit Department Modal-->
    <div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Edit Medical History</h4>
                </div>
                <div class="modal-body row">
                    <form role="form" id="medical_historyEditForm" class="clearfix" action="{{ route('update_caseList') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Date</label>
                            <input type="date" class="form-control form-control-inline input-medium" name="date" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Patient</label>
                            <select class="form-control m-bot15 patient" id="patientchoose1" name="patient_id" value="">
                                @foreach (App\User::where('role_id',8)->orderBy('name','ASC')->get() as $item)
                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="exampleInputEmail1">Title</label>
                            <input type="text" class="form-control form-control-inline input-medium" name="title" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-12">
                            <label class="">Description</label>
                            <div class="">
                                <textarea class="form-control editor" id="editor" name="description" value="" rows="10"></textarea>
                            </div>
                        </div>
                        <input type="hidden" name="id" value="" />
                        <input type="hidden" name="redirect" value="patient/caseList" />
                        <div class="col-md-12">
                            <button type="submit" name="submit" class="btn btn-info submit_button pull-right">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <div class="modal fade" id="caseModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close no-print" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Case Details</h4>
                </div>
                <div class="modal-body row">
                    <form role="form" id="medical_historyEditForm" class="clearfix" action="patient/addMedicalHistory" method="post" enctype="multipart/form-data">
                        <div class="form-group col-md-12 row">
                            <div class="form-group col-md-6 case_date_block">
                                <label for="exampleInputEmail1">Case Creation Date</label>
                                <div class="case_date"></div>
                            </div>
                            <div class="form-group col-md-6 case_patient_block">
                                <label for="exampleInputEmail1">Patient</label>
                                <div class="case_patient"></div>
                                <div class="case_patient_id"></div>
                            </div>
                            <div>
                                <hr />
                            </div>
                        </div>

                        <div class="form-group col-md-12">
                            <label for="exampleInputEmail1">Title </label>
                            <div class="case_title"></div>
                            <hr />
                        </div>
                        <div class="form-group col-md-12">
                            <label for="exampleInputEmail1"> Details</label>
                            <div class="case_details"></div>
                            <hr />
                        </div>

                        <div class="panel col-md-12">
                            <h5 class="pull-right">
                                Hospital<br />
                                Boropool, Rajbari-7700
                            </h5>
                        </div>

                        <div class="panel col-md-12 no-print">
                            <a class="btn btn-info invoice_button pull-right" onclick="javascript:window.print();"><i class="fa fa-print"></i> Print </a>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <style>
        @media print {
            .modal-content {
                width: 100%;
            }

            .modal {
                overflow: hidden;
            }

            .case_date_block {
                width: 50%;
                float: left;
            }

            .case_patient_block {
                width: 50%;
                float: left;
            }
        }
    </style>

<script type="text/javascript">
    $(".table").on("click", ".editbutton", function () {
        // Get the record's ID via attribute
        var iid = $(this).attr("data-id");

        $.ajax({
            url: "/patient/caseList/edit/" + iid,
            method: "GET",
            data: "",
            dataType: "json",
        }).success(function (response) {
            // Populate the form fields with the data returned from server
            var de = response.date * 1000;
            var d = new Date(de);
            var da = d.getDate() + "-" + (d.getMonth() + 1) + "-" + d.getFullYear();
            $("#medical_historyEditForm").find('[name="id"]').val(response.id).end();
            $("#medical_historyEditForm").find('[name="date"]').val(response.date).end();
            //   $('#medical_historyEditForm').find('[name="patient"]').val(response.medical_history.patient_id).end()
            $("#medical_historyEditForm").find('[name="title"]').val(response.title).end();
            $("#medical_historyEditForm").find('[name="description"]').val(response.case).end();
            $("#medical_historyEditForm").find('[name="patient_id"]').append(response.patient_id).trigger("change");
            //   $('.js-example-basic-single.patient').val(response.medical_history.patient_id).trigger('change');

            $("#myModal2").modal("show");
        });
    });
</script>

<script type="text/javascript">
    $(".table").on("click", ".case", function () {
        // Get the record's ID via attribute
        var iid = $(this).attr("data-id");

        $(".case_date").html("").end();
        $(".case_details").html("").end();
        $(".case_title").html("").end();
        $(".case_patient").html("").end();
        $(".case_patient_id").html("").end();
        $.ajax({
            url: "/patient/caseList/edit/" + iid,
            method: "GET",
            data: "",
            dataType: "json",
        }).success(function (response) {
            // Populate the form fields with the data returned from server
            var de = response.case.date * 1000;
            var d = new Date(de);

            var monthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

            var day = d.getDate();
            var monthIndex = d.getMonth();
            var year = d.getFullYear();

            var da = day + " " + monthNames[monthIndex] + ", " + year;

            $(".case_date").append(da).end();
            $(".case_patient").append(response.name).end();
            $(".case_patient_id")
                .append("ID: " + response.id)
                .end();
            $(".case_title").append(response.title).end();
            $(".case_details").append(response.case).end();

            $("#caseModal").modal("show");
        });
    });
</script>

<script>
    $(document).ready(function () {
        $("#patientchoose").select2({
            placeholder: "Search Patient Name / ID",
            allowClear: true,
            // ajax: {
            //     url: "patient/getPatientinfo",
            //     type: "post",
            //     dataType: "json",
            //     delay: 250,
            //     data: function (params) {
            //         return {
            //             searchTerm: params.term, // search term
            //         };
            //     },
            //     processResults: function (response) {
            //         return {
            //             results: response,
            //         };
            //     },
            //     cache: true,
            // },
        });
        $("#patientchoose1").select2({
            placeholder: "Search Patient Name / ID",
            allowClear: true,
            // ajax: {
            //     url: "patient/getPatientinfo",
            //     type: "post",
            //     dataType: "json",
            //     delay: 250,
            //     data: function (params) {
            //         return {
            //             searchTerm: params.term, // search term
            //         };
            //     },
            //     processResults: function (response) {
            //         return {
            //             results: response,
            //         };
            //     },
            //     cache: true,
            // },
        });
    });
</script>
<script>
    $(document).ready(function () {
        $(".flashmessage").delay(3000).fadeOut(100);
    });
</script>



@endsection
