@extends('layouts.website.website')
@section('content')

    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="panel">
                <header class="panel-heading">
                    List Of Departments
                    <div class="col-md-4 no-print pull-right">
                        <a data-toggle="modal" href="#myModal">
                            <div class="btn-group pull-right">
                                <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add New</button>
                            </div>
                        </a>
                    </div>
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <div class="space15"></div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Description</th>
                                    <th class="no-print">Options</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (App\Department::orderBy('name','ASC')->where('status',1)->get() as $item)
                                    <tr class="">
                                        <td>{{ $item->name }}</td>
                                        <td>
                                            {{ $item->description }}
                                        </td>
                                        <td class="no-print">
                                            <button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" title="Edit" data-id="{{ $item->id }}"><i class="fa fa-edit"></i></button>
                                            <a class="btn btn-info btn-xs btn_width delete_button_modal" data-toggle="modal" data-target="#modal-animation-1" title="Delete" href="#" data-href="{{ route('delete_department',$item->id) }}">
                                                <i class="fa fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>
    <!--main content end-->
    <!--footer start-->

    <!-- Add Department Modal-->
    <div class="modal fade" id="myModal" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Add Department</h4>
                </div>
                <div class="modal-body">
                    <form role="form" action="{{ route('store_department') }}" class="clearfix" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <label for="exampleInputEmail1"> Department Name</label>
                            <input type="text" class="form-control" name="name" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group">
                            <label class=""> Description</label>
                            <div class="">
                                <textarea class="form-control" name="description" value="" rows="30"> </textarea>
                            </div>
                        </div>
                        <input type="hidden" name="id" value="" />
                        <section class="">
                            <button type="submit" name="submit" class="btn btn-info submit_button pull-right">Submit</button>
                        </section>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Add Department Modal-->

    <!-- Edit Department Modal-->
    <div class="modal fade" id="myModal2" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Edit Department</h4>
                </div>
                <div class="modal-body">
                    <form role="form" id="departmentEditForm" class="clearfix" action="{{ route('update_department') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <label for="exampleInputEmail1"> Department Name</label>
                            <input type="text" class="form-control" name="name" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group">
                            <label class=""> Description</label>
                            <div class="">
                                <textarea class="form-control editor" id="editor" name="description" value="" rows="10"> </textarea>
                            </div>
                        </div>
                        <input type="hidden" name="id" value="" />
                        <input type="hidden" name="p_id" value="" />
                        <section class="">
                            <button type="submit" name="submit" class="btn btn-info submit_button pull-right">Submit</button>
                        </section>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    <script type="text/javascript">
        $(document).ready(function () {
            $(".editbutton").click(function (e) {
                e.preventDefault(e);
                // Get the record's ID via attribute
                var iid = $(this).attr('data-id');
                $.ajax({
                    url: '/department/edit/' + iid,
                    method: 'GET',
                    data: '',
                    dataType: 'json',
                }).success(function (response) {
                    // Populate the form fields with the data returned from server
                    console.log(response);
                    $('#departmentEditForm').find('[name="id"]').val(response.id).end()
                    $('#departmentEditForm').find('[name="name"]').val(response.name).end()
                    $('#departmentEditForm').find('[name="description"]').val(response.description).end()

                });
            });
        });
    </script>


@endsection

