@extends('layouts.website.website')
@section('content')

    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="panel">
                <header class="panel-heading">
                    Doctors
                    <div class="col-md-4 no-print pull-right">
                        <a data-toggle="modal" href="#myModal">
                            <div class="btn-group pull-right">
                                <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add New</button>
                            </div>
                        </a>
                    </div>
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <div class="space15"></div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th>Doctor Id</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Department</th>
                                    <th>Profile</th>
                                    <th class="no-print">Options</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (App\User::where('role_id',4)->orderBy('name','ASC')->get() as $item)
                                    <tr role="row" class="odd">
                                        <td class="sorting_1 dtr-control">{{ $item->id }}</td>
                                        <td>{{ $item->name }}</td>
                                        <td>{{ $item->email }}</td>
                                        <td>{{ $item->phone }}</td>
                                        @if ($item->department)
                                            <td>{{ $item->department->name }}</td>
                                        @else
                                            <td></td>
                                        @endif
                                        <td>{{ $item->doctor_profile }}</td>
                                        <td>
                                            <a type="button" class="btn btn-info btn-xs btn_width detailsbutton inffo" title="Info" data-toggle="modal" data-id="{{ $item->id }}">
                                                <i class="fa fa-info"> </i> Info
                                            </a>
                                            <a type="button" class="btn btn-info btn-xs btn_width editbutton" title="Edit" data-toggle="modal" data-id="{{ $item->id }}">
                                                <i class="fa fa-edit"> </i> Edit
                                            </a>
                                            <a class="btn btn-info btn-xs detailsbutton" title="Appointments" href="/appointment/getAppointmentByDoctorId/{{ $item->id }}">
                                                <i class="fa fa-calendar"> </i> Appointments
                                            </a>
                                            {{-- <a href="/schedule/holidays/{{ $item->id }}" class="btn btn-info btn-xs btn_width" data-toggle="modal" data-id="160">
                                                <i class="fa fa-book"></i> Holiday
                                            </a> --}}
                                            {{-- <a href="/schedule/timeSchedule/{{ $item->id }}" class="btn btn-info btn-xs btn_width" data-toggle="modal" data-id="160">
                                                <i class="fa fa-book"></i>
                                                Time Schedule
                                            </a> --}}
                                            <a class="btn btn-info btn-xs btn_width delete_button delete_button_modal" data-toggle="modal" data-target="#modal-animation-1" title="Delete" href="#" data-href="{{ route('delete_doctor',$item->id) }}" >
                                                <i class="fa fa-trash"> </i> Delete
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach


                                <style>
                                    .img_url {
                                        height: 20px;
                                        width: 20px;
                                        background-size: contain;
                                        max-height: 20px;
                                        border-radius: 100px;
                                    }
                                </style>
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>
    <!--main content end-->

    <!-- Add new doctor -->
    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Add New Doctor</h4>
                </div>
                <div class="modal-body row">
                    <form role="form" action="{{ route('store_doctor') }}" class="clearfix" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Name</label>
                            <input type="text" class="form-control" name="name" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Email</label>
                            <input type="text" class="form-control" name="email" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Password</label>
                            <input type="password" class="form-control" name="password" id="exampleInputEmail1" placeholder="********" />
                        </div>

                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Address</label>
                            <input type="text" class="form-control" name="address" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Phone</label>
                            <input type="text" class="form-control" name="phone" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Department</label>
                            <select class="form-control m-bot15 js-example-basic-single" name="department" value="">
                                @foreach (App\Department::orderBy('name','ASC')->get() as $item)
                                    <option value="{{ $item->id }}"> {{ $item->name }} </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Profile</label>
                            <input type="text" class="form-control" name="profile" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group last col-md-6">
                            <label class="control-label">Image Upload</label>
                            <div class="">
                                <div class="fileupload fileupload-new" data-provides="fileupload">
                                    <div class="fileupload-new thumbnail" style="width: 200px; height: 150px;">
                                        <img src="//www.placehold.it/200x150/EFEFEF/AAAAAA&amp;text=no+image" alt="" />
                                    </div>
                                    <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 20px;"></div>
                                    <div>
                                        <span class="btn btn-white btn-file">
                                            <span class="fileupload-new"><i class="fa fa-paper-clip"></i> Select image</span>
                                            <span class="fileupload-exists"><i class="fa fa-undo"></i> Change</span>
                                            <input type="file" class="default" name="img_url" />
                                        </span>
                                        <a href="#" class="btn btn-danger fileupload-exists" data-dismiss="fileupload"><i class="fa fa-trash"></i> Remove</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group col-md-12">
                            <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Add Accountant Modal-->

    <!-- Edit Event Modal-->
    <div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Edit Doctor</h4>
                </div>
                <div class="modal-body">
                    <form role="form" id="editDoctorForm" class="clearfix" action="{{ route('update_doctor') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Name</label>
                            <input type="text" class="form-control" name="name" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Email</label>
                            <input type="text" class="form-control" name="email" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Password</label>
                            <input type="password" class="form-control" name="password" id="exampleInputEmail1" placeholder="********" />
                        </div>

                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Address</label>
                            <input type="text" class="form-control" name="address" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Phone</label>
                            <input type="text" class="form-control" name="phone" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Department</label>
                            <select class="form-control m-bot15 js-example-basic-single department" name="department" value="">
                                @foreach (App\Department::orderBy('name','ASC')->get() as $item)
                                    <option value="{{ $item->id }}"> {{ $item->name }} </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Profile</label>
                            <input type="text" class="form-control" name="profile" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group last col-md-6">
                            <label class="control-label">Image Upload</label>
                            <div class="">
                                <div class="fileupload fileupload-new" data-provides="fileupload">
                                    <div class="fileupload-new thumbnail" style="width: 200px; height: 150px;">
                                        <img src="//www.placehold.it/200x150/EFEFEF/AAAAAA&amp;text=no+image" id="img" alt="" />
                                    </div>
                                    <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 20px;"></div>
                                    <div>
                                        <span class="btn btn-white btn-file">
                                            <span class="fileupload-new"><i class="fa fa-paper-clip"></i> Select image</span>
                                            <span class="fileupload-exists"><i class="fa fa-undo"></i> Change</span>
                                            <input type="file" class="default" name="img_url" />
                                        </span>
                                        <a href="#" class="btn btn-danger fileupload-exists" data-dismiss="fileupload"><i class="fa fa-trash"></i> Remove</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <input type="hidden" name="id" value="" />
                        <div class="form-group col-md-12">
                            <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Edit Event Modal-->

    <div class="modal fade" id="infoModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Doctor Info</h4>
                </div>
                <div class="modal-body">
                    <form role="form" id="editDoctorForm" class="clearfix" action="doctor/addNew" method="post" enctype="multipart/form-data">
                        <div class="form-group last col-md-6">
                            <div class="">
                                <div class="fileupload fileupload-new" data-provides="fileupload">
                                    <div class="fileupload-new thumbnail" style="width: 200px; height: 150px;">
                                        <img src="//www.placehold.it/200x150/EFEFEF/AAAAAA&amp;text=no+image" id="img1" alt="" />
                                    </div>
                                    <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 20px;"></div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Name</label>
                            <div class="nameClass"></div>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Email</label>
                            <div class="emailClass"></div>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Address</label>
                            <div class="addressClass"></div>
                        </div>

                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Phone</label>
                            <div class="phoneClass"></div>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Department</label>
                            <div class="departmentClass"></div>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Profile</label>
                            <div class="profileClass"></div>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <script type="text/javascript">
        $(document).ready(function () {
            $(".table").on("click", ".editbutton", function () {
                // Get the record's ID via attribute
                var iid = $(this).attr('data-id');
                $("#img").attr("src", "/avatar.png");
                $('#editDoctorForm').trigger("reset");
                $.ajax({
                    url: '/doctor/edit/' + iid,
                    method: 'GET',
                    data: '',
                    dataType: 'json',
                }).success(function (response) {
                    // console.log(response);
                    // Populate the form fields with the data returned from server
                    $('#editDoctorForm').find('[name="id"]').val(response.id).end()
                    $('#editDoctorForm').find('[name="name"]').val(response.name).end()
                    $('#editDoctorForm').find('[name="password"]').val(response.password).end()
                    $('#editDoctorForm').find('[name="email"]').val(response.email).end()
                    $('#editDoctorForm').find('[name="address"]').val(response.address).end()
                    $('#editDoctorForm').find('[name="phone"]').val(response.phone).end()
                    $('#editDoctorForm').find('[name="department"]').val(response.doctor_department).end()
                    $('#editDoctorForm').find('[name="profile"]').val(response.doctor_profile).end()

                    if (typeof response.photo !== 'undefined' && response.photo != '') {
                        $("#img").attr("src", '/'+response.photo);
                    }

                    $('.js-example-basic-single.department').val(response.doctor_department).trigger('change');

                    $('#myModal2').modal('show');

                });
            });
        });
    </script>

    <script type="text/javascript">
        $(document).ready(function () {
            $(".table").on("click", ".inffo", function () {
                // Get the record's ID via attribute
                var iid = $(this).attr('data-id');

                $("#img1").attr("src", "/avatar.png");
                $('.nameClass').html("").end()
                $('.emailClass').html("").end()
                $('.addressClass').html("").end()
                $('.phoneClass').html("").end()
                $('.departmentClass').html("").end()
                $('.profileClass').html("").end()
                $.ajax({
                    url: '/doctor/edit/' + iid,
                    method: 'GET',
                    data: '',
                    dataType: 'json',
                }).success(function (response) {

                    // Populate the form fields with the data returned from server
                    $('#editDoctorForm').find('[name="id"]').val(response.id).end()
                    $('.nameClass').append(response.name).end()
                    $('.emailClass').append(response.email).end()
                    $('.addressClass').append(response.address).end()
                    $('.phoneClass').append(response.phone).end()
                    $('.departmentClass').append(response.department).end()
                    $('.profileClass').append(response.profile).end()

                    if (typeof response.photo !== 'undefined' && response.photo != '') {
                        $("#img1").attr("src", '/'+response.photo);
                    }

                    $('#infoModal').modal('show');

                });
            });
        });
    </script>

@endsection
