@extends('layouts.website.website')
@section('content')
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="panel">
                <header class="panel-heading">
                    Patient Documents
                    <div class="col-md-4 no-print pull-right">
                        @if (Auth::User()->role_id <= 2 || Auth::User()->role_id == 9)
                            <a data-toggle="modal" href="#myModal1">
                                <div class="btn-group pull-right">
                                    <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add New</button>
                                </div>
                            </a>
                        @endif
                    </div>
                </header>
                <div class="">
                    <div class="">
                        <div class="adv-table editable-table panel-body">
                            <table class="table table-striped table-hover table-bordered" id="editable-sample">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Patient</th>
                                        <th>Description</th>
                                        <th style="width: 20%;">Document</th>
                                        <th class="no-print">Options</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($PatientDocument as $item)
                                        <tr role="row" class="odd">
                                            <td class="sorting_1 dtr-control">{{ Carbon\Carbon::parse($item->date)->format('d,M Y h:i') }}</td>
                                            <td>
                                                @if ($item->patient)
                                                    {{ $item->patient->name }}
                                                    <br />
                                                    {{ $item->patient->address }}
                                                    <br />
                                                    {{ $item->patient->phone }}
                                                    <br />
                                                @endif
                                            </td>
                                            <td>{{ $item->title }}</td>
                                            <td>
                                                <a class="example-image-link" href="{{ asset(''.$item->img_url) }}" data-lightbox="example-1" data-title="Radio Oct 2020">
                                                    <img class="example-image" src="{{ asset(''.$item->img_url) }}" width="100px" height="100px" alt="image-1" />
                                                </a>
                                            </td>
                                            <td>
                                                <a class="btn btn-info btn-xs" href="{{ asset(''.$item->img_url) }}" download=""> Download </a>
                                                <a class="btn btn-info btn-xs delete_button" href="{{ route('website_documentDelete',$item->id) }}" onclick="return confirm('You want to delete the item??');"> X </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>
    <!--main content end-->
    <!--footer start-->

    @if (Auth::User()->role_id <= 2 || Auth::User()->role_id == 9)
        <!-- Add Patient Material Modal-->
        <div class="modal fade" id="myModal1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">

            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        <h4 class="modal-title">Add Files</h4>
                    </div>
                    <div class="modal-body">
                        <form role="form" action="{{ route('store_document') }}" class="clearfix" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                                <label for="exampleInputEmail1">Patient</label>
                                <select class="form-control m-bot15" id="patientchoose" name="patient_id" value="">
                                    <option value="">Choose Patient</option>
                                    @foreach (App\User::where('role_id',8)->orderBy('name','ASC')->get() as $item)
                                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="exampleInputEmail1"> Title</label>
                                <input type="text" class="form-control" name="title" id="exampleInputEmail1" placeholder="" />
                            </div>
                            <div class="form-group">
                                <label for="exampleInputEmail1"> File</label>
                                <input type="file" name="img_url" />
                                <span class="help-block">Recommended Size : 3000 x 2024</span>
                            </div>
                            <input type="hidden" name="redirect" value="patient/documents" />
                            <div class="form-group">
                                <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>

        <!-- Add Patient Modal-->
        <script>
            $(document).ready(function () {
                $("#patientchoose").select2({
                    placeholder: 'Search Patient Name / ID',
                    allowClear: true,
                    // ajax: {
                    //     url: 'patient/getPatientinfo',
                    //     type: "post",
                    //     dataType: 'json',
                    //     delay: 250,
                    //     data: function (params) {
                    //         return {
                    //             searchTerm: params.term // search term
                    //         };
                    //     },
                    //     processResults: function (response) {
                    //         return {
                    //             results: response
                    //         };
                    //     },
                    //     cache: true
                    // }

                });
            });
        </script>
    @endif
@endsection
