@extends('layouts.website.website')
@section('content')
    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="panel">
                <header class="panel-heading">
                    Donor
                    <div class="col-md-4 no-print pull-right">
                        <a data-toggle="modal" href="#myModal">
                            <div class="btn-group pull-right">
                                <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add Donor</button>
                            </div>
                        </a>
                    </div>
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <div class="space15"></div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Blood Group</th>
                                    <th>Age</th>
                                    <th>Sex</th>
                                    <th>Last Donation Date</th>
                                    <th>Phone</th>
                                    <th>Email</th>
                                    <th class="no-print">Options</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (App\BloodDonor::latest()->get() as $item)
                                    <tr>
                                        <td>{{ $item->name }}</td>
                                        <td>{{ $item->blood_group }}</td>
                                        <td>{{ $item->age }}</td>
                                        <td>{{ $item->sex}}</td>
                                        <td>{{ Carbon\Carbon::parse($item->date)->format('d,M Y')}}</td>
                                        <td>{{ $item->phone}}</td>

                                        <td>{{ $item->email}}</td>
                                        <td class="no-print">
                                            <button type="button" class="btn btn-info btn-xs btn_width editbutton" title="Edit" data-toggle="modal" data-id="{{ $item->id }}">
                                                <i class="fa fa-edit"> </i></button>
                                            <a class="btn btn-info btn-xs btn_width delete_button" title="Delete" href="{{ route('delete_donor',$item->id) }}" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"> </i></a>
                                        </td>
                                        
                                    </tr>
                                @endforeach
                                <style>
                                    .img_url {
                                        height: 20px;
                                        width: 20px;
                                        background-size: contain;
                                        max-height: 20px;
                                        border-radius: 100px;
                                    }
                                </style>
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>
    <!--main content end-->
    <!--footer start-->

    <!-- Add Accountant Modal-->
    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Add Donor</h4>
                </div>
                <div class="modal-body row">
                    <form role="form" action="{{ route('store_donor') }}" class="clearfix" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group col-md-5">
                            <label for="exampleInputEmail1">Name</label>
                            <input type="text" class="form-control" name="name" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-4">
                            <label for="exampleInputEmail1">Blood Group</label>
                            <select class="form-control m-bot15" name="group" value="">
                                <option value="A+"> A+ </option>
                                <option value="A-"> A- </option>
                                <option value="B+"> B+ </option>
                                <option value="B-"> B- </option>
                                <option value="AB+"> AB+ </option>
                                <option value="AB-"> AB- </option>
                                <option value="O+"> O+ </option>
                                <option value="O-"> O- </option>
                            </select>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="exampleInputEmail1">Age</label>
                            <input type="text" class="form-control" name="age" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-5">
                            <label for="exampleInputEmail1">Last Donation Date</label>
                            <input class="form-control form-control-inline input-medium" type="date" name="ldd" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-4">
                            <label for="exampleInputEmail1">Phone</label>
                            <input type="text" class="form-control" name="phone" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-3">
                            <label for="exampleInputEmail1">Sex</label>
                            <select class="form-control m-bot15" name="sex" value="">
                                <option value="Male"> Male </option>
                                <option value="Female"> Female </option>
                                <option value="Others"> Others </option>
                            </select>
                        </div>

                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Email</label>
                            <input type="text" class="form-control" name="email" id="exampleInputEmail1" value="" placeholder="" />
                        </div>

                        <div class="form-group col-md-12">
                            <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Add Accountant Modal-->

    <!-- Edit Event Modal-->
    <div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Edit Donor</h4>
                </div>
                <div class="modal-body row">
                    <form role="form" id="editDonorForm" class="clearfix" action="{{ route('update_donor') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group col-md-5">
                            <label for="exampleInputEmail1">Name</label>
                            <input type="text" class="form-control" name="name" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-4">
                            <label for="exampleInputEmail1">Blood Group</label>
                            <select class="form-control m-bot15" name="group" value="">
                                <option value="A+"> A+ </option>
                                <option value="A-"> A- </option>
                                <option value="B+"> B+ </option>
                                <option value="B-"> B- </option>
                                <option value="AB+"> AB+ </option>
                                <option value="AB-"> AB- </option>
                                <option value="O+"> O+ </option>
                                <option value="O-"> O- </option>
                            </select>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="exampleInputEmail1">Age</label>
                            <input type="text" class="form-control" name="age" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-5">
                            <label for="exampleInputEmail1">Last Donation Date</label>
                            <input class="form-control form-control-inline input-medium" type="date" name="ldd" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-4">
                            <label for="exampleInputEmail1">Phone</label>
                            <input type="text" class="form-control" name="phone" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group col-md-3">
                            <label for="exampleInputEmail1">Sex</label>
                            <select class="form-control m-bot15" name="sex" value="">
                                <option value="Male"> Male </option>
                                <option value="Female"> Female </option>
                                <option value="Others"> Others </option>
                            </select>
                        </div>

                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Email</label>
                            <input type="text" class="form-control" name="email" id="exampleInputEmail1" value="" placeholder="" />
                        </div>

                        <input type="hidden" name="id" value="" />

                        <div class="form-group col-md-12">
                            <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Edit Event Modal-->

    <script type="text/javascript">
        $(document).ready(function () {
            $(".editbutton").click(function (e) {
                e.preventDefault(e);
                // Get the record's ID via attribute
                var iid = $(this).attr("data-id");
                $("#editDonorForm").trigger("reset");
                $("#myModal2").modal("show");
                $.ajax({
                    url: "/donor/edit/" + iid,
                    method: "GET",
                    data: "",
                    dataType: "json",
                }).success(function (response) {
                    // Populate the form fields with the data returned from server
                    $("#editDonorForm").find('[name="id"]').val(response.id).end();
                    $("#editDonorForm").find('[name="name"]').val(response.name).end();
                    $("#editDonorForm").find('[name="group"]').val(response.blood_group).end();
                    $("#editDonorForm").find('[name="age"]').val(response.age).end();
                    $("#editDonorForm").find('[name="sex"]').val(response.sex).end();
                    $("#editDonorForm").find('[name="ldd"]').val(response.last_donation_date).end();
                    $("#editDonorForm").find('[name="phone"]').val(response.phone).end();
                    $("#editDonorForm").find('[name="email"]').val(response.email).end();
                });
            });
        });
    </script>


@endsection
