@extends('layouts.website.website')
@section('content')
    <!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
                Expense categories
                <div class="col-md-4 no-print pull-right">
                    <a href="{{ route('website_expenseCategoryAdd') }}">
                        <div class="btn-group pull-right">
                            <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add Expense Category</button>
                        </div>
                    </a>
                </div>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table">
                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th>Category</th>
                                <th>Description</th>
                                <th>Option</th>
                            </tr>
                        </thead>
                        <tbody>
                            <style>
                                .img_url {
                                    height: 20px;
                                    width: 20px;
                                    background-size: contain;
                                    max-height: 20px;
                                    border-radius: 100px;
                                }
                            </style>
                            @foreach (App\ExpenseCategory::latest()->get() as $item)
                                <tr class="">
                                    <td>{{ $item->name }}</td>
                                    <td>{{ $item->description }}</td>
                                    <td>
                                        <a class="btn btn-info btn-xs editbutton" title="Edit" href="{{ route('website_expenseCategoryEdit',$item->id) }}"><i class="fa fa-edit"> </i></a>
                                        <a class="btn btn-info btn-xs delete_button" title="Delete" href="{{ route('website_expenseCategoryDelete',$item->id) }}" onclick="return confirm('Are you sure you want to delete this item?');">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->

@endsection
