@extends('layouts.website.website')
@section('content')
<section id="main-content">
    <section class="wrapper site-min-height">
        <!--state overview start-->
        <div class="col-md-12">
            <div class="row state-overview" style="padding: 23px 0px;">
                <div class="col-md-8">
                    <!--custom chart start-->

                    <div class="panel-heading">
                        {{ Carbon\Carbon::now()->month }}, {{ Carbon\Carbon::now()->year }} Pharmacy Expense Report

                        <div class="col-md-1 pull-right no-print">
                            <a class="no-print pull-right" onclick="javascript:window.print();"> <i class="fa fa-print"></i> </a>
                        </div>
                        <div class="col-md-1 pull-right no-print">
                            <a href="#">
                                <i class="fa fa-arrow-right"></i>
                            </a>
                        </div>
                        <div class="col-md-1 pull-right no-print">
                            <a href="#">
                                <i class="fa fa-arrow-left"></i>
                            </a>
                        </div>
                    </div>

                    <div id="chart_div"></div>

                    <div class="panel-body">
                        <div class="adv-table editable-table">
                            <div class="space15"></div>
                            <table class="table table-striped table-hover table-bordered" id="editable-sample1">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Amount</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach (App\Expense::where('status',1)->latest()->get() as $item)

                                        <tr>
                                            <td>{{ $item->created_at->format('D d-m-Y') }}</td>
                                            <td>$ {{ number_format($item->amount) }}</td>
                                        </tr>

                                    @endforeach


                                    <tr style="color: #000 !important; font-weight: bold;">
                                        <td>Total</td>
                                        <td>$ {{ number_format(App\Expense::where('status',1)->latest()->sum('amount')) }}</td>
                                    </tr>

                                    <style>
                                        .img_url {
                                            height: 20px;
                                            width: 20px;
                                            background-size: contain;
                                            max-height: 20px;
                                            border-radius: 100px;
                                        }
                                    </style>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--state overview end-->
    </section>
</section>
@endsection
