@extends('layouts.website.website')
@section('content')

    <!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <header class="panel-heading">
            Pharmacy Report
        </header>
        <div class="col-md-12">
            <div class="col-md-7">
                <section>
                    <form role="form" class="f_report" action="finance/pharmacy/financialReport" method="post" enctype="multipart/form-data" style="padding:15px;">
                        <label class="range">Date Range</label>
                        <div class="form-group" style="overflow: hidden;">
                            <div class="col-md-6">
                                <div class="input-group input-large" data-date="13/07/2013" data-date-format="mm/dd/yyyy">
                                    <input type="text" class="form-control dpd1" name="date_from" value="" placeholder=" Date From " />
                                    <span class="input-group-addon"> to </span>
                                    <input type="text" class="form-control dpd2" name="date_to" value="" placeholder=" Date To " />
                                </div>
                                <div class="row"></div>
                                <span class="help-block"></span>
                            </div>
                            <div class="col-md-6">
                                <button type="submit" name="submit" class="btn btn-info range_submit">Submit</button>
                            </div>
                        </div>
                        <section class="">
                            <div class="col-md-3 panel-body">
                                <label class="">Date From</label>
                                <div class="paanel"></div>
                            </div>
                            <div class="col-md-3 panel-body">
                                <label class="">Date To</label>
                                <div class="paanel"></div>
                            </div>
                        </section>
                    </form>
                </section>

            </div>
            <div class="col-md-5"></div>
        </div>

        <div class="row">
            <div class="col-lg-7">
                <section class="panel">
                    <header class="panel-heading"><i class="fa fa-money"></i> Sales Report</header>
                    <table class="table table-striped table-advance table-hover">
                        <thead>
                            <tr>
                                <th>Item Name</th>
                                <th>Quantity</th>
                                <th>Total Purchase Cost</th>
                                <th class="hidden-phone">Total Sale Cost</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                        <tbody>
                            @php
                                $purchase_price = 0 ;
                                $total_price = 0 ;
                            @endphp

                            @foreach (App\MadicineSaleDetails::latest()->get()->unique('madicine_id') as $item)
                                @php
                                    $purchase_price += $item->madicine_details->price;
                                    $total_price += App\MadicineSaleDetails::where('madicine_id',$item->madicine_id)->sum('madicine_qty') * App\MadicneList::where('id',$item->madicine_id)->sum('saleprice');
                                @endphp
                                <tr>
                                    <td>{{ $item->madicine_details->name }}</td>
                                    <td>{{ App\MadicineSaleDetails::where('madicine_id',$item->madicine_id)->sum('madicine_qty') }}</td>
                                    <td style="text-align: right">$ {{ $item->madicine_details->price }}</td>
                                    {{-- <td>{{ App\MadicineSale::sum('discount') }}</td> --}}
                                    <td style="text-align: right">$ {{ (float) ( App\MadicineSaleDetails::where('madicine_id',$item->madicine_id)->sum('madicine_qty') * App\MadicneList::where('id',$item->madicine_id)->sum('saleprice') ) - App\MadicineSale::where('id',$item->madicine_id)->sum('discount') }}</td>
                                    <td></td>
                                </tr>
                            @endforeach

                            <tr>
                                <td><h3>Sub Total</h3></td>
                                <td></td>
                                <td  style="text-align: right">
                                    $ {{ $purchase_price }}
                                </td>
                                <td style="text-align: right">
                                    $ {{ $total_price - App\MadicineSale::sum('discount') }}
                                </td>
                            </tr>

                            <tr>
                                <td><h5>Total Discount</h5></td>
                                <td></td>
                                <td></td>
                                <td  style="text-align: right">
                                    $ {{ App\MadicineSale::sum('discount') }}
                                </td>
                            </tr>
                            <!--
                            <tr>
                                <td><h5> Total   Vat </h5></td>
                                <td></td>
                                <td></td>
                                <td>
                            ₹                            0                                </td>
                            </tr>
                            -->
                            <tr>
                                <td><h5>Sales</h5></td>
                                <td></td>
                                <td></td>
                                <td  style="text-align: right">
                                    $ {{ App\MadicineSale::sum('grand_total') }}
                                </td>
                            </tr>
                            <!--
                            <tr>
                                <td><h5> Due Amount  </h5></td>
                                <td></td>
                                <td></td>
                                <td>
                            ₹                            0                                </td>
                            </tr>
                            -->
                        </tbody>
                    </table>
                </section>
                <section></section>
                <section class="panel">
                    <header class="panel-heading"><i class="fa fa-money"></i> Expense Report</header>
                    <table class="table table-striped table-advance table-hover">
                        <thead>
                            <tr>
                                <th>Category</th>
                                <th class="hidden-phone">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach (App\Expense::where('status',1)->latest()->get() as $item)
                                <tr class="">
                                    <td>{{ $item->categoryDetails->name }}</td>
                                    <td>
                                        $ {{ $item->amount }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </section>
            </div>

            <div class="col-lg-5">
                <section class="panel">
                    <div class="weather-bg">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-xs-4">
                                    <i class="fa fa-money"></i>
                                    Purchase Price
                                </div>
                                <div class="col-xs-8">
                                    <div class="degree">
                                        $ {{ number_format(App\MadicneList::where('status',1)->sum('price')) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="panel">
                    <div class="weather-bg">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-xs-4">
                                    <i class="fa fa-money"></i>
                                    Sale Price
                                </div>
                                <div class="col-xs-8">
                                    <div class="degree">
                                        $ {{ number_format( $total_price - App\MadicineSale::sum('discount') ) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="panel">
                    <div class="weather-bg">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-xs-4">
                                    <i class="fa fa-money"></i>
                                    Gross Expense
                                </div>
                                <div class="col-xs-8">
                                    <div class="degree">
                                        $ {{ number_format(App\Expense::where('status',1)->sum('amount')) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="panel">
                    <div class="weather-bg">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-xs-4">
                                    <i class="fa fa-money"></i>
                                    Profit
                                </div>
                                <div class="col-xs-8">
                                    <div class="degree">
                                        $ {{ number_format(App\MadicineSale::sum('grand_total')) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
        <!-- page end-->
    </section>
</section>
<!--main content end-->


@endsection
