@extends('layouts.website.website')
@section('content')

    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- invoice start-->
            <section>
                <div class="panel panel-primary">
                    <!--<div class="panel-heading navyblue"> INVOICE</div>-->
                    <div class="panel-body col-md-5 panel-moree" id="invoice" style="font-size: 10px;">
                        <div class="row invoice-list">
                            <div class="text-center corporate-id">
                                <h1>
                                    Hospital
                                </h1>
                                <h4>
                                    179 Abohanifa,st 10th of ramadan city
                                </h4>
                                <h4>
                                    Tel: 01018183624
                                </h4>
                            </div>

                            <div class="col-lg-4 col-sm-4">
                                <h4>Payment To :</h4>
                                <p>
                                    Hospital <br />
                                    179 Abohanifa,st 10th of ramadan city<br />
                                    Tel: 01018183624
                                </p>
                            </div>
                            <div class="col-lg-4 col-sm-4">
                                <h4>INVOICE INFO</h4>
                                <ul class="unstyled">
                                    <li>Invoice No. : <strong>{{ $MadicineSale->invoice_id }}</strong></li>
                                    <!--
                                    <li> Status 		:
                                    <strong>Unpaid</strong>
                                    </li>
                                    -->
                                </ul>
                            </div>

                            <div class="col-lg-4 col-sm-4">
                                <h4>Date</h4>
                                <ul class="unstyled">
                                    <li>{{ $MadicineSale->created_at->format('d/m/Y') }}</li>
                                </ul>
                            </div>
                        </div>

                        <table class="table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Company</th>
                                    <th>Unit Price</th>
                                    <th>Quantity</th>
                                    <th>Total Per Item</th>
                                </tr>
                            </thead>

                            <tbody>
                                @php $i=0; @endphp
                                @foreach ($MadicineSaleDetails as $item)
                                    <tr>
                                        <td>{{ $i++ }}</td>
                                        @if ($item->madicine_details)
                                            <td>{{ $item->madicine_details->name }}</td>
                                            <td class="">{{ $item->madicine_details->company }}</td>
                                            <td class="">$ {{ $item->madicine_details->saleprice }}</td>
                                            <td class="">{{ $item->madicine_qty }}</td>
                                            <td class="">$ {{ $item->madicine_qty * $item->madicine_qty }}</td>
                                        @else
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        @endif
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div class="row">
                            <div class="col-lg-6 invoice-block pull-right">
                                <ul class="unstyled amounts">
                                    <li><strong> Sub Total Amount : </strong>$ {{ $MadicineSale->sub_total }}</li>
                                    <li><strong> Grand Total : </strong>$ {{ $MadicineSale->grand_total }}</li>
                                    <!--
                                    <li><strong> Amount Received  : </strong>₹ </li>
                                    <li><strong> Amount To Be Paid  : </strong>₹ 400</li>
                                    -->
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-5 panel-moree" style="font-size: 10px;">
                        <div class="text-center invoice-btn clearfix">
                            <a class="btn btn-info btn-lg editbutton pull-left" onclick="javascript:window.print();"><i class="fa fa-print"></i> Print </a>
                        </div>

                        {{-- <div class="text-center invoice-btn clearfix">
                            <a class="btn btn-info btn-sm detailsbutton pull-left download" id="download"><i class="fa fa-download"></i> Download </a>
                        </div> --}}

                        <div class="text-center invoice-btn clearfix">
                            <a href="{{ route('website_farmacy_addPaymentViewEdit',$MadicineSale->id ) }}" class="btn btn-info btn-lg green pull-left"><i class="fa fa-edit"></i> Edit Invoice </a>
                        </div>
                        {{-- <div class="text-center invoice-btn no-print pull-left">
                            <a href="finance/pharmacy/previousInvoice?id=1986" class="btn btn-info btn-lg green previousone1"><i class="glyphicon glyphicon-chevron-left"></i> </a>
                            <a href="finance/pharmacy/nextInvoice?id=1986" class="btn btn-info btn-lg green nextone1"><i class="glyphicon glyphicon-chevron-right"></i> </a>
                        </div> --}}
                    </div>

                    <!--
                    <div class="panel-body col-md-6 add_deposit" style="font-size: 10px; float: right;">

                        <form role="form" action="finance/pharmacy/amountReceived" method="post" enctype="multipart/form-data">
                            <div class="form-group">
                                <label for="exampleInputEmail1"></label>
                    Amount To Be Paid : ₹  400
                            </div>
                            <div class="form-group">
                                <label for="exampleInputEmail1"> Add Deposit </label>
                                <input type="text" class="form-control" name="amount_received" id="exampleInputEmail1" value='' placeholder="₹ ">
                            </div>
                            <input type="hidden" name="id" value="1986">

                            <button type="submit" name="submit" class="btn btn-info">Submit</button>
                        </form>
                    </div>


                    -->
                </div>
            </section>
            <!-- invoice end-->
        </section>
    </section>
    <!--main content end-->

@endsection
