@extends('layouts.website.website')
@section('content')
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <header class="panel-heading">
            Financial report
            <div class="col-md-1 pull-right">
                <button class="btn btn-info green no-print pull-right" onclick="javascript:window.print();">Print</button>
            </div>
        </header>
        <div class="col-md-12">
            <div class="col-md-7 row">
                <section>
                    <form role="form" class="f_report" action="finance/financialReport" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <!--     <label class="control-label col-md-3">Date Range</label> -->
                            <div class="col-md-6">
                                <div class="input-group input-large" data-date="13/07/2013" data-date-format="mm/dd/yyyy">
                                    <input type="text" class="form-control dpd1" name="date_from" value="" placeholder="Date From" readonly="" />
                                    <span class="input-group-addon">to</span>
                                    <input type="text" class="form-control dpd2" name="date_to" value="" placeholder="Date To" readonly="" />
                                </div>
                                <div class="row"></div>
                                <span class="help-block"></span>
                            </div>
                            <div class="col-md-6 no-print">
                                <button type="submit" name="submit" class="btn btn-info range_submit">Submit</button>
                            </div>
                        </div>
                    </form>
                </section>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-7">
                <section class="panel">
                    <header class="panel-heading">
                        Income
                    </header>
                    <table class="table table-striped table-advance table-hover">
                        <thead>
                            <tr>
                                <th>Category</th>
                                <th>Quantity</th>
                                <th class="hidden-phone">Amount</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                        <tbody>
                            <tr>
                                <td><h3>Sub Total</h3></td>
                                <td></td>
                                <td>
                                    $ {{ App\FinancePayment::sum('subtotal') }}
                                </td>
                            </tr>

                            <tr>
                                <td><h5>Total Discount</h5></td>
                                <td></td>
                                <td>
                                    $ {{ App\FinancePayment::sum('discount') }}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <h5><i class="fa fa-money-bill-alt"></i> Gross Income</h5>
                                </td>
                                <td></td>
                                <td>
                                    $ {{ App\FinancePayment::sum('gross_total') }}
                                </td>
                            </tr>
                            <tr>
                                <td><h5>Total Hospital Amount</h5></td>
                                <td></td>
                                <td>
                                    $ 0
                                </td>
                            </tr>
                            <tr>
                                <td><h5>Total Doctors Amount</h5></td>
                                <td></td>
                                <td>
                                    $ 0
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </section>

                <section></section>

                <section class="panel">
                    <header class="panel-heading">
                        Expense
                    </header>
                    <table class="table table-striped table-advance table-hover">
                        <thead>
                            <tr>
                                <th>Category</th>
                                <th class="hidden-phone">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach (App\ExpenseCategory::latest()->get() as $item)
                                <tr class="">
                                    <td> {{ $item->name }} </td>
                                    <td>
                                        $ {{ $item->expenses->sum('amount') }}
                                    </td>
                                </tr>
                            @endforeach


                        </tbody>
                    </table>
                </section>
            </div>

            <style>
                .billl {
                    background: #39b24f !important;
                }

                .due {
                    background: #39b1d1 !important;
                }
            </style>

            <div class="col-lg-5">
                <section class="panel">
                    <div class="weather-bg">
                        <div class="panel-body billl">
                            <div class="row">
                                <div class="col-xs-4">
                                    <i class="fa fa-money-bill-alt"></i>
                                    Gross Bill
                                </div>
                                <div class="col-xs-8">
                                    <div class="degree">
                                        $ {{ App\FinancePayment::sum('gross_total') }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="panel">
                    <div class="weather-bg">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-xs-4">
                                    <i class="fa fa-money-bill-alt"></i>
                                    Gross Hospital Amount
                                </div>
                                <div class="col-xs-8">
                                    <div class="degree">
                                        $ 0
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="panel">
                    <div class="weather-bg">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-xs-4">
                                    <i class="fa fa-money-bill-alt"></i>
                                    Gross Doctors Commission
                                </div>
                                <div class="col-xs-8">
                                    <div class="degree">
                                        $ 0
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="panel">
                    <div class="weather-bg">
                        <div class="panel-body billl">
                            <div class="row">
                                <div class="col-xs-4">
                                    <i class="fa fa-money-bill-alt"></i>
                                    Gross Deposit
                                </div>
                                <div class="col-xs-8">
                                    <div class="degree">
                                        $ {{ App\FinancePayment::sum('diposited_amount') }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="panel">
                    <div class="weather-bg">
                        <div class="panel-body billl">
                            <div class="row">
                                <div class="col-xs-4">
                                    <i class="fa fa-money-bill-alt"></i>
                                    Gross Due
                                </div>
                                <div class="col-xs-8">
                                    <div class="degree">
                                        $ {{ App\FinancePayment::sum('gross_total') - App\FinancePayment::sum('diposited_amount') }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="panel">
                    <div class="weather-bg">
                        <div class="panel-body due">
                            <div class="row">
                                <div class="col-xs-4">
                                    <i class="fa fa-money-bill-alt"></i>
                                    Gross Expense
                                </div>
                                <div class="col-xs-8">
                                    <div class="degree">
                                        $ {{ App\Expense::sum('amount') }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
        <!-- page end-->
    </section>
</section>
<!--main content end-->

@endsection
