@extends('layouts.website.website')
@section('content')
    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->

            <section class="col-md-5 no-print">
                <header class="panel-heading no-print">
                    Add Lab Report
                </header>
                <div class="no-print">
                    <div class="adv-table editable-table">
                        <div class="clearfix">
                            <style>
                                .lab {
                                    padding-top: 10px;
                                    padding-bottom: 20px;
                                    border: none;
                                }

                                .pad_bot {
                                    padding-bottom: 5px;
                                }

                                form {
                                    background: #ffffff;
                                    padding: 20px 0px;
                                }

                                .modal-body form {
                                    background: #fff;
                                    padding: 21px;
                                }

                                .remove {
                                    float: right;
                                    margin-top: -45px;
                                    margin-right: 42%;
                                    margin-bottom: 41px;
                                    width: 94px;
                                    height: 29px;
                                }

                                .remove1 span {
                                    width: 33%;
                                    height: 50px !important;
                                    padding: 10px;
                                }

                                .qfloww {
                                    padding: 10px 0px;
                                    height: 370px;
                                    background: #f1f2f9;
                                    overflow: auto;
                                }

                                .remove1 {
                                    background: #5a9599;
                                    color: #fff;
                                    padding: 5px;
                                }

                                .span2 {
                                    padding: 6px 12px;
                                    font-size: 14px;
                                    font-weight: 400;
                                    line-height: 1;
                                    color: #555;
                                    text-align: center;
                                    background-color: #eee;
                                    border: 1px solid #ccc;
                                }
                            </style>

                            <form role="form" id="editLabForm" class="clearfix" action="{{ route('store_lab') }}"
                                method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="">
                                    <div class="col-md-6 lab pad_bot">
                                        <label for="exampleInputEmail1">Date</label>
                                        <input type="date" class="form-control pay_in" name="date"
                                            value="{{ Carbon\Carbon::today()->format('Y-m-d') }}" placeholder="" />
                                    </div>

                                    <div class="col-md-6 lab pad_bot">
                                        <label for="exampleInputEmail1">Patient</label>
                                        <select class="form-control m-bot15 pos_select" id="pos_select" name="patient"
                                            value="">
                                            <option value="">Choose</option>
                                            @foreach (App\User::where('role_id', 8)->orderBy('name', 'ASC')->get() as $item)
                                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-md-8 panel"></div>

                                    <div class="pos_client">
                                        <div class="col-md-8 lab pad_bot">
                                            <div class="col-md-3 lab_label">
                                                <label for="exampleInputEmail1"> Patient Name</label>
                                            </div>
                                            <div class="col-md-9">
                                                <input type="text" class="form-control pay_in" name="p_name"
                                                    value="" placeholder="" />
                                            </div>
                                        </div>
                                        <div class="col-md-8 lab pad_bot">
                                            <div class="col-md-3 lab_label">
                                                <label for="exampleInputEmail1"> Patient Email</label>
                                            </div>
                                            <div class="col-md-9">
                                                <input type="text" class="form-control pay_in" name="p_email"
                                                    value="" placeholder="" />
                                            </div>
                                        </div>
                                        <div class="col-md-8 lab pad_bot">
                                            <div class="col-md-3 lab_label">
                                                <label for="exampleInputEmail1"> Patient Phone</label>
                                            </div>
                                            <div class="col-md-9">
                                                <input type="text" class="form-control pay_in" name="p_phone"
                                                    value="" placeholder="" />
                                            </div>
                                        </div>
                                        <div class="col-md-8 lab pad_bot">
                                            <div class="col-md-3 lab_label">
                                                <label for="exampleInputEmail1"> Patient Age</label>
                                            </div>
                                            <div class="col-md-9">
                                                <input type="text" class="form-control pay_in" name="p_age"
                                                    value="" placeholder="" />
                                            </div>
                                        </div>
                                        <div class="col-md-8 lab pad_bot">
                                            <div class="col-md-3 lab_label">
                                                <label for="exampleInputEmail1"> Patient Gender</label>
                                            </div>
                                            <div class="col-md-9">
                                                <select class="form-control m-bot15" name="p_gender" value="">
                                                    <option value="Male"> Male </option>
                                                    <option value="Female"> Female </option>
                                                    <option value="Others"> Others </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6 lab pad_bot">
                                        <label for="exampleInputEmail1"> Refd By Doctor</label>
                                        <select class="form-control m-bot15 add_doctor" id="add_doctor" name="doctor"
                                            value="">
                                            @foreach (App\User::where('role_id', 4)->orderBy('name', 'ASC')->get() as $item)
                                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-md-6 lab pad_bot">
                                        {{-- <label for="exampleInputEmail1"> Template </label>
                                        <select class="form-control m-bot15 js-example-basic-multiple template" id="template" name="template" value="">
                                            <option value="">Select .....</option>
                                            <option value="9">Lipid Profile Result </option>
                                            <option value="8">superadmin </option>
                                            <option value="6">CBC </option>
                                            <option value="5">Lipid Profile </option>
                                            <option value="3">Diagnostic </option>
                                        </select> --}}
                                    </div>

                                    <div class="pos_doctor">
                                        <div class="col-md-8 lab pad_bot">
                                            <div class="col-md-3 lab_label">
                                                <label for="exampleInputEmail1"> Doctor Name</label>
                                            </div>
                                            <div class="col-md-9">
                                                <input type="text" class="form-control pay_in" name="d_name"
                                                    value="" placeholder="" />
                                            </div>
                                        </div>
                                        <div class="col-md-8 lab pad_bot">
                                            <div class="col-md-3 lab_label">
                                                <label for="exampleInputEmail1"> Doctor Email</label>
                                            </div>
                                            <div class="col-md-9">
                                                <input type="text" class="form-control pay_in" name="d_email"
                                                    value="" placeholder="" />
                                            </div>
                                        </div>
                                        <div class="col-md-8 lab pad_bot">
                                            <div class="col-md-3 lab_label">
                                                <label for="exampleInputEmail1"> Doctor Phone</label>
                                            </div>
                                            <div class="col-md-9">
                                                <input type="text" class="form-control pay_in" name="d_phone"
                                                    value="" placeholder="" />
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-8 panel"></div>
                                </div>

                                <div class="col-md-12 lab pad_bot">
                                    <label for="exampleInputEmail1"> Report</label>
                                    <textarea class="description form-control" id="editor" name="report" value="" rows="10">
                                        <table align="center" border="1" cellpadding="5" cellspacing="0"><thead><tr><th scope="col">Head 1</th><th scope="col">Head 2</th><th scope="col">Head 3</th><th scope="col">Head 4</th><th scope="col">Head 5</th></tr></thead><tbody><tr><td><br></td><td><br></td><td><br></td><td><br></td><td><br></td></tr><tr><td><br></td><td><br></td><td><br></td><td><br></td><td><br></td></tr></tbody></table>
                                    </textarea>
                                </div>

                                <input type="hidden" name="redirect" value="lab" />

                                <input type="hidden" name="id" value="" />

                                <div class="col-md-12 lab">
                                    <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </section>

            <section class="col-md-7">
                <header class="panel-heading">
                    Lab Report
                    <div class="col-md-4 no-print pull-right">
                        <a href="lab/addLabView">
                            <div class="btn-group pull-right">
                                <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add Lab
                                    Report</button>
                            </div>
                        </a>
                    </div>
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <div class="space15"></div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th>Report Id</th>
                                    <th>Patient</th>
                                    <th>Doctor</th>
                                    <th>Date</th>
                                    <th class="">Options</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($DoctorLab as $item)
                                    <tr>
                                        <td>{{ $item->id }}</td>
                                        <td>{{ $item->patient->name }}</td>
                                        <td>{{ $item->doctor->name }}</td>
                                        <td>{{ Carbon\Carbon::parse($item->date)->format('d,m Y h:i') }}</td>
                                        <td>
                                            {{-- <a class="btn btn-info btn-xs editbutton" title="edit" href="lab?id=1939"><i class="fa fa-edit"> </i> </a> --}}
                                            <a class="btn btn-xs invoicebutton" title="invoice" style="color: #fff;"
                                                href="{{ route('website_lab_view', $item->id) }}"><i
                                                    class="fa fa-file"></i> </a>
                                            {{-- <a class="btn btn-info btn-xs delete_button" title="حذف" href="{{ route('delete_lab',$item->id) }}" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"></i></a> --}}
                                        </td>

                                    </tr>
                                @endforeach
                                <style>
                                    .img_url {
                                        height: 20px;
                                        width: 20px;
                                        background-size: contain;
                                        max-height: 20px;
                                        border-radius: 100px;
                                    }

                                    .option_th {
                                        width: 18%;
                                    }
                                </style>
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>

    <style>
        .note-editable table tr td {
            border-bottom: 1px solid black;
            border-left: 1px solid black;
            border-top: 1px solid black;
            border-right: 1px solid black;
        }

        .note-editable table tr td {
            border: 1px solid balck !important;
        }
    </style>

    <script>
        $(document).ready(function() {
            $('.pos_client').hide();
            $(document.body).on('change', '#pos_select', function() {

                var v = $("select.pos_select option:selected").val()
                if (v == 'add_new') {
                    $('.pos_client').show();
                } else {
                    $('.pos_client').hide();
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.pos_doctor').hide();
            $(document.body).on('change', '#add_doctor', function() {

                var v = $("select.add_doctor option:selected").val()
                if (v == 'add_new') {
                    $('.pos_doctor').show();
                } else {
                    $('.pos_doctor').hide();
                }
            });

        });
    </script>
    <script type="text/javascript">
        $(document).ready(function() {
            $(document.body).on('change', '#template', function() {
                var iid = $("select.template option:selected").val();
                $.ajax({
                    url: 'lab/getTemplateByIdByJason?id=' + iid,
                    method: 'GET',
                    data: '',
                    dataType: 'json',
                }).success(function(response) {
                    var data = CKEDITOR.instances.editor.getData();
                    if (response.template.template != null) {
                        var data1 = data + response.template.template;
                    } else {
                        var data1 = data;
                    }
                    CKEDITOR.instances['editor'].setData(data1)
                });
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $("#pos_select").select2({
                placeholder: 'Search Patient Name / ID',
                allowClear: true,
                ajax: {
                    url: 'patient/getPatientinfoWithAddNewOption',
                    type: "post",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            searchTerm: params.term // search term
                        };
                    },
                    processResults: function(response) {
                        return {
                            results: response
                        };
                    },
                    cache: true
                }

            });

            $("#add_doctor").select2({
                placeholder: 'Search Doctor Name / ID',
                allowClear: true,
                ajax: {
                    url: 'doctor/getDoctorWithAddNewOption',
                    type: "post",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            searchTerm: params.term // search term
                        };
                    },
                    processResults: function(response) {
                        return {
                            results: response
                        };
                    },
                    cache: true
                }

            });

        });
    </script>
@endsection
