@extends('layouts.website.website')
@section('content')
    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->

            <section class="col-md-12">
                <header class="panel-heading">
                    Lab Report
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <div class="space15"></div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th>Report Id</th>
                                    <th>Patient</th>
                                    <th>Date</th>
                                    <th class="">Options</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (App\DoctorLab::latest()->get() as $item)
                                    <tr role="row" class="odd">
                                        <td class="sorting_1 dtr-control">{{ $item->id }}</td>
                                        <td>{{ $item->patient->name }}</td>
                                        <td>{{ $item->created_at->format('d,m Y') }}</td>
                                        <td>
                                            <a class="btn btn-xs invoicebutton" title="Lab" style="color: #fff;" href="{{ route('website_lab_view',$item->id) }}"><i class="fa fa-file"></i> </a>
                                        </td>
                                    </tr>
                                @endforeach


                                <style>
                                    .img_url {
                                        height: 20px;
                                        width: 20px;
                                        background-size: contain;
                                        max-height: 20px;
                                        border-radius: 100px;
                                    }
                                    .option_th {
                                        width: 18%;
                                    }
                                </style>
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>
    <!--main content end-->
    <!--footer start-->

@endsection
