@extends('layouts.website.website')
@section('content')
    <!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="">
            <header class="panel-heading">
                Medicine
                <div class="col-md-4 no-print pull-right">
                    <a data-toggle="modal" href="#myModal">
                        <div class="btn-group pull-right">
                            <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add Medicine</button>
                        </div>
                    </a>
                </div>
            </header>
            <style>
                .wrapper {
                    padding: 0px 10px 0px 15px !important;
                }
            </style>

            <div class="panel-body">
                <div class="adv-table editable-table">
                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>Name</th>
                                <th>Category</th>
                                <th>Store Box</th>
                                <th>Purchase Price</th>
                                <th>Sale Price</th>
                                <th>Quantity</th>
                                <th>Generic Name</th>
                                <th>Company</th>
                                <th>Effects</th>
                                <th>Expire date</th>
                                <th>Options</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach (App\MadicneList::orderBy('name','ASC')->get() as $item)
                                <tr role="row" class="odd">
                                    <td class="sorting_1 dtr-control">{{ $item->id }}</td>
                                    <td>{{ $item->name }}</td>
                                    @if ($item->categorys)
                                        <td>{{ $item->categorys->name }}</td>
                                    @else
                                        <td></td>
                                    @endif
                                    <td>{{ $item->storebox }}</td>
                                    <td>{{ $item->price }}</td>
                                    <td>{{ $item->saleprice }}</td>
                                    <td>
                                        {{ $item->quantity }}<br />
                                        <button type="button" class="btn btn-info btn-xs btn_width load" data-toggle="modal" data-qty="{{ $item->quantity }}" data-id="{{ $item->id }}">Load</button>
                                    </td>
                                    <td>{{ $item->genericname }}</td>
                                    <td>{{ $item->company }}</td>
                                    <td>{{ $item->effect }}</td>
                                    <td>{{ Carbon\Carbon::parse($item->expire_date)->format('d,M Y') }}</td>
                                    <td>
                                        <button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="{{ $item->id }}"><i class="fa fa-edit"> </i> Edit</button>
                                        <a class="btn btn-info btn-xs btn_width delete_button" href="{{ route('website_medicineDelete',$item->id) }}" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"> </i> Delete</a>
                                    </td>
                                </tr>
                            @endforeach


                            <style>
                                .img_url {
                                    height: 20px;
                                    width: 20px;
                                    background-size: contain;
                                    max-height: 20px;
                                    border-radius: 100px;
                                }

                                .load {
                                    float: right !important;
                                }
                            </style>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->

<!-- Add Accountant Modal-->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Add Medicine</h4>
            </div>
            <div class="modal-body row">
                <form role="form" action="{{ route('website_medicineStore') }}" class="clearfix" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"> Name</label>
                        <input type="text" class="form-control" name="name" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"> Category</label>
                        <select class="form-control m-bot15 select2" name="category_id" value="">
                            @foreach (App\MadicineCategory::orderBy('name','ASC')->get() as $item)
                                <option value="{{ $item->id }}"> {{ $item->name }} </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"> Purchase Price</label>
                        <input type="text" class="form-control" name="price" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"> Sale Price</label>
                        <input type="text" class="form-control" name="saleprice" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"> Store Box</label>
                        <input type="text" class="form-control" name="storebox" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"> Quantity</label>
                        <input type="text" class="form-control" name="quantity" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"> Generic Name</label>
                        <input type="text" class="form-control" name="genericname" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"> Company</label>
                        <input type="text" class="form-control" name="company" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"> Effects</label>
                        <input type="text" class="form-control" name="effect" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"> Expire date</label>
                        <input type="date" class="form-control" name="expire_date" id="exampleInputEmail1" value="" placeholder="" />
                    </div>

                    <input type="hidden" name="id" value="" />
                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- Add Accountant Modal-->

<!-- Edit Event Modal-->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Edit Medicine</h4>
            </div>
            <div class="modal-body row">
                <form role="form" id="editMedicineForm" class="clearfix" action="medicine/addNewMedicine" method="post" enctype="multipart/form-data">
                    <div class="form-group col-md-5">
                        <label for="exampleInputEmail1"> Name</label>
                        <input type="text" class="form-control" name="name" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-5">
                        <label for="exampleInputEmail1"> Category</label>
                        <select class="form-control m-bot15 select2" name="category_id" value="">
                            @foreach (App\MadicineCategory::orderBy('name','ASC')->get() as $item)
                                <option value="{{ $item->id }}"> {{ $item->name }} </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-md-3">
                        <label for="exampleInputEmail1"> Purchase Price</label>
                        <input type="text" class="form-control" name="price" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-3">
                        <label for="exampleInputEmail1"> Sale Price</label>
                        <input type="text" class="form-control" name="saleprice" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-3">
                        <label for="exampleInputEmail1"> Quantity</label>
                        <input type="text" class="form-control" name="quantity" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-5">
                        <label for="exampleInputEmail1"> Generic Name</label>
                        <input type="text" class="form-control" name="genericname" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-5">
                        <label for="exampleInputEmail1"> Company</label>
                        <input type="text" class="form-control" name="company" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-5">
                        <label for="exampleInputEmail1"> Effects</label>
                        <input type="text" class="form-control" name="effect" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1"> Store Box</label>
                        <input type="text" class="form-control" name="storebox" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-3">
                        <label for="exampleInputEmail1"> Expire date</label>
                        <input type="date" class="form-control" name="expire_date" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <input type="hidden" name="id" value="" />
                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- Edit Event Modal-->

<!-- Load Medicine -->
<div class="modal fade" id="myModal3" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Load Medicine</h4>
            </div>
            <div class="modal-body">
                <form role="form" id="editMedicineForm" class="clearfix" action="{{ route('website_medicineQtyUpdate') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group">
                        <label for="exampleInputEmail1"> Add Quantity</label>
                        <input type="text" class="form-control" name="qty" id="exampleInputEmail1" value="" placeholder="" />
                    </div>

                    <input type="hidden" name="id" value="" />

                    <div class="form-group">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- Load Medicine -->

<script type="text/javascript">
    $(document).ready(function () {
        $(".table").on("click", ".editbutton", function () {
            var iid = $(this).attr("data-id");
            $("#editMedicineForm").trigger("reset");
            $("#myModal2").modal("show");
            $.ajax({
                url: "/medicine/medicineEdit/" + iid,
                method: "GET",
                data: "",
                dataType: "json",
            }).success(function (response) {
                // Populate the form fields with the data returned from server
                $("#editMedicineForm").find('[name="id"]').val(response.id).end();
                $("#editMedicineForm").find('[name="name"]').val(response.name).end();
                $("#editMedicineForm").find('[name="storebox"]').val(response.storebox).end();
                $("#editMedicineForm").find('[name="price"]').val(response.price).end();
                $("#editMedicineForm").find('[name="saleprice"]').val(response.saleprice).end();
                $("#editMedicineForm").find('[name="quantity"]').val(response.quantity).end();
                $("#editMedicineForm").find('[name="genericname"]').val(response.genericname).end();
                $("#editMedicineForm").find('[name="company"]').val(response.company).end();
                $("#editMedicineForm").find('[name="effect"]').val(response.effect).end();
                $("#editMedicineForm").find('[name="expire_date"]').val(response.expire_date).end();
            });
        });
    });
</script>
<script type="text/javascript">
    $(document).ready(function () {
        $(".table").on("click", ".load", function () {
            // e.preventDefault(e);
            // Get the record's ID via attribute
            var iid = $(this).attr("data-id");
            var qty = $(this).data("qty");
            $("#editMedicineForm").trigger("reset");
            $("#myModal3").modal("show");

            //  var id = $(this).data('id');
            console.log(qty,iid);

            // Populate the form fields with the data returned from server
            $("#editMedicineForm").find('[name="id"]').val(iid).end();
            $("#editMedicineForm").find('[name="qty"]').val(qty).end();
        });
    });
</script>


@endsection
