@extends('layouts.website.website')
@section('content')

    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="panel">
                <header class="panel-heading">
                    Notice
                    <div class="col-md-4 no-print pull-right">
                        <a data-toggle="modal" href="#myModal">
                            <div class="btn-group pull-right">
                                <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add Notice</button>
                            </div>
                        </a>
                    </div>
                </header>

                <style>
                    .form-control {
                        height: auto !important;
                    }
                </style>

                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <div class="space15"></div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Notice</th>
                                    <th>Date</th>
                                    <th>Options</th>
                                </tr>
                            </thead>
                            <tbody>
                                <style>
                                    .img_url {
                                        height: 20px;
                                        width: 20px;
                                        background-size: contain;
                                        max-height: 20px;
                                        border-radius: 100px;
                                    }
                                </style>
                                @foreach (App\Notice::latest()->get() as $item)
                                    <tr class="">
                                        <td>{{ $item->title }}</td>
                                        <td style="width: 40%"><p>{{ $item->description }}</p></td>
                                        <td class="center">{{ $item->role_name->name }}</td>
                                        <td>{{ $item->created_at->format('D,m Y') }}</td>
                                        <td>
                                            <button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="{{ $item->id }}"><i class="fa fa-edit"> Edit</i></button>
                                            <a class="btn btn-info btn-xs btn_width delete_button" href="/notice/delete/{{ $item->id }}" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash-o"> Delete</i></a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>
    <!--main content end-->
    <!--footer start-->

    <!-- Add Notice Modal-->
    <div class="modal fade" id="myModal" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Add Notice</h4>
                </div>
                <div class="modal-body">
                    <form role="form" action="{{ route('website_notice_store') }}" class="clearfix row" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Title</label>
                            <input type="text" class="form-control" name="title" id="exampleInputEmail1" value="" placeholder="" />
                        </div>

                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Notice For</label>
                            <select class="form-control m-bot15" name="type" value="">
                                @foreach (App\UserRole::orderBy('name','ASC')->get() as $item)
                                    <option value="{{ $item->id }}" selected>{{ $item->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-md-12 des">
                            <label class="">Description</label>
                            <div class="">
                                <textarea class="ckeditor form-control editor" id="editor" name="description" value="" rows="10"></textarea>
                            </div>
                        </div>

                        {{-- <div class="form-group col-md-4">
                            <label for="exampleInputEmail1"> Date</label>
                            <input type="date" class="form-control" name="date" id="exampleInputEmail1" value="" placeholder="" />
                        </div> --}}

                        <div class="form-group col-md-12">
                            <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Add Notice Modal-->

    <!-- Edit Notice Modal-->
    <div class="modal fade" id="myModal2" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Edit Notice</h4>
                </div>
                <div class="modal-body">
                    <form role="form" id="editNoticeForm" class="clearfix row" action="{{ route('website_notice_update') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Title</label>
                            <input type="text" class="form-control" name="title" id="exampleInputEmail1" value="" placeholder="" />
                        </div>

                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Notice For</label>
                            <select class="form-control m-bot15" name="type" value="">
                                @foreach (App\UserRole::orderBy('name','ASC')->get() as $item)
                                    <option value="{{ $item->id }}" selected>{{ $item->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-md-12 des">
                            <label class="">Description</label>
                            <div class="">
                                <textarea class="ckeditor form-control editor" id="editor" name="description" value="" rows="10"></textarea>
                            </div>
                        </div>
                        {{-- <div class="form-group col-md-4">
                            <label for="exampleInputEmail1"> Date</label>
                            <input type="date" class="form-control" name="date" id="exampleInputEmail1" value="" placeholder=""/>
                        </div> --}}

                        <input type="hidden" name="id" value="16" />
                        <div class="form-group col-md-12">
                            <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Edit Event Modal-->

    <script type="text/javascript">
        $(document).ready(function () {
            $(".editbutton").click(function (e) {
                e.preventDefault(e);
                // Get the record's ID via attribute
                var iid = $(this).attr("data-id");
                $("#editNoticeForm").trigger("reset");
                $("#myModal2").modal("show");
                $.ajax({
                    url: "/notice/edit/" + iid,
                    method: "GET",
                    data: "",
                    dataType: "json",
                }).success(function (response) {
                    // Populate the form fields with the data returned from server

                    var de = response.date * 1000;
                    var d = new Date(de);
                    var date = d.getDate() + 1 + "-" + (d.getMonth() + 1) + "-" + d.getFullYear();

                    $("#editNoticeForm").find('[name="id"]').val(response.id).end();
                    $("#editNoticeForm").find('[name="title"]').val(response.title).end();
                    $("#editNoticeForm").find('[name="description"]').val(response.description).end();
                    // $("#editNoticeForm").find('[name="date"]').val(date).end();
                    CKEDITOR.instances["editor"].setData(response.description);
                });
            });
        });
    </script>

@endsection
