@extends('layouts.website.website')
@section('content')
    <!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="no-print col-md-8">
            <header class="panel-heading">
                Payment History

                <div class="panel-body no-print pull-right">
                    <a data-toggle="modal" href="#myModal">
                        <div class="btn-group">
                            <button id="" class="btn btn-xs green"><i class="fa fa-plus-circle"></i> Deposit</button>
                        </div>
                    </a>
                </div>

                <div class="panel-body no-print pull-right">
                    <a id="invoice_btn" data-toggle="modal" href="#myModal5">
                        <div class="btn-group">
                            <button id="" class="btn btn-xs green"><i class="fa fa-file"></i> Invoice</button>
                        </div>
                    </a>
                </div>

                <div class="panel-body no-print pull-right">
                    <a href="{{ route('website_addPaymentView') }}">
                        <div class="btn-group">
                            <button id="" class="btn btn-xs green"><i class="fa fa-plus-circle"></i> Add Payment</button>
                        </div>
                    </a>
                </div>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table">
                    <section class="col-md-12 no-print row">
                        <form role="form" class="f_report" action="finance/patientPaymentHistory" method="post" enctype="multipart/form-data">
                            <div class="form-group">
                                <!--     <label class="control-label col-md-3">Date Range</label> -->
                                <div class="col-md-6">
                                    <div class="input-group input-large" data-date="13/07/2013" data-date-format="mm/dd/yyyy">
                                        <input type="text" class="form-control dpd1" name="date_from" value="" placeholder="Date From" readonly="" />
                                        <span class="input-group-addon">to</span>
                                        <input type="text" class="form-control dpd2" name="date_to" value="" placeholder="Date To" readonly="" />
                                        <input type="hidden" class="form-control dpd2" name="patient" value="81" />
                                    </div>
                                    <div class="row"></div>
                                    <span class="help-block"></span>
                                </div>
                                <div class="col-md-6 no-print">
                                    <button type="submit" name="submit" class="btn btn-info range_submit">Submit</button>
                                </div>
                            </div>
                        </form>
                    </section>

                    <header class="panel-heading col-md-12 row">
                        All Bills & Deposits
                    </header>
                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-samples">
                        <thead>
                            <tr>
                                <th class="">Date</th>
                                <th class="">Invoice #</th>
                                <th class="">Bill Amount</th>
                                <th class="">Deposit</th>
                                <th class="">Deposit Type</th>
                                <th class="no-print">Options</th>
                            </tr>
                        </thead>
                        <tbody>
                            <style>
                                .img_url {
                                    height: 20px;
                                    width: 20px;
                                    background-size: contain;
                                    max-height: 20px;
                                    border-radius: 100px;
                                }
                                .option_th {
                                    width: 33%;
                                }
                            </style>

                            @foreach ($payments as $item)
                                <tr class="">
                                    <td>{{ Carbon\Carbon::parse($item->date)->format('d,m Y') }}</td>
                                    <td>{{ $item->invoice_id }}</td>
                                    <td>$ {{ $item->total_amount->sum('price') }}</td>
                                    <td>$ {{ $item->diposited_amount }}</td>
                                    <td>{{ $item->diposit_type }}</td>
                                    <td class="no-print">
                                        <a class="btn-xs invoicebutton" title="Invoice" style="color: #fff; width: 25%;" href="#finance/invoice?id=2418"><i class="fa fa-file-invoice"></i> </a>
                                    </td>
                                </tr>
                            @endforeach


                        </tbody>
                    </table>
                </div>
            </div>
        </section>

        <section class="no-print col-md-4">
            <header class="panel-heading"></header>

            <div class="">
                <section class="m_t">
                    <div class="panel-body profile">
                        <div class="task-thumb-details">
                            Patient Name:
                            <h1><a href="#">{{ $item->patient->name }}</a></h1>
                            <br />
                            Address:
                            <p>{{ $item->patient->address }}</p>
                        </div>
                    </div>
                    <table class="table table-hover personal-task">
                        <tbody>
                            <tr>
                                <td>
                                    <i class="fa fa-envelope"></i>
                                </td>
                                <td>{{ $item->patient->email }}</td>
                            </tr>
                            <tr>
                                <td>
                                    <i class="fa fa-phone"></i>
                                </td>
                                <td>{{ $item->patient->phone }}</td>
                            </tr>
                        </tbody>
                    </table>
                </section>

                <section class="panel">
                    <div class="weather-bg">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-xs-4">
                                    <i class="fa fa-money"></i>
                                    Total Bill Amount
                                </div>
                                <div class="col-xs-8">
                                    <div class="degree">
                                        $ {{ $payments->sum('gross_total') }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="panel">
                    <div class="weather-bg">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-xs-4">
                                    <i class="fa fa-money"></i>
                                    Total Deposit Amount
                                </div>
                                <div class="col-xs-8">
                                    <div class="degree">
                                        $ {{ $payments->sum('diposited_amount') }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="panel red" style="border: 2px solid red; color: red;">
                    <div class="weather-bg">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-xs-4">
                                    <i class="fa fa-money"></i>
                                    Due Amount
                                </div>
                                <div class="col-xs-8">
                                    <div class="degree">
                                        $ {{ $payments->sum('gross_total') - $payments->sum('diposited_amount')  }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->

<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">  Add Deposit </h4>
            </div>
            <div class="modal-body">
                <form role="form" action="/finance/patient/add_due_payment_to_invoice" id="deposit-form" class="clearfix" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group" style="display: none;">
                        <label for="exampleInputEmail1">Invoice</label>
                        <select class="form-control m-bot15 js-example-basic-single" id="" name="payment_id" value='' required="">
                            <option value="">Select .....</option>
                            <option value="2419"  >2419 </option>
                            <option value="2418" selected >2418 </option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="exampleInputEmail1">Deposit Amount </label>
                        <input type="text" class="form-control" name="deposited_amount" id="exampleInputEmail1" value='{{ $payments->sum('gross_total') - $payments->sum('diposited_amount')  }}' placeholder="">
                    </div>
                    <div class="form-group">
                        <div class="">
                            <label for="exampleInputEmail1">Deposit Type</label>
                        </div>
                        <div class="">
                            <select class="form-control m-bot15 js-example-basic-single selecttype" id="selecttype" name="deposit_type" value=''>
                                <option value="Cash"> Cash </option>
                                <option value="Card"> Card </option>
                            </select>
                        </div>
                        <div class = "card">
                            <hr>
                            <div class="col-md-12 payment pad_bot">
                                <label for="exampleInputEmail1"> Accepted Cards</label>
                                <div class="payment pad_bot">
                                    <img src="uploads/card.png" width="100%">
                                </div>
                            </div>
                        </div>
                        <input type="hidden" name="id" value=''>
                        <input type="hidden" name="patient" value='{{ $item->patient_id }}'>
                        <div class="form-group cashsubmit payment  right-six col-md-12">
                            <button type="submit" name="submit2" id="submit1" class="btn btn-info row pull-right"> Submit</button>
                        </div>
                    </div>
                    <div class="form-group cardsubmit  right-six col-md-12 hidden">
                        <button type="submit" name="pay_now" id="submit-btn" class="btn btn-info row pull-right" > Submit</button>
                    </div>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<div class="modal fade" id="myModal5" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header no-print">
                <button type="button" class="close no-print" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Invoice</h4>
            </div>
            <div class="modal-body clearfix">
                <div class="panel panel-primary">
                    <!--<div class="panel-heading navyblue"> INVOICE</div>-->
                    <div class="panel" id="invoice" style="font-size: 10px;width: 100%;">
                        <div class="row invoice-list">
                            <div class="text-center corporate-id top_title">
                                <img alt="" src="uploads/logo-nonetext1.png" width="200" height="100" />
                                <h3>
                                    Hospital
                                </h3>
                                <h4>
                                    Boropool, Rajbari-7700
                                </h4>
                                <h4>
                                    Tel: +0123456789
                                </h4>
                            </div>
                            <div class="col-lg-4 col-sm-4" style="float: left;">
                                <h4>Payment To:</h4>
                                <p>
                                    Hospital <br />
                                    Boropool, Rajbari-7700<br />
                                    Tel: +0123456789
                                </p>
                            </div>
                            <div class="col-lg-4 col-sm-4" style="float: left;">
                                <h4>Bill To:</h4>
                                <p>
                                    {{ $item->patient->name }} <br />
                                    {{ $item->patient->address }} <br />
                                    {{ $item->patient->phone }} <br />
                                </p>
                            </div>
                            <div class="col-lg-4 col-sm-4" style="float: left;">
                                <h4>INVOICE INFO</h4>
                                <ul class="unstyled">
                                    <li>Date : {{ Carbon\Carbon::now()->format('d/m/Y') }}</li>
                                </ul>
                            </div>
                            <br />
                        </div>
                        <table class="table table-striped table-hover table-bordered" id="editable-samples">
                            <thead>
                                <tr>
                                    <th class="">Date</th>
                                    <th class="">Invoice #</th>
                                    <th class="">Bill Amount</th>
                                    <th class="">Deposit</th>
                                </tr>
                            </thead>
                            <tbody>
                                <style>
                                    .img_url {
                                        height: 20px;
                                        width: 20px;
                                        background-size: contain;
                                        max-height: 20px;
                                        border-radius: 100px;
                                    }
                                    .option_th {
                                        width: 33%;
                                    }
                                </style>

                                @foreach ($payments as $pinv)
                                    <tr class="">
                                        <td>{{ Carbon\Carbon::parse($pinv->date)->format('d,m Y') }}</td>
                                        <td>{{ $item->invoice_id }}</td>
                                        <td>$ {{ $item->total_amount->sum('price') }}</td>
                                        <td>$ {{ $item->diposited_amount }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div class="row">
                            <div class="col-lg-8 invoice-block pull-right total_section">
                                <ul class="unstyled amounts">
                                    <li><strong>Grand Total : </strong>$ {{ $payments->sum('gross_total') }}</li>
                                    <li><strong>Amount Received : </strong>$ {{ $payments->sum('diposited_amount') }}</li>
                                    <li><strong>Amount To Be Paid : </strong>$ {{ $payments->sum('gross_total') - $payments->sum('diposited_amount')  }}</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="panel col-md-12 no-print">
                        <a class="btn btn-info invoice_button" onclick="javascript:window.print();"><i class="fa fa-print"></i> Print </a>
                    </div>

                    <div class="text-center invoice-btn clearfix">
                        <a class="btn btn-info btn-sm detailsbutton pull-left download" id="download"><i class="fa fa-download"></i> Download </a>
                    </div>
                </div>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

{{-- <div class="modal fade" id="myModal3" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"><i class="fa fa-plus-circle"></i> Choose Payment Type</h4>
            </div>
            <div class="modal-body">
                <div class="clearfix">
                    <div class="col-lg-12 clearfix">
                        <a href="finance/addPaymentByPatientView?id=81&type=gen">
                            <div class="col-lg-6">
                                <div class="flat-carousal" style="background: #39b27c;">
                                    <div id="owl-demo" class="owl-carousel owl-theme" style="opacity: 1; display: block;">Add General Payment <i style="float: right; font-size: 18px;" class="fa fa-arrow-circle-o-right"></i></div>
                                </div>
                            </div>
                        </a>
                        <a href="finance/addPaymentByPatientView?id=81&type=ot">
                            <div class="col-lg-6">
                                <div class="flat-carousal" style="background: #39b27c;">
                                    <div id="owl-demo" class="owl-carousel owl-theme" style="opacity: 1; display: block;">Add OT Payment <i style="float: right; font-size: 18px;" class="fa fa-arrow-circle-o-right"></i></div>
                                </div>
                            </div>
                        </a>
                        <div class="col-lg-3"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div> --}}

{{-- <div class="modal fade" id="myModal5" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header no-print">
                <button type="button" class="close no-print" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Invoice</h4>
            </div>
            <div class="modal-body clearfix">
                <div class="panel panel-primary">
                    <!--<div class="panel-heading navyblue"> INVOICE</div>-->
                    <div class="panel" id="invoice" style="font-size: 10px;">
                        <div class="row invoice-list">
                            <div class="text-center corporate-id top_title">
                                <img alt="" src="uploads/logo-nonetext1.png" width="200" height="100" />
                                <h3>
                                    Hospital
                                </h3>
                                <h4>
                                    Boropool, Rajbari-7700
                                </h4>
                                <h4>
                                    Tel: +0123456789
                                </h4>
                            </div>
                            <div class="col-lg-4 col-sm-4" style="float: left;">
                                <h4>Payment To:</h4>
                                <p>
                                    Hospital <br />
                                    Boropool, Rajbari-7700<br />
                                    Tel: +0123456789
                                </p>
                            </div>
                            <div class="col-lg-4 col-sm-4" style="float: left;">
                                <h4>Bill To:</h4>
                                <p>
                                    dilli <br />
                                    tmp <br />
                                    9840000000 <br />
                                </p>
                            </div>
                            <div class="col-lg-4 col-sm-4" style="float: left;">
                                <h4>INVOICE INFO</h4>
                                <ul class="unstyled">
                                    <li>Date : 10/04/2020</li>
                                </ul>
                            </div>
                            <br />
                        </div>
                        <table class="table table-striped table-hover table-bordered" id="editable-samples">
                            <thead>
                                <tr>
                                    <th class="">Date</th>
                                    <th class="">Invoice #</th>
                                    <th class="">Bill Amount</th>
                                    <th class="">Deposit</th>
                                </tr>
                            </thead>
                            <tbody>
                                <style>
                                    .img_url {
                                        height: 20px;
                                        width: 20px;
                                        background-size: contain;
                                        max-height: 20px;
                                        border-radius: 100px;
                                    }
                                    .option_th {
                                        width: 33%;
                                    }
                                </style>

                                <tr class="">
                                    <td>04/10/20</td>
                                    <td>2418</td>
                                    <td>$ 400</td>
                                    <td>$ 400</td>
                                </tr>
                                <tr class="">
                                    <td>04/10/20</td>
                                    <td>2419</td>
                                    <td>$ 600</td>
                                    <td>$ 150</td>
                                </tr>
                            </tbody>
                        </table>
                        <div class="row">
                            <div class="col-lg-8 invoice-block pull-right total_section">
                                <ul class="unstyled amounts">
                                    <li><strong>Grand Total : </strong>$ 1000</li>
                                    <li><strong>Amount Received : </strong>$ 550</li>
                                    <li><strong>Amount To Be Paid : </strong>$ 450</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="panel col-md-12 no-print">
                        <a class="btn btn-info invoice_button" onclick="javascript:window.print();"><i class="fa fa-print"></i> Print </a>
                    </div>

                    <div class="text-center invoice-btn clearfix">
                        <a class="btn btn-info btn-sm detailsbutton pull-left download" id="download"><i class="fa fa-download"></i> Download </a>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div> --}}

<style>
    @media print {
        .modal-content {
            width: 100%;
        }

        .modal {
            overflow: hidden;
        }
    }
</style>

<script type="text/javascript" src="https://js.stripe.com/v2/"></script>

<script type="text/javascript">
    $(document).ready(function () {
        $('#invoice_btn').on('click',function(){
            $('#myModal5').modal('show');
        })
        $(".editbutton").click(function (e) {
            e.preventDefault(e);
            // Get the record's ID via attribute
            var iid = $(this).attr("data-id");
            $("#editDepositform").trigger("reset");
            $.ajax({
                url: "finance/editDepositbyJason?id=" + iid,
                method: "GET",
                data: "",
                dataType: "json",
            }).success(function (response) {
                // Populate the form fields with the data returned from server
                if (response.deposit.deposit_type != "Card") {
                    $("#editDepositform").find('[name="id"]').val(response.deposit.id).end();
                    $("#editDepositform").find('[name="patient"]').val(response.deposit.patient).end();
                    $("#editDepositform").find('[name="payment_id"]').val(response.deposit.payment_id).end();
                    $("#editDepositform").find('[name="date"]').val(response.deposit.date).end();
                    $("#editDepositform").find('[name="deposited_amount"]').val(response.deposit.deposited_amount).end();

                    $("#myModal2").modal("show");
                } else {
                    alert("Payement Processed By Card can not be edited. Thanks.");
                }
            });
        });
    });
</script>

<script>
    // $(document).ready(function () {
    //     $(document.body).on("change", "#selecttype", function () {
    //         var v = $("#selecttype option:selected").val();
    //         if (v == "payu") {
    //             $("#deposit-form").attr("action", "payu/check");
    //         } else {
    //             $("#deposit-form").attr("action", "finance/deposit");
    //         }
    //     });
    // });

    // $(document).ready(function () {
    //     var v = $("#selecttype option:selected").val();
    //     if (v == "payu") {
    //         $("#deposit-form").attr("action", "payu/check");
    //     } else {
    //         $("#deposit-form").attr("action", "finance/deposit");
    //     }
    // });
</script>

<script>
    $(document).ready(function () {
        $(".card").hide();
        $(document.body).on("change", "#selecttype", function () {
            var v = $("select.selecttype option:selected").val();
            if (v == "Card") {
                $(".card").show();
                $(".cardsubmit").removeClass("hidden");
                $(".cashsubmit").addClass("hidden");
            } else {
                $(".card").hide();
                $(".cashsubmit").removeClass("hidden");
                $(".cardsubmit").addClass("hidden");
            }
        });
    });
</script>

<script>
    $(document).ready(function () {
        $(".flashmessage").delay(3000).fadeOut(100);
    });
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/0.4.1/html2canvas.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.0.272/jspdf.debug.js"></script>
<script>
    function cardValidation() {
        var valid = true;
        var cardNumber = $("#card").val();
        var expire = $("#expire").val();
        var cvc = $("#cvv").val();

        $("#error-message").html("").hide();

        if (cardNumber.trim() == "") {
            valid = false;
        }

        if (expire.trim() == "") {
            valid = false;
        }
        if (cvc.trim() == "") {
            valid = false;
        }

        if (valid == false) {
            $("#error-message").html("All Fields are required").show();
        }

        return valid;
    }
    //set your publishable key
    Stripe.setPublishableKey("");

    //callback to handle the response from stripe
    function stripeResponseHandler(status, response) {
        if (response.error) {
            //enable the submit button
            $("#submit-btn").show();
            $("#loader").css("display", "none");
            //display the errors on the form
            $("#error-message").html(response.error.message).show();
        } else {
            //get token id
            var token = response["id"];
            //insert the token into the form
            $("#token").val(token);
            $("#deposit-form").append("<input type='hidden' name='token' value='" + token + "' />");
            console.log(token);
            //submit form to the server
            $("#deposit-form").submit();
        }
    }

    function stripePay(e) {
        e.preventDefault();
        var valid = cardValidation();

        if (valid == true) {
            $("#submit-btn").attr("disabled", true);
            $("#loader").css("display", "inline-block");
            var expire = $("#expire").val();
            var arr = expire.split("/");
            Stripe.createToken(
                {
                    number: $("#card").val(),
                    cvc: $("#cvv").val(),
                    exp_month: arr[0],
                    exp_year: arr[1],
                },
                stripeResponseHandler
            );

            //submit from callback
            return false;
        }
    }
</script>
<script>
    function cardValidation1() {
        var valid = true;
        var cardNumber = $("#card1").val();
        var expire = $("#expire1").val();
        var cvc = $("#cvv1").val();

        $("#error-message").html("").hide();

        if (cardNumber.trim() == "") {
            valid = false;
        }

        if (expire.trim() == "") {
            valid = false;
        }
        if (cvc.trim() == "") {
            valid = false;
        }

        if (valid == false) {
            $("#error-message").html("All Fields are required").show();
        }

        return valid;
    }
    //set your publishable key
    Stripe.setPublishableKey("");

    //callback to handle the response from stripe
    function stripeResponseHandler(status, response) {
        if (response.error) {
            //enable the submit button
            $("#submit-btn1").show();
            $("#loader").css("display", "none");
            //display the errors on the form
            $("#error-message").html(response.error.message).show();
        } else {
            //get token id
            var token = response["id"];
            //insert the token into the form
            $("#token").val(token);
            $("#editDepositform").append("<input type='hidden' name='token' value='" + token + "' />");
            console.log(token);
            //submit form to the server
            $("#editDepositform").submit();
        }
    }

    function stripePay1(e) {
        e.preventDefault();
        var valid = cardValidation1();

        if (valid == true) {
            $("#submit-btn").attr("disabled", true);
            $("#loader").css("display", "inline-block");
            var expire = $("#expire1").val();
            var arr = expire.split("/");
            Stripe.createToken(
                {
                    number: $("#card1").val(),
                    cvc: $("#cvv1").val(),
                    exp_month: arr[0],
                    exp_year: arr[1],
                },
                stripeResponseHandler
            );

            //submit from callback
            return false;
        }
    }
</script>
<script>
    $("#download").click(function () {
        var pdf = new jsPDF("p", "pt", "letter");
        pdf.addHTML($("#invoice"), function () {
            pdf.save("invoice.pdf");
        });
    });

    // This code is collected but useful, click below to jsfiddle link.
</script>

<script src="common/js/moment.min.js"></script>

<script type="text/javascript" src="https://www.2checkout.com/checkout/api/2co.min.js"></script>

@endsection
