@extends('layouts.website.website')
@section('content')

    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <div class="col-md-8 panel bg_container margin_top" id="prescription">
                <div class="bg_prescription">
                    <div class="panel-body">
                        <div class="col-md-8 pull-left top_title">
                            <h2 class="doctor">{{ $prescription->doctor->name }}</h2>
                            <h4>
                                {{ $prescription->doctor->department->name }}
                                {{ $prescription->doctor->profile }}
                            </h4>
                        </div>
                        <div class="col-md-4 pull-right text-right top_logo"><img src="/tlogo.png" style="width:100%" /></div>
                    </div>
                    <hr />
                    <div class="panel-body">
                        <div class="">
                            <h5 class="col-md-4 prescription">Date : {{ Carbon\Carbon::parse($prescription->date)->format('d,M Y') }}</h5>
                            <h5 class="col-md-3 prescription">Prescription Id : {{ $prescription->id }}</h5>
                        </div>
                    </div>

                    <hr />
                    <div class="panel-body">
                        <div class="">
                            <h5 class="col-md-4 patient_name">Patient: {{ $prescription->patient->name }}</h5>
                            <h5 class="col-md-3 patient">Patient ID: {{ $prescription->patient->id }}</h5>
                            <h5 class="col-md-3 patient">Age: {{ $prescription->patient->age }}</h5>
                            <h5 class="col-md-2 patient text-right">Gender: {{ $prescription->patient->sex }}</h5>
                        </div>
                    </div>

                    <hr />

                    <div class="col-md-12 clearfix" style="margin: 50px 0px;">
                        <div class="col-md-5 left_panel">
                            <div class="panel-body">
                                <div class="pull-left">
                                    <h5>
                                        <strong>History: </strong> <br />
                                        <br />
                                        {!! $prescription->symtom !!}
                                    </h5>
                                </div>
                            </div>

                            <hr />

                            <div class="panel-body">
                                <div class="pull-left">
                                    <h5>
                                        <strong>Note:</strong> <br />
                                        <br />
                                        {!! $prescription->note !!}
                                    </h5>
                                </div>
                            </div>

                            <hr />

                            <div class="panel-body">
                                <div class="pull-left">
                                    <h5>
                                        <strong>Advice: </strong> <br />
                                        <br />
                                        {!! $prescription->advice !!}
                                    </h5>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-7">
                            <div class="panel-body">
                                <div style="padding-left: 10px;">
                                    <strong style="border-bottom: 1px solid #000;"> Rx </strong>
                                </div>
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <th>Medicine</th>
                                        <th>Instruction</th>
                                        <th class="text-right">Frequency</th>
                                    </thead>
                                    <tbody>
                                        @foreach (App\DoctorPrescriptionMedicine::where('prescription_id',$prescription->id)->get() as $med)
                                            <tr>
                                                <td class="">{{ $med->medicine }} - {{ $med->dosage }}mg</td>
                                                <td class="">{{ $med->days }} - {{ $med->instruction }}</td>
                                                <td class="text-right">{{ $med->frequency }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!--
                    <div class="panel-body">
                        <h5 style="text-align: center;"> <br> <br> </h5>
                    </div>
                    -->
                </div>

                <div class="panel-body prescription_footer">
                    <div class="col-md-4 pull-left" style="font-size: 12px; margin-top: 70px;">
                        <hr />
                        Signature
                    </div>
                    <div class="col-md-8 pull-right text-right">
                        <h3 class="hospital">Hospital</h3>
                        <h5>Ratargul</h5>
                        <h5>+0123456789</h5>
                    </div>
                </div>
            </div>

            <!-- invoice start-->
            <section class="col-md-4 margin_top">
                <div class="panel-primary clearfix">
                    <!--<div class="panel-heading navyblue"> INVOICE</div>-->
                    <div class="panel_button clearfix">
                        <div class="text-center invoice-btn no-print pull-left">
                            <a class="btn btn-info btn-lg invoice_button" onclick="javascript:window.print();"><i class="fa fa-print"></i> Print </a>
                        </div>
                    </div>

                    <div class="panel_button clearfix">
                        <div class="text-center invoice-btn no-print pull-left">
                            <a class="btn btn-info btn-sm detailsbutton pull-left download" id="download"><i class="fa fa-download"></i> Download </a>
                        </div>
                    </div>

                    @if (Auth::user()->role_id == 4)
                        <div class="panel_button clearfix">
                            <div class="text-center invoice-btn no-print pull-left">
                                <a class="btn btn-info btn-lg info" href="{{ route('website_prescription') }}"><i class="fa fa-medkit"></i> All </a>
                            </div>
                        </div>
                    @endif

                    <div class="panel_button">
                        <div class="text-center invoice-btn no-print pull-left">
                            <a class="btn btn-info btn-lg green" href="{{ route('website_prescription_add') }}"><i class="fa fa-plus-circle"></i> Add Prescription </a>
                        </div>
                    </div>
                </div>
            </section>
            <!-- invoice end-->
        </section>
    </section>
    <!--main content end-->

    <style>
        hr {
            margin-top: 0px;
            margin-bottom: 0px;
            border: 0;
            border-top: 1px solid #000;
        }

        .panel-body {
            background: #f1f2f7;
        }

        thead {
            background: transparent;
        }

        .bg_prescription {
            min-height: 760px;
            margin-top: 10px;
        }

        .prescription_footer {
            margin-bottom: 10px;
        }

        .bg_container {
            border: 1px solid #f1f1f1;
        }

        .panel {
            background: #fff;
        }

        .panel-body {
            background: #fff;
        }

        .margin_top {
            margin-top: 65px;
        }

        .wrapper {
            margin: 0px;
            padding: 60px 30px 0px 30px;
        }

        .doctor {
            color: #2f80bf;
        }

        .hospital {
            color: #2f80bf;
        }

        hr {
            border-top: 1px solid #f1f1f1;
        }

        .panel_button {
            margin: 10px;
        }

        .left_panel {
            border-right: 1px solid #ccc;
            margin-left: -15px;
        }

        th {
            border-bottom: 0px;
        }

        .col-md-4 {
            margin-right: 0px !important;
        }

        .patient {
            font-size: 12px;
        }

        .patient_name {
            font-size: 12px;
        }

        .prescription {
            font-size: 12px;
        }

        p {
            font-size: 12px;
        }

        .top_logo {
            margin-bottom: 10px;
        }

        @media print {
            .left_panel {
                border-right: 1px solid #ccc;
                margin-left: -15px;
            }

            .wrapper {
                margin: 0px;
                padding: 0px 10px 0px 0px;
            }

            .patient {
                width: 23%;
                float: left;
            }

            .patient_name {
                width: 31%;
                float: left;
            }

            .text-right {
                float: right;
            }

            .doctor {
                color: #2f80bf !important;
                font-size: 25px;
            }

            .hospital {
                color: #2f80bf !important;
            }

            .prescription {
                float: left;
            }

            .top_title {
                width: 70%;
            }

            .top_logo {
                width: 30%;
                margin-bottom: 10px;
            }

            .col-md-6 {
                width: 50%;
                float: left;
            }

            .col-md-5 {
                width: 45%;
                float: left;
            }

            .col-md-7 {
                width: 55%;
                float: left;
            }

            th {
                border-bottom: 0px;
            }
        }
    </style>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/0.4.1/html2canvas.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.0.272/jspdf.debug.js"></script>

    <script>
        $("#download").click(function () {
            var pdf = new jsPDF("p", "pt", "letter");
            pdf.addHTML($("#prescription"), function () {
                pdf.save("prescription_id_107.pdf");
            });
        });

        // This code is collected but useful, click below to jsfiddle link.
    </script>



@endsection
