@extends('layouts.website.website')
@section('content')
    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="panel">
                <header class="panel-heading">
                    Time Schedule
                    <div class="col-md-4 clearfix pull-right">
                        <a data-toggle="modal" href="#myModal">
                            <div class="btn-group pull-right">
                                <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add
                                    New</button>
                            </div>
                        </a>
                    </div>
                </header>

                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Doctor</th>
                                    <th>Days</th>
                                    <th>Duration</th>
                                    <th>Time</th>
                                    <th>Weekday</th>
                                    <th>Options</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($schedules as $item)
                                    <tr class="">
                                        <td style="">{{ $item->id }}</td>
                                        <td>{{ $item->doctor_id }}</td>
                                        <td>
                                            <ul>
                                                @foreach ($item->time_schedule as $time)
                                                    <li style="margin: 2px 0px">{{ $time->day_name }}</li>
                                                @endforeach
                                            </ul>
                                        </td>
                                        <td>
                                            <ul>
                                                @foreach ($item->time_schedule as $time)
                                                    <li style="margin: 2px 0px">
                                                        {{ Carbon\Carbon::parse($time->start_time)->format('h:i a') }} to
                                                        {{ Carbon\Carbon::parse($time->end_time)->format('h:i a') }}</li>
                                                @endforeach
                                            </ul>
                                        </td>
                                        <td>
                                            <ul>
                                                @foreach ($item->time_schedule as $time)
                                                    <li style="margin: 2px 0px">
                                                        {{ Carbon\Carbon::parse($time->duty_duration)->format('h:i') }} m
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </td>
                                        <td>{{ $item->weekday }}</td>
                                        <td>
                                            <button type="button" class="btn btn-info btn-xs btn_width editbutton"
                                                data-toggle="modal" data-id="{{ $item->id }}"><i class="fa fa-edit"></i>
                                                Edit</button>
                                            <a class="btn btn-info btn-xs btn_width delete_button  delete_button_modal"
                                                data-toggle="modal" data-target="#modal-animation-1" title="Delete"
                                                href="#" data-href="{{ route('delete_doctor_schedule', $item->id) }}">
                                                <i class="fa fa-trash"> </i> Delete
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>
    <!--main content end-->
    <!--footer start-->

    <!-- Add Time Slot Modal-->
    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true"
        style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Add Schedule</h4>
                </div>
                <div class="modal-body row">
                    <form role="form" action="{{ route('store_doctor_schedule') }}" class="clearfix" method="post"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="col-md-6 panel">
                            <label for="exampleInputEmail1"> Doctor</label>
                            <select class="form-control m-bot15" id="doctorchoose" name="doctor" value="">
                                @foreach (App\User::where('role_id', 4)->orderBy('name', 'ASC')->where('status', 1)->get() as $doc)
                                    <option value="{{ $doc->id }}">{{ $doc->name }}</option>
                                @endforeach
                            </select>
                        </div>


                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Select multiple day and time</label>
                            <select class="form-control m-bot15 select2_mul" id="weekday" name="from_day1[]" multiple
                                value="">
                                <option value="Friday">Friday</option>
                                <option value="Saturday">Saturday</option>
                                <option value="Sunday">Sunday</option>
                                <option value="Monday">Monday</option>
                                <option value="Tuesday">Tuesday</option>
                                <option value="Wednesday">Wednesday</option>
                                <option value="Thursday">Thursday</option>
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Start Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control " name="start_time1[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>
                        <div class="form-group bootstrap-timepicker col-md-6">
                            <label for="exampleInputEmail1"> End Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control" name="end_time1[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>


                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Select multiple day and time</label>
                            <select class="form-control m-bot15 select2_mul" id="weekday" name="from_day2[]" multiple
                                value="">
                                <option value="Friday">Friday</option>
                                <option value="Saturday">Saturday</option>
                                <option value="Sunday">Sunday</option>
                                <option value="Monday">Monday</option>
                                <option value="Tuesday">Tuesday</option>
                                <option value="Wednesday">Wednesday</option>
                                <option value="Thursday">Thursday</option>
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Start Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control " name="start_time2[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>
                        <div class="form-group bootstrap-timepicker col-md-6">
                            <label for="exampleInputEmail1"> End Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control" name="end_time2[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>

                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Select multiple day and time</label>
                            <select class="form-control m-bot15 select2_mul" id="weekday" name="from_day3[]" multiple
                                value="">
                                <option value="Friday">Friday</option>
                                <option value="Saturday">Saturday</option>
                                <option value="Sunday">Sunday</option>
                                <option value="Monday">Monday</option>
                                <option value="Tuesday">Tuesday</option>
                                <option value="Wednesday">Wednesday</option>
                                <option value="Thursday">Thursday</option>
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Start Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control " name="start_time3[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>
                        <div class="form-group bootstrap-timepicker col-md-6">
                            <label for="exampleInputEmail1"> End Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control" name="end_time3[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>


                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Select multiple day and time</label>
                            <select class="form-control m-bot15 select2_mul" id="weekday" name="from_day4[]" multiple
                                value="">
                                <option value="Friday">Friday</option>
                                <option value="Saturday">Saturday</option>
                                <option value="Sunday">Sunday</option>
                                <option value="Monday">Monday</option>
                                <option value="Tuesday">Tuesday</option>
                                <option value="Wednesday">Wednesday</option>
                                <option value="Thursday">Thursday</option>
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Start Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control " name="start_time4[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>
                        <div class="form-group bootstrap-timepicker col-md-6">
                            <label for="exampleInputEmail1"> End Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control" name="end_time4[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>


                        <div class="form-group col-md-6" style="display: none;">
                            <label for="exampleInputEmail1"> To Day </label>
                            <select class="form-control m-bot15" id="weekday" name="to_day" value="">
                                <option value="">select</option>
                                <option value="Friday">Friday</option>
                                <option value="Saturday">Saturday</option>
                                <option value="Sunday">Sunday</option>
                                <option value="Monday">Monday</option>
                                <option value="Tuesday">Tuesday</option>
                                <option value="Wednesday">Wednesday</option>
                                <option value="Thursday">Thursday</option>
                            </select>
                        </div>

                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Weekday</label>
                            <select class="form-control m-bot15" id="weekday" name="weekday" value="">
                                <option value="">Select</option>
                                <option value="Friday">Friday</option>
                                <option value="Saturday">Saturday</option>
                                <option value="Sunday">Sunday</option>
                                <option value="Monday">Monday</option>
                                <option value="Tuesday">Tuesday</option>
                                <option value="Wednesday">Wednesday</option>
                                <option value="Thursday">Thursday</option>
                            </select>
                        </div>
                        <div class="clearfix"></div>

                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1">Appointment Duration </label>
                            <select class="form-control m-bot15" name="appoinment_duration" value="">
                                <option value="15"> 15 Minitues </option>

                                <option value="20"> 20 Minitues </option>

                                <option value="30"> 30 Minitues </option>

                                <option value="45"> 45 Minitues </option>

                                <option value="60"> 60 Minitues </option>
                            </select>
                        </div>

                        <input type="hidden" name="redirect" value="schedule" />
                        <input type="hidden" name="id" value="" />

                        <div class="form-group col-md-12">
                            <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Add Time Slot Modal-->

    <!-- Edit Time Slot Modal-->
    <div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
        aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title"><i class="fa fa-plus-circle"></i> Edit Time Slot</h4>
                </div>
                <div class="modal-body">
                    <form role="form" id="editTimeSlotForm" action="{{ route('update_doctor_schedule') }}"
                        method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="col-md-12 panel">
                            <div class="col-md-3 payment_label">
                                <label for="exampleInputEmail1"> Doctor</label>
                            </div>
                            <div class="col-md-9">
                                <select class="form-control m-bot15 js-example-basic-single doctors" name="doctor"
                                    value="">
                                    @foreach (App\User::where('role_id', 4)->orderBy('name', 'ASC')->where('status', 1)->get() as $doc)
                                        <option value="{{ $doc->id }}">{{ $doc->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Select multiple day and time</label>
                            <select class="form-control m-bot15 select2_mul" id="weekday" name="from_day1[]" multiple
                                value="">
                                <option value="Friday">Friday</option>
                                <option value="Saturday">Saturday</option>
                                <option value="Sunday">Sunday</option>
                                <option value="Monday">Monday</option>
                                <option value="Tuesday">Tuesday</option>
                                <option value="Wednesday">Wednesday</option>
                                <option value="Thursday">Thursday</option>
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Start Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control " name="start_time1[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>
                        <div class="form-group bootstrap-timepicker col-md-6">
                            <label for="exampleInputEmail1"> End Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control" name="end_time1[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>


                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Select multiple day and time</label>
                            <select class="form-control m-bot15 select2_mul" id="weekday" name="from_day2[]" multiple
                                value="">
                                <option value="Friday">Friday</option>
                                <option value="Saturday">Saturday</option>
                                <option value="Sunday">Sunday</option>
                                <option value="Monday">Monday</option>
                                <option value="Tuesday">Tuesday</option>
                                <option value="Wednesday">Wednesday</option>
                                <option value="Thursday">Thursday</option>
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Start Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control " name="start_time2[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>
                        <div class="form-group bootstrap-timepicker col-md-6">
                            <label for="exampleInputEmail1"> End Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control" name="end_time2[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>

                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Select multiple day and time</label>
                            <select class="form-control m-bot15 select2_mul" id="weekday" name="from_day3[]" multiple
                                value="">
                                <option value="Friday">Friday</option>
                                <option value="Saturday">Saturday</option>
                                <option value="Sunday">Sunday</option>
                                <option value="Monday">Monday</option>
                                <option value="Tuesday">Tuesday</option>
                                <option value="Wednesday">Wednesday</option>
                                <option value="Thursday">Thursday</option>
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Start Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control " name="start_time3[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>
                        <div class="form-group bootstrap-timepicker col-md-6">
                            <label for="exampleInputEmail1"> End Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control" name="end_time3[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>


                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Select multiple day and time</label>
                            <select class="form-control m-bot15 select2_mul" id="weekday" name="from_day4[]" multiple
                                value="">
                                <option value="Friday">Friday</option>
                                <option value="Saturday">Saturday</option>
                                <option value="Sunday">Sunday</option>
                                <option value="Monday">Monday</option>
                                <option value="Tuesday">Tuesday</option>
                                <option value="Wednesday">Wednesday</option>
                                <option value="Thursday">Thursday</option>
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <div class="form-group col-md-6">
                            <label for="exampleInputEmail1"> Start Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control " name="start_time4[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>
                        <div class="form-group bootstrap-timepicker col-md-6">
                            <label for="exampleInputEmail1"> End Time</label>
                            <div class="input-group bootstrap-timepicker">
                                <input type="time" class="form-control" name="end_time4[]" id="exampleInputEmail1"
                                    value="" />
                            </div>
                        </div>

                        <div class="form-group bootstrap-timepicker">
                            <label for="exampleInputEmail1"> Weekday</label>
                            <div class="input-group bootstrap-timepicker">
                                <select class="form-control m-bot15" id="weekday" name="weekday" value="">
                                    <option value="Friday">Friday</option>
                                    <option value="Saturday">Saturday</option>
                                    <option value="Sunday">Sunday</option>
                                    <option value="Monday">Monday</option>
                                    <option value="Tuesday">Tuesday</option>
                                    <option value="Wednesday">Wednesday</option>
                                    <option value="Thursday">Thursday</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1">Appointment Duration </label>
                            <select class="form-control m-bot15" name="appoinment_duration" value="">
                                <option value="3"> 15 Minitues </option>

                                <option value="4"> 20 Minitues </option>

                                <option value="6"> 30 Minitues </option>

                                <option value="9"> 45 Minitues </option>

                                <option value="12"> 60 Minitues </option>
                            </select>
                        </div>

                        <input type="hidden" name="redirect" value="schedule" />
                        <input type="hidden" name="id" value="" />
                        <button type="submit" name="submit" class="btn btn-info">Submit</button>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Edit Time Slot Modal-->

    <script src="common/js/codearistos.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $(".editbutton").click(function(e) {
                e.preventDefault(e);
                // Get the record's ID via attribute
                var iid = $(this).attr("data-id");
                $("#editTimeSlotForm").trigger("reset");
                $("#myModal2").modal("show");
                $.ajax({
                    url: "/schedule/edit/" + iid,
                    method: "GET",
                    data: "",
                    dataType: "json",
                }).success(function(response) {
                    // Populate the form fields with the data returned from server
                    $("#editTimeSlotForm").find('[name="id"]').val(response.id).end();
                    $("#editTimeSlotForm").find('[name="start_time"]').val(response.start_time)
                        .end();
                    $("#editTimeSlotForm").find('[name="end_time"]').val(response.end_time).end();
                    $("#editTimeSlotForm").find('[name="weekday"]').val(response.weekday).end();
                    $('.js-example-basic-single.doctors').val(response.doctor_id).trigger('change');
                });
            });
        });
    </script>


    <script>
        $(document).ready(function() {
            $("#patientchoose").select2({
                placeholder: "Search Patient Name / ID",
                allowClear: true,
                // ajax: {
                //     url: "patient/getPatientinfo",
                //     type: "post",
                //     dataType: "json",
                //     delay: 250,
                //     data: function (params) {
                //         return {
                //             searchTerm: params.term, // search term
                //         };
                //     },
                //     processResults: function (response) {
                //         return {
                //             results: response,
                //         };
                //     },
                //     cache: true,
                // },
            });
            $("#doctorchoose").select2({
                placeholder: "Search Doctor Name / ID",
                allowClear: true,
                // ajax: {
                //     url: "doctor/getDoctorinfo",
                //     type: "post",
                //     dataType: "json",
                //     delay: 250,
                //     data: function (params) {
                //         return {
                //             searchTerm: params.term, // search term
                //         };
                //     },
                //     processResults: function (response) {
                //         return {
                //             results: response,
                //         };
                //     },
                //     cache: true,
                // },
            });
            $("#doctorchoose1").select2({
                placeholder: "Search Doctor Name / ID",
                allowClear: true,
                // ajax: {
                //     url: "doctor/getDoctorInfo",
                //     type: "post",
                //     dataType: "json",
                //     delay: 250,
                //     data: function (params) {
                //         return {
                //             searchTerm: params.term, // search term
                //         };
                //     },
                //     processResults: function (response) {
                //         return {
                //             results: response,
                //         };
                //     },
                //     cache: true,
                // },
            });
        });
    </script>
@endsection
