@extends('layouts.website.website')
@section('content')
    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="panel">
                <header class="panel-heading">
                    Upcoming Appointments
                    <div class="col-md-4 clearfix pull-right">
                        <div class="pull-right"></div>
                        <a data-toggle="modal" href="#myModal">
                            <div class="btn-group pull-right">
                                <button id="" class="btn green btn-xs pull-right"><i class="fa fa-plus-circle"></i> Add Appointment</button>
                            </div>
                        </a>
                    </div>
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <div class="space15"></div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample1">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Patient</th>
                                    <th>Doctor</th>
                                    <th>Date - Time</th>
                                    <th>Remarks</th>
                                    <th>Status</th>
                                    <th>Options</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (App\DoctorAppoinment::whereDate('appoinment_date','>',Carbon\Carbon::today())->latest()->get() as $item)
                                    <tr>
                                        <td>{{ $item->id }}</td>
                                        @if ($item->patient)
                                            <td>{{ $item->patient->name }}</td>
                                        @else
                                            <td></td>
                                        @endif
                                        @if ($item->doctor)
                                            <td>{{ $item->doctor->name }}</td>
                                        @else
                                            <td></td>
                                        @endif
                                        <td>{{ $item->appoinment_date }} | {{ $item->appoinment_time }}</td>
                                        <td> {{ $item->remarks }}</td>
                                        <td> {{ $item->appoinment_status }}</td>
                                        <td>
                                            <button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="{{$item->id}}">
                                                <i class="fa fa-edit"> Edit</i>
                                            </button>
                                            <a class="btn btn-info btn-xs btn_width delete_button delete_button_modal" data-toggle="modal" data-target="#modal-animation-1" title="Delete" href="#" data-href="{{ route('delete_doctor_appointment',$item->id) }}" >
                                                <i class="fa fa-trash"> </i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                                <style>
                                    .img_url {
                                        height: 20px;
                                        width: 20px;
                                        background-size: contain;
                                        max-height: 20px;
                                        border-radius: 100px;
                                    }
                                </style>
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>
    <!--main content end-->

    @include('hms.appointment_bottom')
@endsection
