<?php
    Route::get('/admin', 'AdminController@index')->name('admin_index')->middleware(['auth','admin']);
    // user routes
    Route::group(['prefix' => 'admin/user', 'namespace' => 'Admin', 'middleware' => ['auth','admin']], function () {
        Route::get('/', 'UserController@index')->name('admin_user_index');

        Route::get('/profile/{id}', 'UserController@profile')->name('admin_user_profile');
        Route::post('/profile/update', 'UserController@profile_update')->name('admin_user_profile_update');

        Route::get('/view', 'UserController@view')->name('admin_user_view');
        Route::get('/edit', 'UserController@edit')->name('admin_user_edit');
        Route::get('/add', 'UserController@add')->name('admin_user_add');
        Route::post('/store', 'UserController@store')->name('admin_user_store');
        Route::post('/update', 'UserController@update')->name('admin_user_update');
        Route::get('/delete/{id}', 'UserController@delete')->name('admin_user_delete');
    });

    Route::group(['prefix' => '/patient', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
        Route::post('/add-patient', 'PatientController@store_patient')->name('store_patient');
    });

    Route::group(['prefix' => '/doctor', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
        Route::post('/add-doctor', 'DoctorController@store_doctor')->name('store_doctor');
    });
