<?php

use Illuminate\Support\Facades\Route;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

// global blade variable
$users = User::where('status',1)->latest()->paginate(12);
View()->share(['users'=>$users]);

// Route::get('/', function () {
//     return view('welcome');
// });

Auth::routes();

Route::get('/home', function(){return redirect('/login-custom');});

Route::get('/login-custom',function(){
    Auth::logout();
    return view('auth.login-custom');
})->middleware('auth');

Route::post('/login_custom_post',function(Request $request){

    $user = User::where('email',$request->email)->first();
    if (isset($user)) {
        Auth::login($user);
        return redirect('/hms');
    }else {
        return redirect('/login-custom');
    }
})->name('login_custom_post');

Route::get('/hms', 'WebsiteController@home')->name('website_home');

Route::group(['prefix' => '/department', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'DepartmentController@department')->name('website_department');
    Route::get('/delete/{id}', 'DepartmentController@delete')->name('delete_department');
    Route::get('/edit/{id}', 'DepartmentController@edit')->name('edit_department');
    Route::post('/add-department', 'DepartmentController@store_department')->name('store_department');
    Route::post('/update-department', 'DepartmentController@update_department')->name('update_department');
});

Route::group(['prefix' => '/doctor', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'DoctorController@doctor')->name('website_doctor');
    Route::get('/delete/{id}', 'DoctorController@delete')->name('delete_doctor');
    Route::get('/edit/{id}', 'DoctorController@edit')->name('edit_doctor');
    Route::post('/add-doctor', 'DoctorController@store_doctor')->name('store_doctor');
    Route::post('/update-doctor', 'DoctorController@update_doctor')->name('update_doctor');
});

Route::group(['prefix' => '/patient', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'PatientController@patient')->name('website_patient');
    Route::get('/delete/{id}', 'PatientController@delete')->name('delete_patient');
    Route::get('/edit/{id}', 'PatientController@edit')->name('edit_patient');
    Route::post('/add-patient', 'PatientController@store_patient')->name('store_patient');
    Route::post('/update-patient', 'PatientController@update_patient')->name('update_patient');

    Route::get('/caseList', 'PatientController@caseList')->name('website_caseList');
    Route::get('/caseList/edit/{id}', 'PatientController@caseListEdit')->name('website_caseListEdit');
    Route::get('/caseList/delete/{id}', 'PatientController@caseListDelete')->name('website_caseListDelete');
    Route::post('/add-caseList', 'PatientController@store_caseList')->name('store_caseList');
    Route::post('/update-caseList', 'PatientController@update_caseList')->name('update_caseList');

    Route::get('/documents', 'PatientController@documents')->name('website_documents');
    Route::get('/document/edit/{id}', 'PatientController@documentEdit')->name('website_documentEdit');
    Route::get('/document/delete/{id}', 'PatientController@documentDelete')->name('website_documentDelete');
    Route::post('/add-document', 'PatientController@store_document')->name('store_document');
    Route::post('/update-document', 'PatientController@update_document')->name('update_document');

    Route::get('/patientPayments', 'PatientController@patientPayments')->name('website_patientPayments');
    Route::get('/patientPaymentsHistory/{id}', 'PatientController@patientPaymentsHistory')->name('website_patientPaymentsHistory');

    Route::get('/medicalHistory', 'PatientController@medicalHistory')->name('website_medicalHistory');

    Route::get('/getMedicalHistoryByJason/{id}', 'PatientController@getMedicalHistoryByJason')->name('website_getMedicalHistoryByJason');
});

Route::group(['prefix' => '/schedule', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'DoctorScheduleController@schedule')->name('website_doctor_schedule');
    Route::get('/delete/{id}', 'DoctorScheduleController@delete')->name('delete_doctor_schedule');
    Route::get('/edit/{id}', 'DoctorScheduleController@edit')->name('edit_doctor_schedule');
    Route::get('/getAvailableSlotByDoctorByDate/{date}/{doctor_id}', 'DoctorScheduleController@getAvailableSlotByDoctorByDate')->name('getAvailableSlotByDoctorByDate_doctor_schedule');
    Route::post('/add-doctor_schedule', 'DoctorScheduleController@store_doctor_schedule')->name('store_doctor_schedule');
    Route::post('/update-doctor_schedule', 'DoctorScheduleController@update_doctor_schedule')->name('update_doctor_schedule');
});

Route::group(['prefix' => '/schedule/allHolidays', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'DoctorHolidayController@allHolidays')->name('website_doctor_schedule_allHolidays');
    Route::get('/delete/{id}', 'DoctorHolidayController@delete')->name('delete_doctor_schedule_holiday');
    Route::get('/edit/{id}', 'DoctorHolidayController@edit')->name('edit_doctor_schedule_holiday');
    Route::post('/add-doctor-schedule-holiday', 'DoctorHolidayController@store_doctor_schedule_holiday')->name('store_doctor_schedule_holiday');
    Route::post('/update-doctor-schedule-holiday', 'DoctorHolidayController@update_doctor_schedule_holiday')->name('update_doctor_schedule_holiday');
});

Route::group(['prefix' => '/hms', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/telecommunication', 'AppoinmentController@telecommunication')->name('telecommunication');
});

Route::group(['prefix' => '/appointment', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'AppoinmentController@appointment')->name('website_appointment');
    Route::get('/delete/{id}', 'AppoinmentController@delete')->name('delete_doctor_appointment');
    Route::get('/edit/{id}', 'AppoinmentController@edit')->name('edit_doctor_appointment');
    Route::post('/add-doctor-appointment', 'AppoinmentController@store_doctor_appointment')->name('store_doctor_appointment');
    Route::post('/update-doctor-appointment', 'AppoinmentController@update_doctor_appointment')->name('update_doctor_appointment');
    Route::post('/accept-doctor-appointment', 'AppoinmentController@accept_doctor_appointment')->name('accept_doctor_appointment');

    Route::get('/addNewView', 'AppoinmentController@addNewView')->name('website_appointment_addNewView');
    Route::get('/todays', 'AppoinmentController@todays')->name('website_appointment_todays');
    Route::get('/upcoming', 'AppoinmentController@upcoming')->name('website_appointment_upcoming');
    Route::get('/calendar', 'AppoinmentController@calendar')->name('website_appointment_calendar');
    Route::get('/request', 'AppoinmentController@request')->name('website_appointment_request');

    Route::get('/meeting', 'AppoinmentController@meeting')->name('website_appointment_meeting');

    Route::get('/treatmentReport', 'AppoinmentController@treatmentReport')->name('website_treatmentReport');
    Route::get('/getAppointmentByDoctorId/{id}', 'AppoinmentController@getAppointmentByDoctorId')->name('getAppointmentByDoctorId_doctor_appointment');
});

Route::group(['prefix' => '/nurse', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'NurseController@nurse')->name('website_nurse');
    Route::get('/delete/{id}', 'NurseController@delete')->name('delete_nurse');
    Route::get('/edit/{id}', 'NurseController@edit')->name('edit_nurse');
    Route::post('/add-nurse', 'NurseController@store_nurse')->name('store_nurse');
    Route::post('/update-nurse', 'NurseController@update_nurse')->name('update_nurse');
});

Route::group(['prefix' => '/pharmacist', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'PharmasistController@pharmacist')->name('website_pharmacist');
    Route::get('/delete/{id}', 'PharmasistController@delete')->name('delete_pharmacist');
    Route::get('/edit/{id}', 'PharmasistController@edit')->name('edit_pharmacist');
    Route::post('/add-pharmacist', 'PharmasistController@store_pharmacist')->name('store_pharmacist');
    Route::post('/update-pharmacist', 'PharmasistController@update_pharmacist')->name('update_pharmacist');
});

Route::group(['prefix' => '/laboratorist', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'LaboratoristController@laboratorist')->name('website_laboratorist');
    Route::get('/delete/{id}', 'LaboratoristController@delete')->name('delete_laboratorist');
    Route::get('/edit/{id}', 'LaboratoristController@edit')->name('edit_laboratorist');
    Route::post('/add-laboratorist', 'LaboratoristController@store_laboratorist')->name('store_laboratorist');
    Route::post('/update-laboratorist', 'LaboratoristController@update_laboratorist')->name('update_laboratorist');
});

Route::group(['prefix' => '/accountant', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'AccountantController@accountant')->name('website_accountant');
    Route::get('/delete/{id}', 'AccountantController@delete')->name('delete_accountant');
    Route::get('/edit/{id}', 'AccountantController@edit')->name('edit_accountant');
    Route::post('/add-accountant', 'AccountantController@store_accountant')->name('store_accountant');
    Route::post('/update-accountant', 'AccountantController@update_accountant')->name('update_accountant');
});

Route::group(['prefix' => '/receptionist', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'ReceptionistController@receptionist')->name('website_receptionist');
    Route::get('/delete/{id}', 'ReceptionistController@delete')->name('delete_receptionist');
    Route::get('/edit/{id}', 'ReceptionistController@edit')->name('edit_receptionist');
    Route::post('/add-receptionist', 'ReceptionistController@store_receptionist')->name('store_receptionist');
    Route::post('/update-receptionist', 'ReceptionistController@update_receptionist')->name('update_receptionist');
});

Route::group(['prefix' => '/prescription', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/all', 'PrescriptionController@prescription')->name('website_prescription');
    Route::get('/add', 'PrescriptionController@add')->name('website_prescription_add');
    Route::get('/view/{id}', 'PrescriptionController@view')->name('website_prescription_view');
    Route::get('/delete/{id}', 'PrescriptionController@delete')->name('delete_prescription');
    Route::get('/edit/{id}', 'PrescriptionController@edit')->name('edit_prescription');
    Route::post('/add-prescription', 'PrescriptionController@store_prescription')->name('store_prescription');
    Route::post('/update-prescription', 'PrescriptionController@update_prescription')->name('update_prescription');
});

Route::group(['prefix' => '/lab', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'DoctorLabController@lab')->name('website_lab');
    Route::get('/view/{id}', 'DoctorLabController@view')->name('website_lab_view');
    Route::get('/delete/{id}', 'DoctorLabController@delete')->name('delete_lab');
    Route::get('/edit/{id}', 'DoctorLabController@edit')->name('edit_lab');
    Route::post('/add-lab', 'DoctorLabController@store_lab')->name('store_lab');
    Route::post('/update-lab', 'DoctorLabController@update_lab')->name('update_lab');

    Route::get('/reports', 'DoctorLabController@lab_reports')->name('website_lab_reports');
});

Route::group(['prefix' => '/notice', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'NoticeController@notice')->name('website_notice');
    Route::get('/edit/{id}', 'NoticeController@notice_edit')->name('website_notice_edit');
    Route::get('/delete/{id}', 'NoticeController@notice_delete')->name('website_notice_delete');
    Route::post('/store', 'NoticeController@notice_store')->name('website_notice_store');
    Route::post('/update', 'NoticeController@notice_update')->name('website_notice_update');

    Route::get('/addNewView', 'NoticeController@notice_addNewView')->name('website_notice_addNewView');
});

Route::group(['prefix' => '/report', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/birth', 'ReportController@report_birth')->name('website_birth_report');
    Route::get('/operation', 'ReportController@report_operation')->name('website_operation_report');
    Route::get('/expire', 'ReportController@report_expire')->name('website_expire_report');

    Route::get('/delete/{id}', 'ReportController@delete')->name('delete_report');
    Route::get('/edit/{id}', 'ReportController@edit')->name('edit_report');
    Route::post('/add-report', 'ReportController@store_report')->name('store_report');
    Route::post('/update-report', 'ReportController@update_report')->name('update_report');
});

Route::group(['prefix' => '/email', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/autoEmailTemplate', 'EmailController@email_autoEmailTemplate')->name('website_email_autoEmailTemplate');
    Route::get('/sendView', 'EmailController@email_sendView')->name('website_email_sendView');
    Route::get('/sent', 'EmailController@email_sent')->name('website_email_sent');
    Route::get('/settings', 'EmailController@email_settings')->name('website_email_settings');
});

Route::group(['prefix' => '/profile', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'ProfileController@profile')->name('website_profile');
    Route::post('/update-profile', 'ProfileController@update_profile')->name('update_profile');
});

Route::group(['prefix' => '/donor', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'DonorController@donor')->name('website_donor');
    Route::get('/delete/{id}', 'DonorController@delete')->name('delete_donor');
    Route::get('/edit/{id}', 'DonorController@edit')->name('edit_donor');
    Route::post('/add-donor', 'DonorController@store_donor')->name('store_donor');
    Route::post('/update-donor', 'DonorController@update_donor')->name('update_donor');

    Route::get('/addDonorView', 'DonorController@addDonorView')->name('website_addDonorView');

    Route::get('/bloodBank', 'DonorController@bloodBank')->name('website_bloodBank');
    Route::get('/bloodBank/edit/{id}', 'DonorController@bloodBankedit')->name('edit_bloodBank');
    Route::post('/bloodBank/update', 'DonorController@bloodBankupdate')->name('update_bloodBank');
});

Route::group(['prefix' => '/finance', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/addPaymentView', 'FinancePaymentController@addPaymentView')->name('website_addPaymentView');
    Route::post('/patient/add_payment', 'FinancePaymentController@patient_add_payment')->name('patient_add_payment');
    Route::post('/patient/add_due_payment_to_invoice', 'FinancePaymentController@patient_add_due_payment_to_invoice')->name('patient_add_due_payment_to_invoice');

    Route::get('/paymentCategory', 'FinancePaymentController@paymentCategory')->name('website_paymentCategory');
    Route::get('/paymentCategoryAdd', 'FinancePaymentController@paymentCategoryAdd')->name('website_paymentCategoryAdd');
    Route::get('/paymentCategoryEdit/{id}', 'FinancePaymentController@paymentCategoryEdit')->name('website_paymentCategoryEdit');
    Route::get('/paymentCategoryDelete/{id}', 'FinancePaymentController@paymentCategoryDelete')->name('website_paymentCategoryDelete');
    Route::post('/paymentCategoryStore', 'FinancePaymentController@paymentCategoryStore')->name('website_paymentCategoryStore');
    Route::post('/paymentCategoryUpdate', 'FinancePaymentController@paymentCategoryUpdate')->name('website_paymentCategoryUpdate');

    Route::get('/expense', 'FinancePaymentController@expense')->name('website_expense');
    Route::get('/expenseEdit/{id}', 'FinancePaymentController@expenseEdit')->name('website_expenseEdit');
    Route::get('/expenseDelete/{id}', 'FinancePaymentController@expenseDelete')->name('website_expenseDelete');
    Route::get('/addExpenseView', 'FinancePaymentController@addExpenseView')->name('website_addExpenseView');
    Route::post('/storeExpense', 'FinancePaymentController@storeExpense')->name('website_storeExpense');
    Route::post('/updateExpense', 'FinancePaymentController@updateExpense')->name('website_updateExpense');

    Route::get('/expenseCategory', 'FinancePaymentController@expenseCategory')->name('website_expenseCategory');
    Route::get('/expenseCategoryAdd', 'FinancePaymentController@expenseCategoryAdd')->name('website_expenseCategoryAdd');
    Route::get('/expenseCategoryEdit/{id}', 'FinancePaymentController@expenseCategoryEdit')->name('website_expenseCategoryEdit');
    Route::get('/expenseCategoryDelete/{id}', 'FinancePaymentController@expenseCategoryDelete')->name('website_expenseCategoryDelete');
    Route::post('/expenseCategoryStore', 'FinancePaymentController@expenseCategoryStore')->name('website_expenseCategoryStore');
    Route::post('/expenseCategoryUpdate', 'FinancePaymentController@expenseCategoryUpdate')->name('website_expenseCategoryUpdate');

});

Route::group(['prefix' => '/pharmacy', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/home', 'PharmacistController@pharmacy')->name('website_pharmacy');
    Route::get('/payment', 'PharmacistController@farmacy_payment')->name('website_payment');

    Route::get('/addPaymentView', 'PharmacistController@farmacy_addPaymentView')->name('website_farmacy_addPaymentView');
    Route::get('/paymentViewEdit/{id}', 'PharmacistController@farmacy_addPaymentViewEdit')->name('website_farmacy_addPaymentViewEdit');
    Route::get('/paymentViewInvoice/{id}', 'PharmacistController@farmacy_PaymentViewInvoice')->name('website_farmacy_PaymentViewInvoice');
    Route::post('/addPayment/submit', 'PharmacistController@farmacy_addPayment_submit')->name('website_farmacy_addPayment_submit');
    Route::post('/editPayment/submit', 'PharmacistController@farmacy_editPayment_submit')->name('website_farmacy_editPayment_submit');

    Route::get('/expense', 'PharmacistController@farmacy_expense')->name('website_expense');
    Route::get('/addExpenseView', 'PharmacistController@farmacy_addExpenseView')->name('website_addExpenseView');
    Route::get('/expenseCategory', 'PharmacistController@farmacy_expenseCategory')->name('website_expenseCategory');

    Route::get('/financialReport', 'PharmacistController@farmacy_financialReport')->name('website_financialReport');
    Route::get('/monthly', 'PharmacistController@farmacy_monthly')->name('website_monthly');
    Route::get('/daily', 'PharmacistController@farmacy_daily')->name('website_daily');
    Route::get('/monthlyExpense', 'PharmacistController@farmacy_monthlyExpense')->name('website_monthlyExpense');
    Route::get('/dailyExpense', 'PharmacistController@farmacy_dailyExpense')->name('website_dailyExpense');
});

Route::group(['prefix' => '/medicine', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'MadicineController@medicine')->name('website_medicine');

    Route::get('/medicineStockAlert', 'MadicineController@medicineStockAlert')->name('website_medicineStockAlert');

    Route::get('/medicineDelete/{id}', 'MadicineController@medicineDelete')->name('website_medicineDelete');
    Route::get('/medicineEdit/{id}', 'MadicineController@medicineEdit')->name('website_medicineEdit');
    Route::get('/addMedicineView', 'MadicineController@addMedicineView')->name('website_addMedicineView');
    Route::post('/medicineStore', 'MadicineController@medicineStore')->name('website_medicineStore');
    Route::post('/medicineUpdate', 'MadicineController@medicineUpdate')->name('website_medicineUpdate');
    Route::post('/medicineQtyUpdate', 'MadicineController@medicineQtyUpdate')->name('website_medicineQtyUpdate');

    Route::get('/addCategoryView', 'MadicineController@addCategoryView')->name('website_addCategoryView');
    Route::get('/medicineCategory', 'MadicineController@medicineCategory')->name('website_medicineCategory');
    Route::get('/medicineCategoryEdit/{id}', 'MadicineController@medicineCategoryEdit')->name('website_medicineCategoryEdit');
    Route::get('/medicineCategoryDelete/{id}', 'MadicineController@medicineCategoryDelete')->name('website_medicineCategoryDelete');
    Route::post('/medicineCategoryStore', 'MadicineController@medicineCategoryStore')->name('website_medicineCategoryStore');
    Route::post('/medicineCategoryUpdate', 'MadicineController@medicineCategoryUpdate')->name('website_medicineCategoryUpdate');
});

Route::group(['prefix' => '/bed', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
    Route::get('/', 'BedController@bed')->name('website_bed');
    Route::get('/bedEdit/{id}', 'BedController@bedEdit')->name('website_bedEdit');
    Route::get('/bedDelete/{id}', 'BedController@bedDelete')->name('website_bedDelete');
    Route::post('/bedStore', 'BedController@bedStore')->name('website_bedStore');
    Route::post('/bedUpdate', 'BedController@bedUpdate')->name('website_bedUpdate');

    Route::get('/addBedView', 'BedController@addBedView')->name('website_addBedView');
    Route::get('/addAllotmentView', 'BedController@addAllotmentView')->name('website_addAllotmentView');

    Route::get('/bedAllotment', 'BedController@bedAllotment')->name('website_bedAllotment');
    Route::get('/bedAllotmentEdit/{id}', 'BedController@bedAllotmentEdit')->name('website_bedAllotmentEdit');
    Route::get('/bedAllotmentDelete/{id}', 'BedController@bedAllotmentDelete')->name('website_bedAllotmentDelete');
    Route::post('/bedAllotmentStore', 'BedController@bedAllotmentStore')->name('website_bedAllotmentStore');
    Route::post('/bedAllotmentUpdate', 'BedController@bedAllotmentUpdate')->name('website_bedAllotmentUpdate');

    Route::get('/bedCategory', 'BedController@bedCategory')->name('website_bedCategory');
    Route::get('/bedCategoryEdit/{id}', 'BedController@bedCategoryEdit')->name('website_bedCategoryEdit');
    Route::get('/bedCategoryDelete/{id}', 'BedController@bedCategoryDelete')->name('website_bedCategoryDelete');
    Route::post('/bedCategoryStore', 'BedController@bedCategoryStore')->name('website_bedCategoryStore');
    Route::post('/bedCategoryUpdate', 'BedController@bedCategoryUpdate')->name('website_bedCategoryUpdate');
});

Route::get('/finance/financialReport', 'WebsiteController@finance_financialReport')->name('website_financialReport');
Route::get('/finance/UserActivityReport', 'WebsiteController@finance_UserActivityReport')->name('website_UserActivityReport');
Route::get('/finance/AllUserActivityReport', 'WebsiteController@finance_AllUserActivityReport')->name('website_AllUserActivityReport');
Route::get('/finance/doctorsCommission', 'WebsiteController@finance_doctorsCommission')->name('website_doctorsCommission');
Route::get('/finance/monthly', 'WebsiteController@finance_monthly')->name('website_monthly');
Route::get('/finance/daily', 'WebsiteController@finance_daily')->name('website_daily');
Route::get('/finance/monthlyExpense', 'WebsiteController@finance_monthlyExpense')->name('website_monthlyExpense');
Route::get('/finance/dailyExpense', 'WebsiteController@finance_dailyExpense')->name('website_dailyExpense');

// Route::group(['prefix' => '/lab', 'namespace' => 'Hms', 'middleware' => ['auth']], function () {
//
//     Route::get('/template', 'WebsiteController@template')->name('website_template');
// });


// Route::get('/patient/patientPayments', 'WebsiteController@patientPayments')->name('website_patientPayments');

Route::get('/finance/payment', 'WebsiteController@payment')->name('website_payment');



Route::get('/sms/autoSMSTemplate', 'WebsiteController@sms_autoSMSTemplate')->name('website_sms_autoSMSTemplate');
Route::get('/sms/sendView', 'WebsiteController@sms_sendView')->name('website_sms_sendView');
Route::get('/sms/sent', 'WebsiteController@sms_sent')->name('website_sms_sent');
Route::get('/sms/setting', 'WebsiteController@sms_setting')->name('website_sms_setting');

// Route::get('/frontend/settings', 'WebsiteController@frontend_setting')->name('website_frontend_setting');
// Route::get('/frontend/slide', 'WebsiteController@frontend_slide')->name('website_frontend_slide');
// Route::get('/frontend/service', 'WebsiteController@frontend_service')->name('website_frontend_service');
// Route::get('/frontend/featured', 'WebsiteController@frontend_featured')->name('website_frontend_featured');

Route::get('/system/settings', 'WebsiteController@system_settings')->name('website_system_settings');
Route::get('/system/pgateway', 'WebsiteController@system_pgateway')->name('website_system_pgateway');
Route::get('/system/language', 'WebsiteController@system_language')->name('website_system_language');
Route::get('/system/import', 'WebsiteController@system_import')->name('website_system_import');

Route::get('/system/profile', 'WebsiteController@profile')->name('website_profile');


include_once('user_route.php');

include_once('hms_management_route.php');

include_once('frontend_route.php');

include_once('frontend_management_route.php');

// custom sign up for client

// default login
Route::get('/login',function(){
    return view('auth.login');
})->name('login');
