<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

use Mockery as m;
use PHPUnit\Framework\TestCase;

class IseedTest extends TestCase
{
    protected static $stubsDir, $testStubsDir;

    public static function setUpBeforeClass(): void
    {
        parent::setUpBeforeClass();

        static::$stubsDir = __DIR__.'/../src/Orangehill/Iseed/stubs';
        static::$testStubsDir = __DIR__.'/stubs';
    }

    public function tearDown(): void
    {
        m::close();
    }

    public function testPopulatesStub()
    {
        $composer = m::mock('Composer')->makePartial();

        $productionStub = $this->readStubFile(static::$stubsDir.'/seed.stub');

        $testStubs = [
            'blank' => [
                'content' => $this->readStubFile(static::$testStubsDir.'/seed_blank.stub'),
                'data' => [],
            ],
            'entries_5' => [
                'content' => $this->readStubFile(static::$testStubsDir.'/seed_5.stub'),
                'data' => [
                    [
                        'id' => '1',
                        'time' => '2013-10-18 14:28:51',
                    ],
                    [
                        'id' => '2',
                        'time' => '2013-10-18 14:28:51',
                    ],
                    [
                        'id' => '3',
                        'time' => '2013-10-18 14:28:51',
                    ],
                    [
                        'id' => '4',
                        'time' => '2013-10-18 14:28:51',
                    ],
                    [
                        'id' => '5',
                        'time' => '2013-10-18 14:28:51',
                    ],
                ],
            ],
            'entries_505' => [
                'content' => $this->readStubFile(static::$testStubsDir.'/seed_505.stub'),
                'data' => [
                    [
                        'id' => '1',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '2',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '3',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '4',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '5',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '6',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '7',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '8',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '9',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '10',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '11',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '12',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '13',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '14',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '15',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '16',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '17',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '18',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '19',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '20',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '21',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '22',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '23',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '24',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '25',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '26',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '27',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '28',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '29',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '30',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '31',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '32',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '33',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '34',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '35',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '36',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '37',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '38',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '39',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '40',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '41',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '42',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '43',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '44',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '45',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '46',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '47',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '48',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '49',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '50',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '51',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '52',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '53',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '54',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '55',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '56',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '57',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '58',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '59',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '60',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '61',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '62',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '63',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '64',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '65',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '66',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '67',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '68',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '69',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '70',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '71',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '72',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '73',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '74',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '75',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '76',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '77',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '78',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '79',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '80',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '81',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '82',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '83',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '84',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '85',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '86',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '87',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '88',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '89',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '90',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '91',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '92',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '93',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '94',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '95',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '96',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '97',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '98',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '99',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '100',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '101',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '102',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '103',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '104',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '105',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '106',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '107',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '108',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '109',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '110',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '111',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '112',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '113',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '114',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '115',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '116',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '117',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '118',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '119',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '120',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '121',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '122',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '123',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '124',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '125',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '126',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '127',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '128',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '129',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '130',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '131',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '132',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '133',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '134',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '135',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '136',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '137',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '138',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '139',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '140',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '141',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '142',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '143',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '144',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '145',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '146',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '147',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '148',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '149',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '150',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '151',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '152',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '153',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '154',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '155',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '156',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '157',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '158',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '159',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '160',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '161',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '162',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '163',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '164',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '165',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '166',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '167',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '168',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '169',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '170',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '171',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '172',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '173',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '174',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '175',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '176',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '177',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '178',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '179',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '180',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '181',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '182',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '183',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '184',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '185',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '186',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '187',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '188',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '189',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '190',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '191',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '192',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '193',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '194',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '195',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '196',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '197',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '198',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '199',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '200',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '201',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '202',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '203',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '204',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '205',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '206',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '207',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '208',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '209',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '210',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '211',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '212',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '213',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '214',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '215',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '216',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '217',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '218',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '219',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '220',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '221',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '222',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '223',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '224',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '225',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '226',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '227',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '228',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '229',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '230',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '231',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '232',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '233',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '234',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '235',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '236',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '237',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '238',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '239',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '240',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '241',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '242',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '243',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '244',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '245',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '246',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '247',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '248',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '249',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '250',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '251',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '252',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '253',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '254',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '255',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '256',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '257',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '258',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '259',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '260',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '261',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '262',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '263',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '264',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '265',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '266',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '267',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '268',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '269',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '270',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '271',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '272',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '273',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '274',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '275',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '276',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '277',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '278',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '279',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '280',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '281',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '282',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '283',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '284',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '285',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '286',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '287',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '288',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '289',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '290',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '291',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '292',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '293',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '294',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '295',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '296',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '297',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '298',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '299',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '300',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '301',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '302',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '303',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '304',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '305',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '306',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '307',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '308',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '309',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '310',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '311',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '312',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '313',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '314',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '315',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '316',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '317',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '318',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '319',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '320',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '321',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '322',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '323',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '324',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '325',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '326',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '327',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '328',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '329',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '330',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '331',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '332',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '333',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '334',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '335',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '336',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '337',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '338',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '339',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '340',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '341',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '342',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '343',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '344',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '345',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '346',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '347',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '348',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '349',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '350',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '351',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '352',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '353',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '354',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '355',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '356',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '357',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '358',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '359',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '360',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '361',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '362',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '363',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '364',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '365',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '366',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '367',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '368',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '369',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '370',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '371',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '372',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '373',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '374',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '375',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '376',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '377',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '378',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '379',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '380',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '381',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '382',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '383',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '384',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '385',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '386',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '387',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '388',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '389',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '390',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '391',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '392',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '393',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '394',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '395',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '396',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '397',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '398',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '399',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '400',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '401',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '402',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '403',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '404',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '405',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '406',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '407',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '408',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '409',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '410',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '411',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '412',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '413',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '414',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '415',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '416',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '417',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '418',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '419',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '420',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '421',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '422',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '423',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '424',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '425',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '426',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '427',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '428',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '429',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '430',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '431',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '432',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '433',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '434',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '435',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '436',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '437',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '438',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '439',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '440',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '441',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '442',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '443',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '444',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '445',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '446',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '447',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '448',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '449',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '450',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '451',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '452',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '453',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '454',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '455',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '456',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '457',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '458',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '459',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '460',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '461',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '462',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '463',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '464',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '465',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '466',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '467',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '468',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '469',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '470',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '471',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '472',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '473',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '474',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '475',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '476',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '477',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '478',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '479',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '480',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '481',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '482',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '483',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '484',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '485',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '486',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '487',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '488',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '489',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '490',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '491',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '492',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '493',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '494',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '495',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '496',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '497',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '498',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '499',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '500',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '501',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '502',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '503',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '504',
                        'time' => '2013-10-18 14:31:24',
                    ],
                    [
                        'id' => '505',
                        'time' => '2013-10-18 14:31:24',
                    ],
                ],
            ],
        ];

        $iSeed = new Orangehill\Iseed\Iseed();
        foreach ($testStubs as $key => $stub) {
            $output = $iSeed->populateStub('test_class', $productionStub, 'test_table', $stub['data'], 500);
            $this->assertEquals($stub['content'], $output, "Stub {$key} is not what it's expected to be.");
        }
    }

    public function readStubFile($file)
    {
        $buffer = file($file, FILE_IGNORE_NEW_LINES);

        return implode(PHP_EOL, $buffer);
    }

    public function testTableNotFoundException()
    {
        $this->expectException(\Orangehill\Iseed\TableNotFoundException::class);
        $this->expectExceptionMessage('Table nonexisting was not found.');

        $hasTable = m::mock('Orangehill\Iseed\Iseed[hasTable]')->makePartial();
        $hasTable->shouldReceive('hasTable')->once()->andReturn(false);
        $hasTable->generateSeed('nonexisting', null, null, 'database', 'numOfRows');
    }

    public function testRepacksSeedData()
    {
        $data = [
            ['id' => '1', 'name' => 'one'],
            ['id' => '2', 'name' => 'two'],
        ];
        $iseed = new Orangehill\Iseed\Iseed();
        $output = $iseed->repackSeedData($data);
        $this->assertEquals(json_encode($data), json_encode($output));
    }

    public function testCanGenerateClassName()
    {
        $iseed = new Orangehill\Iseed\Iseed();
        $output = $iseed->generateClassName('tablename');
        $this->assertEquals('TablenameTableSeeder', $output);
    }

    public function testCanGetStubPath()
    {
        $iseed = new Orangehill\Iseed\Iseed();
        $output = $iseed->getStubPath();
        $expected = substr(__DIR__, 0, -5).'src'.DIRECTORY_SEPARATOR.'Orangehill'.DIRECTORY_SEPARATOR.'Iseed'.DIRECTORY_SEPARATOR.'stubs';
        $this->assertEquals($expected, $output);
    }

    public function testCanGenerateSeed()
    {
        $file = m::mock(\Illuminate\Filesystem\Filesystem::class)->makePartial();
        $composer = m::mock(\Illuminate\Support\Composer::class, [$file])->makePartial();
        $mocked = m::mock(\Orangehill\Iseed\Iseed::class, [$file, $composer])->makePartial();
        $mocked->shouldReceive('readStubFile')
               ->once()
               ->with(substr(__DIR__, 0, -5).'src'.DIRECTORY_SEPARATOR.'Orangehill'.DIRECTORY_SEPARATOR.'Iseed'.DIRECTORY_SEPARATOR.'stubs'.DIRECTORY_SEPARATOR.'seed.stub');
        $file->shouldReceive('put')->once()->with('seedPath', 'populatedStub');
        $mocked->shouldReceive('hasTable')->once()->andReturn(true);
        $mocked->shouldReceive('getData')->once()->andReturn([]);
        $mocked->shouldReceive('generateClassName')->once()->andReturn('ClassName');
        $mocked->shouldReceive('getSeedPath')->once()->andReturn('seedPath');
        $mocked->shouldReceive('getPath')->once()->with('ClassName', 'seedPath')->andReturn('seedPath');
        $mocked->shouldReceive('populateStub')->once()->andReturn('populatedStub');
        $mocked->shouldReceive('updateDatabaseSeederRunMethod')->once()->with('ClassName')->andReturn(true);
        $composer->shouldReceive('dumpAutoloads')->once();
        $mocked->generateSeed('tablename', null, null, 'database', 'numOfRows');
    }
}
